/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HEXDECODER_H_
#define HEXDECODER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>
#include <string>
#include <stddef.h>

class HexDecoder
{
public:
	HexDecoder();
	
	bool feed(char const* str, size_t len);
	
	bool feed(std::string const& str) {
		return feed(str.c_str(), str.length());
	}
	
	bool finalize() { return !m_badInput && !m_haveLeftover; }
	
	void reset();
	
	std::vector<unsigned char>& buffer() { return m_buf; }
	
	std::vector<unsigned char> const& buffer() const { return m_buf; }
private:
	std::vector<unsigned char> m_buf;
	unsigned char m_leftover;
	bool m_haveLeftover:1;
	bool m_badInput:1;
};

#endif
