/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FLAGS_H_
#define FLAGS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

template<typename Enum>
class Flags
{
public:
	Flags() : m_flags(0) {}
	
	explicit Flags(Enum f) : m_flags(f) {}
	
	// Default copy ctor and assignment operator OK
	
	int intValue() const { return m_flags; }
	
	Flags& operator|=(Flags const& f) { m_flags |= f.m_flags; return *this; }
	
	Flags& operator&=(Flags const& f) { m_flags &= f.m_flags; return *this; }
	
	Flags& operator^=(Flags const& f) { m_flags ^= f.m_flags; return *this; }
	
	bool operator==(Flags const& f) const { return m_flags == f.m_flags; }
	
	bool operator!=(Flags const& f) const { return m_flags != f.m_flags; }
	
	void set(Flags const& f) { m_flags |= f.m_flags; }
	
	void set(Enum flag) { m_flags |= flag; }
	
	void clear(Flags const& f) { m_flags &= ~f.m_flags; }
	
	void clear(Enum flag) { m_flags &= ~flag; }
	
	void clear() { m_flags = 0; }
	
	bool isSet(Enum f) const { return m_flags & f; }
private:
	int m_flags;
};

#define DEFINE_FLAG_OPS_3(Op, Arg1, Arg2) \
template<typename Enum> \
inline Flags<Enum> operator Op (Arg1 f1, Arg2 f2) \
{ \
	Flags<Enum> res(f1); \
	res Op##= f2; \
	return res; \
}

#define DEFINE_FLAG_OPS_1(Op) \
DEFINE_FLAG_OPS_3(Op, Flags<Enum> const&, Flags<Enum> const&) \
DEFINE_FLAG_OPS_3(Op, Flags<Enum> const&, Enum) \
DEFINE_FLAG_OPS_3(Op, Enum, Flags<Enum> const&)

DEFINE_FLAG_OPS_1(|)
DEFINE_FLAG_OPS_1(&)
DEFINE_FLAG_OPS_1(^)

#endif
