MACRO(BF_SET_DEFAULT_MSVC_FLAGS)
	IF(MSVC AND NOT MSVC_DEFAULT_FLAGS_SET_)
		SET(MSVC_DEFAULT_FLAGS_SET TRUE CACHE INTERNAL "" FORCE)
		SET(wds_ "/wd4258 /wd4355 /wd4244 /wd4800")
		
		# Flags common for all build configurations
		SET(
			CMAKE_C_FLAGS
			"/DWIN32 /D_WINDOWS /MT /Zc:forScope ${wds_}"
			CACHE STRING "Common C flags for all build configurations." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS
			"/DWIN32 /D_WINDOWS /EHsc /GR /MT /Zc:forScope ${wds_}"
			CACHE STRING "Common C++ flags for all build configurations." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS "/MANIFEST:NO"
			CACHE STRING "Common link flags for all build configurations." FORCE
		)
		SET(
			CMAKE_SHARED_LINKER_FLAGS "/MANIFEST:NO"
			CACHE STRING "Common link flags for all build configurations." FORCE
		)
		SET(
			CMAKE_CXX_WARNING_LEVEL 2
			CACHE STRING "Default compiler warning level for C++" FORCE
		)
		
		# Release
		SET(
			CMAKE_C_FLAGS_RELEASE "/O2 /GL"
			CACHE STRING "C flags for Release builds." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS_RELEASE "/O2 /GL"
			CACHE STRING "C++ flags for Release builds." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS_RELEASE
			"/OPT:ICF /OPT:REF /LTCG /INCREMENTAL:NO"
			CACHE STRING "Link flags for Release buils." FORCE
		)
		
		# MinSizeRel
		SET(
			CMAKE_C_FLAGS_MINSIZEREL "/O1 /Oi /GL"
			CACHE STRING "C flags for MinSizeRel builds." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS_MINSIZEREL "/O1 /Oi /GL"
			CACHE STRING "C++ flags for MinSizeRel builds." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS_MINSIZEREL
			"/OPT:ICF /OPT:REF /LTCG /INCREMENTAL:NO"
			CACHE STRING "Link flags for MinSizeRel builds." FORCE
		)
		
		# RelWithDebInfo
		SET(
			CMAKE_C_FLAGS_RELWITHDEBINFO "/O2 /Zi"
			CACHE STRING "C flags for RelWithDebInfo builds." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS_RELWITHDEBINFO "/O2 /Zi"
			CACHE STRING "C++ flags for RelWithDebInfo builds." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS_RELWITHDEBINFO
			"/OPT:REF /OPT:NOICF /DEBUG /INCREMENTAL:YES"
			CACHE STRING "Link flags for RelWithDebInfo builds." FORCE
		)
		
		# Debug
		SET(
			CMAKE_C_FLAGS_DEBUG "/Od /Zi"
			CACHE STRING "C flags for Debug builds." FORCE
		)
		SET(
			CMAKE_CXX_FLAGS_DEBUG "/Od /Zi"
			CACHE STRING "C++ flags for Debug builds." FORCE
		)
		SET(
			CMAKE_EXE_LINKER_FLAGS_DEBUG
			"/OPT:NOREF /OPT:NOICF /DEBUG /INCREMENTAL:YES"
			CACHE STRING "Link flags for Debug builds." FORCE
		)
		
		ADD_DEFINITIONS(
			-DNOMINMAX -D_SECURE_SCL=0 -D_HAS_ITERATOR_DEBUGGING=0
			-D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE
		)
	ENDIF(MSVC AND NOT MSVC_DEFAULT_FLAGS_SET_)
ENDMACRO(BF_SET_DEFAULT_MSVC_FLAGS)
