# - Locate zlib library
# This module defines
#  ZLIB_FOUND -- true if zlib was found
#  ZLIB_LIBRARY -- the library to link against
#  ZLIB_INCLUDE_DIR -- path to zlib.h
MACRO(BF_FIND_ZLIB)
	GET_FILENAME_COMPONENT(parent_dir_ "${PROJECT_SOURCE_DIR}/.." ABSOLUTE)
	FILE(GLOB zlib_dirs_ "${parent_dir_}/zlib-*.*.*[0-9]")
	FIND_PATH(
		ZLIB_INCLUDE_DIR zlib.h
		PATHS /usr/include /usr/local/include
		"${CMAKE_INSTALL_PREFIX}/include" ${zlib_dirs_}
		DOC "Path to zlib.h"
	)
	FIND_LIBRARY(
		ZLIB_LIBRARY NAMES z zlib
		PATHS /usr/include /usr/local/include
		"${CMAKE_INSTALL_PREFIX}/lib" ${zlib_dirs_}
		DOC "Path to zlib library file"
	)
	IF(WX_INCLUDE_DIR AND WX_LIBRARY)
		SET(WX_FOUND TRUE)
	ELSE(WX_INCLUDE_DIR AND WX_LIBRARY)
		SET(WX_FOUND FALSE)
	ENDIF(WX_INCLUDE_DIR AND WX_LIBRARY)
ENDMACRO(BF_FIND_ZLIB)
