/* relational.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__FILE_UTILS__RELATIONAL_H
#define INCLUDE__FILE_UTILS__RELATIONAL_H


#include "hackerlab/machine/types.h"



typedef t_uchar * rel_field;
typedef rel_field * rel_record;
typedef rel_record * rel_table;


struct rel_join_output_spec
{
  int file;
  int field;
};

typedef int * rel_cut_spec;



/* automatically generated __STDC__ prototypes */
extern rel_record rel_read_record (int fd, int n_fields, char * err_name, char * err_src);
extern rel_table rel_read_table (int fd, int n_fields, char * err_name, char * err_src);
extern void rel_print_record (int fd, rel_record rec);
extern void rel_print_table (int fd, rel_table file);
extern void rel_print_record_sp (int fd, rel_record rec);
extern void rel_print_table_sp (int fd, rel_table file);
extern rel_table rel_ws_split (t_uchar * string);
extern rel_table rel_nl_split (t_uchar * string);
extern void rel_reverse_table (rel_table t);
extern int rel_n_fields (rel_record r);
extern int rel_n_records (rel_table r);
extern rel_record rel_copy_record (rel_record r);
extern rel_table rel_copy_table (rel_table f);
extern void rel_free_record (rel_record r);
extern void rel_free_table (rel_table t);
extern void rel_sort_table_by_field (int reverse_p, rel_table f, int field);
extern void rel_sort_table_by_field_fn (int reverse_p,
                                        rel_table f,
                                        int field, int (*fn)(void *, void *));
extern int * rel_sort_fields (int f, ...);
extern void rel_sort_table_by_fields (int reverse_p, rel_table f, int * fields);
extern void rel_uniq_by_field (rel_table * table, int field);
extern void rel_add_field (rel_record * r, t_uchar * field);
extern rel_record rel_make_record (t_uchar * field0, ...);
extern rel_record rel_singleton_record_n (t_uchar * start, size_t len);
extern void rel_add_records (rel_table * file, ...);
extern struct rel_join_output_spec * rel_join_output (int file, int field, ...);
extern rel_table rel_join (int v_file,
                           struct rel_join_output_spec * output,
                           int file1_field,
                           int file2_field,
                           rel_table file1,
                           rel_table file2);
extern rel_cut_spec rel_cut_list (int field, ...);
extern rel_record rel_cut_record (rel_cut_spec fields, rel_record r);
extern rel_table rel_cut (rel_cut_spec fields, rel_table t);
extern void rel_append_x (rel_table * out, rel_table t);
#endif  /* INCLUDE__FILE_UTILS__RELATIONAL_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (relational.h)
 */
