/* $Id: dtostrf-big.c,v 1.1 2007/02/06 12:36:58 dmix Exp $ */

#include <stdlib.h>
#include <string.h>
#include "progmem.h"

#define PATTERN_SIZE	270
#include "dtostrf.h"

PROGMEM static const struct dtostrf_s t[] = {

    { { .fl = 1.2345678 }, 127, 7,
	"                                "	/* 32 */
	"                                "	/* 32 */
	"                                "	/* 32 */
	"                      1.2345678" },

    { { .fl = 1.2345678 }, -128, 7,
	"1.2345678                       "	/* 32 */
	"                                "	/* 32 */
	"                                "	/* 32 */
	"                                " },

    { { .fl = -1.2345678 }, 127, 7,
	"                                "	/* 32 */
	"                                "	/* 32 */
	"                                "	/* 32 */
	"                     -1.2345678" },

    { { .fl = -1.2345678 }, -128, 7,
	"-1.2345678                      "	/* 32 */
	"                                "	/* 32 */
	"                                "	/* 32 */
	"                                " },

    { { .fl = 12345678. }, 0, 255,
	"12345678."
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"0000000000000000000000000000000" },

    { { .fl = -12345678. }, 0, 255,
	"-12345678."
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"0000000000000000000000000000000" },

    { { .fl = .5 }, 0, 255,
	"0."
	"50000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"00000000000000000000000000000000"	/* 32 */
	"0000000000000000000000000000000" },
};

int main ()
{
    int i;
    for (i= 0; (size_t)i != sizeof(t)/sizeof(t[0]); i++)
	run_dtostrf (t+i, i+1);
    return 0;
}
