/* Test of multiplication. 500 random cases.
   $Id: mul-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases:  x * y = z	*/
    long x, y, z;
} t[] = {

    { 0xbfe203f4, 0x3d0c6491, 0xbd77e5e6 },  /*   1: -1.7657456e+00  3.4275595e-02 -6.0521983e-02 */
    { 0x3d7f2278, 0xbfdd0e99, 0xbddc4f4e },  /*   2:  6.2288731e-02 -1.7270080e+00 -1.0757314e-01 */
    { 0xc1a0fa4a, 0xc0c34e6d, 0x42f59fee },  /*   3: -2.0122211e+01 -6.1033235e+00  1.2281237e+02 */
    { 0x3fe8a719, 0x3f2248fd, 0x3f937c13 },  /*   4:  1.8175994e+00  6.3392621e-01  1.1522239e+00 */
    { 0xbef9cb09, 0x40606088, 0xbfdaefd9 },  /*   5: -4.8787716e-01  3.5058918e+00 -1.7104445e+00 */
    { 0xb9ae9889, 0xccbb97fe, 0x46ffe22b },  /*   6: -3.3301514e-04 -9.8353136e+07  3.2753083e+04 */
    { 0x3f2c7136, 0x3dbf4877, 0x3d80d947 },  /*   7:  6.7360246e-01  9.3399934e-02  6.2914426e-02 */
    { 0x42ce6872, 0xbfe2a74d, 0xc336bf19 },  /*   8:  1.0320399e+02 -1.7707306e+00 -1.8274647e+02 */
    { 0xbf161ea9, 0x3f63bbc5, 0xbf058b4c },  /*   9: -5.8640534e-01  8.8958389e-01 -5.2165674e-01 */
    { 0x3fff906f, 0xb919bc69, 0xb9997969 },  /*  10:  1.9965953e+00 -1.4661405e-04 -2.9272892e-04 */
    { 0x430b4be6, 0xbe339058, 0xc1c36939 },  /*  11:  1.3929648e+02 -1.7535532e-01 -2.4426378e+01 */
    { 0x3d743cfd, 0xc875573e, 0xc66a119a },  /*  12:  5.9628475e-02 -2.5122897e+05 -1.4980400e+04 */
    { 0x3bdbb6e1, 0xc1c05c66, 0xbe251876 },  /*  13:  6.7051505e-03 -2.4045116e+01 -1.6122612e-01 */
    { 0x4149b727, 0x3e0a1bca, 0x3fd9a541 },  /*  14:  1.2607215e+01  1.3487163e-01  1.7003557e+00 */
    { 0xbf33d931, 0x3f39a93c, 0xbf026ed9 },  /*  15: -7.0253283e-01  7.2523856e-01 -5.0950390e-01 */
    { 0x3e424bb9, 0xbd9c6649, 0xbc6d678d },  /*  16:  1.8974198e-01 -7.6366968e-02 -1.4490020e-02 */
    { 0x3fd8db5b, 0xc357ffe9, 0xc3b6f901 },  /*  17:  1.6941942e+00 -2.1599965e+02 -3.6594535e+02 */
    { 0xb7e777ba, 0xc7f1fcc4, 0x405acc41 },  /*  18: -2.7593098e-05 -1.2389753e+05  3.4187167e+00 */
    { 0xbc76d381, 0x3dbe3e5c, 0xbab76d1a },  /*  19: -1.5065075e-02  9.2892379e-02 -1.3994306e-03 */
    { 0xbfce84ce, 0x450f3f9b, 0xc5671efe },  /*  20: -1.6134279e+00  2.2919753e+03 -3.6979369e+03 */
    { 0x4180036a, 0xbfb8766b, 0xc1b87b57 },  /*  21:  1.6001667e+01 -1.4411138e+00 -2.3060224e+01 */
    { 0x43b04c24, 0x80000000, 0x80000000 },  /*  22:  3.5259485e+02 -0.0000000e+00 -0.0000000e+00 */
    { 0xa0b1a0c7, 0xbf10c355, 0x2048e3f1 },  /*  23: -3.0091360e-19 -5.6548053e-01  1.7016078e-19 */
    { 0x4098c317, 0x3a7ffb10, 0x3b98c025 },  /*  24:  4.7738147e+00  9.7648893e-04  4.6615772e-03 */
    { 0xbd5cb803, 0x3d99cbc0, 0xbb8499a5 },  /*  25: -5.3886425e-02  7.5095654e-02 -4.0466363e-03 */
    { 0x3e2f5b92, 0x40bedf06, 0x3f82bebb },  /*  26:  1.7124775e-01  5.9647245e+00  1.0214457e+00 */
    { 0x3d844f62, 0x4107018e, 0x3f0b8d55 },  /*  27:  6.4604536e-02  8.4378796e+00  5.4512529e-01 */
    { 0xbfe7f5e4, 0xbcd23a05, 0x3d3e7c47 },  /*  28: -1.8121915e+00 -2.5662431e-02  4.6505240e-02 */
    { 0xbd38fc30, 0x3e26908b, 0xbbf0b7f3 },  /*  29: -4.5162380e-02  1.6266076e-01 -7.3461471e-03 */
    { 0x3f1435a8, 0x437ed193, 0x43138692 },  /*  30:  5.7894373e-01  2.5481865e+02  1.4752566e+02 */
    { 0x3f0ebb76, 0xbf2765c8, 0xbebaaa13 },  /*  31:  5.5754793e-01 -6.5389681e-01 -3.6457881e-01 */
    { 0x400b3df5, 0xc18be3a3, 0xc2182ce9 },  /*  32:  2.1756566e+00 -1.7486151e+01 -3.8043859e+01 */
    { 0xc1501774, 0xbfd6ffba, 0x41aec37a },  /*  33: -1.3005726e+01 -1.6796792e+00  2.1845447e+01 */
    { 0x3f1b0003, 0xc0ef3cc3, 0xc090d9cd },  /*  34:  6.0546893e-01 -7.4761672e+00 -4.5265869e+00 */
    { 0xc012c0b6, 0x47de7fcc, 0xc87f18c1 },  /*  35: -2.2930121e+00  1.1391959e+05 -2.6121901e+05 */
    { 0x3fa2d6e9, 0x3e4c1d86, 0x3e81d609 },  /*  36:  1.2721835e+00  1.9933137e-01  2.5358609e-01 */
    { 0xba4fd801, 0x3f20ecb9, 0xba02a732 },  /*  37: -7.9286104e-04  6.2861210e-01 -4.9840205e-04 */
    { 0x3e5fd261, 0xc2ccec6c, 0xc1b32a5a },  /*  38:  2.1857597e-01 -1.0246176e+02 -2.2395679e+01 */
    { 0x3e1616b3, 0xbfd9a664, 0xbe7f3596 },  /*  39:  1.4657097e-01 -1.7003903e+00 -2.4922785e-01 */
    { 0xc4d191d2, 0x461afc54, 0xcb7dc091 },  /*  40: -1.6765569e+03  9.9190820e+03 -1.6629905e+07 */
    { 0xbdc7faed, 0xbe2c70c4, 0x3c86b4ae },  /*  41: -9.7646572e-02 -1.6839892e-01  1.6443577e-02 */
    { 0xc102582c, 0xbfff96a6, 0x41822288 },  /*  42: -8.1465263e+00 -1.9967849e+00  1.6266861e+01 */
    { 0xbf1cd52b, 0x437e57b1, 0xc31bd13a },  /*  43: -6.1262769e-01  2.5434254e+02 -1.5581728e+02 */
    { 0x3f4df077, 0xc2d6895a, 0xc2ac9582 },  /*  44:  8.0445045e-01 -1.0726826e+02 -8.6292004e+01 */
    { 0x4234eab5, 0xbf0e9529, 0xc1c98734 },  /*  45:  4.5229206e+01 -5.5696350e-01 -2.5191017e+01 */
    { 0xbd646647, 0xbfda2054, 0x3dc29bf0 },  /*  46: -5.5761602e-02 -1.7041116e+00  9.5023991e-02 */
    { 0x40d6e7f8, 0x3a9a63ed, 0x3c019b6e },  /*  47:  6.7158165e+00  1.1779048e-03  7.9105923e-03 */
    { 0x39bb4814, 0xc21db359, 0xbc66bcd2 },  /*  48:  3.5721122e-04 -3.9425144e+01 -1.4083104e-02 */
    { 0x46576b94, 0x3ff0f4ac, 0x46cac2be },  /*  49:  1.3786895e+04  1.8824668e+00  2.5953371e+04 */
    { 0x3df1bb6b, 0x3fd536b6, 0x3e495499 },  /*  50:  1.1803325e-01  1.6657321e+00  1.9661178e-01 */
    { 0xc6385e8a, 0x3d822506, 0xc43b7558 },  /*  51: -1.1799635e+04  6.3547179e-02 -7.4983350e+02 */
    { 0xbde281c2, 0xbff3e5b0, 0x3e57cc65 },  /*  52: -1.1059906e-01 -1.9054470e+00  2.1074064e-01 */
    { 0x00000000, 0xbf2c1f58, 0x80000000 },  /*  53:  0.0000000e+00 -6.7235327e-01 -0.0000000e+00 */
    { 0xc5faeef6, 0xbf0850cd, 0x45859e26 },  /*  54: -8.0298701e+03 -5.3248292e-01  4.2757687e+03 */
    { 0xbc1811e2, 0x33cdce68, 0xb07481dc },  /*  55: -9.2816073e-03  9.5836015e-08 -8.8951226e-10 */
    { 0xbfce8e77, 0xbfc1b100, 0x401c4838 },  /*  56: -1.6137227e+00 -1.5132141e+00  2.4419079e+00 */
    { 0x3fd2d11f, 0x3efa0064, 0x3f4de08b },  /*  57:  1.6470069e+00  4.8828423e-01  8.0420748e-01 */
    { 0x3f318f9d, 0x3f0831d2, 0x3ebcedb3 },  /*  58:  6.9359761e-01  5.3201020e-01  3.6900100e-01 */
    { 0x3fef35d1, 0xbdd65365, 0xbe4844ea },  /*  59:  1.8688298e+00 -1.0465125e-01 -1.9557538e-01 */
    { 0xbcdb0af0, 0x44dcc475, 0xc23ce57f },  /*  60: -2.6738614e-02  1.7661393e+03 -4.7224116e+01 */
    { 0x40f7a42f, 0x3e29340b, 0x3fa3adbb },  /*  61:  7.7387919e+00  1.6523759e-01  1.2787393e+00 */
    { 0xbe197271, 0xc5dc7b39, 0x44842835 },  /*  62: -1.4985062e-01 -7.0554028e+03  1.0572565e+03 */
    { 0x3fc767be, 0x4121b15c, 0x417be4ca },  /*  63:  1.5578535e+00  1.0105801e+01  1.5743356e+01 */
    { 0x3f25923c, 0xc4a838f3, 0xc4599999 },  /*  64:  6.4676261e-01 -1.3457797e+03 -8.7039997e+02 */
    { 0xdc2a65de, 0xbdcf4d7b, 0x5a89fbf1 },  /*  65: -1.9185100e+17 -1.0122200e-01  1.9419542e+16 */
    { 0x427c94d4, 0x5f09f8a7, 0x620820fa },  /*  66:  6.3145340e+01  9.9418798e+18  6.2778338e+20 */
    { 0x417b57fb, 0xbb15c9c6, 0xbd131050 },  /*  67:  1.5708980e+01 -2.2855862e-03 -3.5904227e-02 */
    { 0xc16e3b60, 0x3d09e520, 0xbf0052ff },  /*  68: -1.4889496e+01  3.3665776e-02 -5.0126644e-01 */
    { 0x3fbe2a19, 0xbc548ee9, 0xbc9de505 },  /*  69:  1.4856597e+00 -1.2973526e-02 -1.9274244e-02 */
    { 0x39159cfa, 0xbefa8e95, 0xb8926ea0 },  /*  70:  1.4268226e-04 -4.8936906e-01 -6.9824282e-05 */
    { 0xc2666f06, 0xce48cecf, 0x5134c0e4 },  /*  71: -5.7608421e+01 -8.4224915e+08  4.8520644e+10 */
    { 0xc0084430, 0xc1fb4cd8, 0x4285c3c2 },  /*  72: -2.1291618e+00 -3.1412521e+01  6.6882342e+01 */
    { 0x3e4aaa10, 0xbead46ca, 0xbd892cf7 },  /*  73:  1.9791436e-01 -3.3843070e-01 -6.6980297e-02 */
    { 0x3d440ccd, 0xbdf24c24, 0xbbb98e69 },  /*  74:  4.7863770e-02 -1.1830929e-01 -5.6627286e-03 */
    { 0xbf29bc98, 0x3694b352, 0xb6452fda },  /*  75: -6.6303396e-01  4.4316193e-06 -2.9383141e-06 */
    { 0x430c35fb, 0xc23a72f5, 0xc5cc3c5d },  /*  76:  1.4021086e+02 -4.6612263e+01 -6.5355455e+03 */
    { 0x38cfddb8, 0x40ce5d54, 0x3a279032 },  /*  77:  9.9118275e-05  6.4488926e+00  6.3920311e-04 */
    { 0xc130dafb, 0x3d6d7395, 0xbf240a94 },  /*  78: -1.1053462e+01  5.7971556e-02 -6.4078639e-01 */
    { 0x433e0467, 0xc0f1d429, 0xc4b37f9f },  /*  79:  1.9001720e+02 -7.5571485e+00 -1.4359882e+03 */
    { 0x380a973d, 0x3c20d857, 0x34ae274a },  /*  80:  3.3042616e-05  9.8172044e-03  3.2438611e-07 */
    { 0xc0787a55, 0xc234f0af, 0x432f9fa0 },  /*  81: -3.8824666e+00 -4.5235043e+01  1.7562354e+02 */
    { 0xbb1bb91a, 0xbff2498c, 0x3b9361b8 },  /*  82: -2.3761452e-03 -1.8928695e+00  4.4977327e-03 */
    { 0x00000000, 0x3c951307, 0x00000000 },  /*  83:  0.0000000e+00  1.8197550e-02  0.0000000e+00 */
    { 0x3cf7d0ba, 0xbfe3976f, 0xbd5c50ac },  /*  84:  3.0250896e-02 -1.7780589e+00 -5.3787874e-02 */
    { 0xbfbc3ff4, 0x3f2c9b30, 0xbf7dda2c },  /*  85: -1.4707017e+00  6.7424297e-01 -9.9161028e-01 */
    { 0xc0ac280b, 0xbfa21370, 0x40d9fcd3 },  /*  86: -5.3798881e+00 -1.2662182e+00  6.8121121e+00 */
    { 0xc80afa2f, 0xbd5a4526, 0x45ecfd2c },  /*  87: -1.4231273e+05 -5.3288601e-02  7.5836466e+03 */
    { 0xbf269073, 0xbe6a9894, 0x3e18a34f },  /*  88: -6.5064162e-01 -2.2909766e-01  1.4906048e-01 */
    { 0x38b4b0b0, 0xbe0eb24c, 0xb7496fb4 },  /*  89:  8.6159795e-05 -1.3935202e-01 -1.2006542e-05 */
    { 0xc3688fab, 0xbcb49aa1, 0x40a4117d },  /*  90: -2.3256120e+02 -2.2046389e-02  5.1271348e+00 */
    { 0xc0e291f1, 0xbaf06a3c, 0x3c54c6d7 },  /*  91: -7.0803151e+00 -1.8342207e-03  1.2986861e-02 */
    { 0x3204ae58, 0x3e308f22, 0x30b70417 },  /*  92:  7.7230524e-09  1.7242101e-01  1.3316165e-09 */
    { 0x3fe45ca2, 0x80000000, 0x80000000 },  /*  93:  1.7840769e+00 -0.0000000e+00 -0.0000000e+00 */
    { 0xbf1dc70b, 0x41739f52, 0xc1162621 },  /*  94: -6.1631840e-01  1.5226397e+01 -9.3843084e+00 */
    { 0x421aeeb7, 0xc0773c55, 0xc315a0d6 },  /*  95:  3.8733120e+01 -3.8630574e+00 -1.4962826e+02 */
    { 0x3e77968a, 0x3e4cb1cf, 0x3d45f7ed },  /*  96:  2.4178520e-01  1.9989704e-01  4.8332145e-02 */
    { 0xbc0cb1c9, 0xba9592b0, 0x37246830 },  /*  97: -8.5873092e-03 -1.1411514e-03  9.7994200e-06 */
    { 0x415ef3ec, 0xbef3f417, 0xc0d4761e },  /*  98:  1.3934551e+01 -4.7647163e-01 -6.6394184e+00 */
    { 0xbfe59f74, 0xc0e5d610, 0x414e27a4 },  /*  99: -1.7939286e+00 -7.1823807e+00  1.2884678e+01 */
    { 0xd36cb86e, 0xbf0ccb4f, 0x530230db },  /* 100: -1.0167065e+12 -5.4997724e-01  5.5916544e+11 */
    { 0xbbb26ec5, 0x3b0802f0, 0xb73d99ca },  /* 101: -5.4453337e-03  2.0753704e-03 -1.1301084e-05 */
    { 0x3fc71036, 0xb95d2425, 0xb9abf51a },  /* 102:  1.5551822e+00 -2.1089667e-04 -3.2798276e-04 */
    { 0xc5c5fa24, 0xbff119a1, 0x463a744e },  /* 103: -6.3352676e+03 -1.8835946e+00  1.1933076e+04 */
    { 0xbe5482fd, 0xabc61e42, 0x2aa4766e },  /* 104: -2.0753093e-01 -1.4077144e-12  2.9214429e-13 */
    { 0x2ed38d9d, 0x3fe6518d, 0x2f3e549f },  /* 105:  9.6203247e-11  1.7993637e+00  1.7310463e-10 */
    { 0x40b4397f, 0x3bfb7873, 0x3d31092b },  /* 106:  5.6320186e+00  7.6742708e-03  4.3221635e-02 */
    { 0xb948df83, 0xbf088966, 0x38d6451a },  /* 107: -1.9156751e-04 -5.3334653e-01  1.0217187e-04 */
    { 0xbf470b81, 0x7ac6e882, 0xfa9aa7ad },  /* 108: -7.7751929e-01  5.1639530e+35 -4.0150730e+35 */
    { 0xc295b2d3, 0x40a009be, 0xc3bb2aed },  /* 109: -7.4849266e+01  5.0011892e+00 -3.7433534e+02 */
    { 0x3fe25bbd, 0x3be33aa5, 0x3c48eb33 },  /* 110:  1.7684246e+00  6.9344812e-03  1.2263107e-02 */
    { 0xbdbeeaeb, 0x42b952cf, 0xc10a3585 },  /* 111: -9.3221508e-02  9.2661736e+01 -8.6380667e+00 */
    { 0x415c946f, 0xc08bf299, 0xc2712b41 },  /* 112:  1.3786239e+01 -4.3733640e+00 -6.0292240e+01 */
    { 0xc1341c58, 0x3f3758fa, 0xc100fedd },  /* 113: -1.1256920e+01  7.1620142e-01 -8.0622220e+00 */
    { 0xb2d92a07, 0x3dbe56e8, 0xb12176ea },  /* 114: -2.5281237e-08  9.2939198e-02 -2.3496179e-09 */
    { 0xc05b69ad, 0xbfa09b3e, 0x4089a71a },  /* 115: -3.4283249e+00 -1.2547376e+00  4.3016483e+00 */
    { 0x3e3da6ba, 0xc3c2a61f, 0xc290336a },  /* 116:  1.8520632e-01 -3.8929782e+02 -7.2100418e+01 */
    { 0xbf45062b, 0xb69a37a3, 0x366d610f },  /* 117: -7.6962537e-01 -4.5960346e-06  3.5372248e-06 */
    { 0xbf42eb2e, 0x3fed0125, 0xbfb47499 },  /* 118: -7.6140106e-01  1.8515974e+00 -1.4098082e+00 */
    { 0xc12edecf, 0xbf192ec7, 0x40d1463b },  /* 119: -1.0929397e+01 -5.9837002e-01  6.5398232e+00 */
    { 0xc11b2c98, 0xbf16ae83, 0x40b6abd2 },  /* 120: -9.6983871e+00 -5.8860034e-01  5.7084739e+00 */
    { 0x3feeccf7, 0xbfce78d9, 0xc04099a9 },  /* 121:  1.8656300e+00 -1.6130630e+00 -3.0093787e+00 */
    { 0xc0cd95ba, 0xbd1a951a, 0x3e78479e },  /* 122: -6.4245272e+00 -3.7739851e-02  2.4246070e-01 */
    { 0x3f38ba4e, 0xd2c571ab, 0xd28e7964 },  /* 123:  7.2159278e-01 -4.2400779e+11 -3.0596096e+11 */
    { 0xba84ef6a, 0xbc86ca21, 0x378bfc8f },  /* 124: -1.0142152e-03 -1.6453804e-02  1.6687698e-05 */
    { 0x4138a231, 0x3de26055, 0x3fa344a9 },  /* 125:  1.1539598e+01  1.1053530e-01  1.2755329e+00 */
    { 0x3cc2674a, 0x3fbf52cf, 0x3d1149f2 },  /* 126:  2.3730893e-02  1.4947146e+00  3.5470912e-02 */
    { 0x428c1f0c, 0x37bb0d0e, 0x3accc3a6 },  /* 127:  7.0060638e+01  2.2298216e-05  1.5622273e-03 */
    { 0x4f691eb6, 0x40c2d84d, 0x50b16e3e },  /* 128:  3.9111040e+09  6.0889039e+00  2.3814336e+10 */
    { 0x3fe93b98, 0x3f157a85, 0x3f882f4f },  /* 129:  1.8221312e+00  5.8390075e-01  1.0639437e+00 */
    { 0x3f3abfde, 0xbf2c0c1b, 0xbefb037c },  /* 130:  7.2949016e-01 -6.7205971e-01 -4.9026095e-01 */
    { 0xc0601d95, 0x41eb1c10, 0xc2cdd3b9 },  /* 131: -3.5018055e+00  2.9388702e+01 -1.0291352e+02 */
    { 0x3790c7d5, 0x422660b3, 0x3a3c3089 },  /* 132:  1.7259192e-05  4.1594433e+01  7.1788629e-04 */
    { 0xbff250db, 0xbfddcd77, 0x4051f248 },  /* 133: -1.8930925e+00 -1.7328328e+00  3.2804128e+00 */
    { 0x80000000, 0xbe5f8f49, 0x00000000 },  /* 134: -0.0000000e+00 -2.1832003e-01  0.0000000e+00 */
    { 0x247b52ed, 0xbf24e114, 0xa421de17 },  /* 135:  5.4497190e-17 -6.4405942e-01 -3.5099429e-17 */
    { 0xc6aa9508, 0x3fe2c8a9, 0xc7171d46 },  /* 136: -2.1834516e+04  1.7717487e+00 -3.8685274e+04 */
    { 0xbd94a364, 0x43c0b17f, 0xc1dfc333 },  /* 137: -7.2577268e-02  3.8538669e+02 -2.7970313e+01 */
    { 0xbc756dd0, 0x3d5cff8c, 0xba53df5d },  /* 138: -1.4979795e-02  5.3954646e-02 -8.0822952e-04 */
    { 0x3f2cc3cd, 0xbcdc4679, 0xbc94a7d3 },  /* 139:  6.7486268e-01 -2.6889073e-02 -1.8146432e-02 */
    { 0x3efbcf87, 0x3e45a368, 0x3dc2676e },  /* 140:  4.9181768e-01  1.9300616e-01  9.4923841e-02 */
    { 0x3fe49a1b, 0xc9c536c8, 0xca301b82 },  /* 141:  1.7859529e+00 -1.6155770e+06 -2.8853445e+06 */
    { 0x3dace801, 0x416e2a87, 0x3fa0dc6a },  /* 142:  8.4426887e-02  1.4885383e+01  1.2567265e+00 */
    { 0x3feba2b4, 0xc0e18341, 0xc14f92d0 },  /* 143:  1.8409028e+00 -7.0472722e+00 -1.2973343e+01 */
    { 0xc6b25506, 0x42b29477, 0xc9f8cd14 },  /* 144: -2.2826512e+04  8.9289970e+01 -2.0381786e+06 */
    { 0x41ee1711, 0x40e20c7a, 0x43523bf8 },  /* 145:  2.9761263e+01  7.0640230e+00  2.1023425e+02 */
    { 0xbf26c5b2, 0x3e9f6c97, 0xbe4fb70f },  /* 146: -6.5145409e-01  3.1137535e-01 -2.0284675e-01 */
    { 0xbf3479f9, 0x40f38f09, 0xc0abb49e },  /* 147: -7.0498616e-01  7.6112103e+00 -5.3657979e+00 */
    { 0xc085a38b, 0xbf250b18, 0x402c5066 },  /* 148: -4.1762137e+00 -6.4470053e-01  2.6924072e+00 */
    { 0xc1b63219, 0x3e45e85d, 0xc08cd9ed },  /* 149: -2.2774462e+01  1.9326921e-01 -4.4016022e+00 */
    { 0x4182b548, 0xc080b8ee, 0xc2837220 },  /* 150:  1.6338516e+01 -4.0225744e+00 -6.5722898e+01 */
    { 0x4088d137, 0xbffc1e8e, 0xc106be47 },  /* 151:  4.2755389e+00 -1.9696825e+00 -8.4214540e+00 */
    { 0x3fedf086, 0x438deecb, 0x4403eb6c },  /* 152:  1.8589027e+00  2.8386557e+02  5.2767847e+02 */
    { 0x3f0f26c3, 0xc0ed5688, 0xc084b746 },  /* 153:  5.5918521e-01 -7.4168129e+00 -4.1473721e+00 */
    { 0xbe164549, 0x390e4ee9, 0xb7a71181 },  /* 154: -1.4674868e-01  1.3571572e-04 -1.9916102e-05 */
    { 0xbfe2ce75, 0xbe13f991, 0x3e8319a8 },  /* 155: -1.7719256e+00 -1.4450671e-01  2.5605513e-01 */
    { 0x306c152c, 0x3e4a4105, 0x2f3a84ab },  /* 156:  8.5886387e-10  1.9751365e-01  1.6963734e-10 */
    { 0x3fe432c1, 0xbd92bd16, 0xbe02cd7f },  /* 157:  1.7827989e+00 -7.1649715e-02 -1.2773703e-01 */
    { 0x3f0d38ae, 0xc1d398cf, 0xc1697407 },  /* 158:  5.5164611e-01 -2.6449614e+01 -1.4590827e+01 */
    { 0xc0dc5450, 0xc001cfcb, 0x415f72a6 },  /* 159: -6.8852921e+00 -2.0283077e+00  1.3965491e+01 */
    { 0x3f5fb599, 0xbfe325bb, 0xbfc67eff },  /* 160:  8.7386471e-01 -1.7745889e+00 -1.5507507e+00 */
    { 0x3d010cdb, 0xbfd65341, 0xbd58156e },  /* 161:  3.1506401e-02 -1.6744157e+00 -5.2754812e-02 */
    { 0xc59cb7e5, 0xb8dcca6a, 0x3f0729f3 },  /* 162: -5.0149868e+03 -1.0528120e-04  5.2798383e-01 */
    { 0xbffb1028, 0x406749a0, 0xc0e2d3c9 },  /* 163: -1.9614305e+00  3.6138687e+00 -7.0883525e+00 */
    { 0xd53e4e02, 0xbe096225, 0x53cc4169 },  /* 164: -1.3077641e+13 -1.3416345e-01  1.7545414e+12 */
    { 0x395db9fe, 0x3fd5bf5f, 0x39b92180 },  /* 165:  2.1145490e-04  1.6699027e+00  3.5310910e-04 */
    { 0x3fd0ee3c, 0x3c45366a, 0x3ca0f3bd },  /* 166:  1.6322703e+00  1.2036899e-02  1.9647473e-02 */
    { 0x4c65996e, 0x43f68b8c, 0x50dd1e98 },  /* 167:  6.0188088e+07  4.9309021e+02  2.9678157e+10 */
    { 0x3fe9a179, 0xc21225bf, 0xc285608a },  /* 168:  1.8252403e+00 -3.6536861e+01 -6.6688550e+01 */
    { 0xbc97a79e, 0xc0b94c79, 0x3ddb8add },  /* 169: -1.8512543e-02 -5.7905850e+00  1.0719846e-01 */
    { 0x3ffb49dd, 0xbe400ccc, 0xbebc83f5 },  /* 170:  1.9631916e+00 -1.8754882e-01 -3.6819427e-01 */
    { 0x3fc77e50, 0xbdeb7dba, 0xbe3782ed },  /* 171:  1.5585423e+00 -1.1498590e-01 -1.7921038e-01 */
    { 0xc30b782c, 0x3ef9b5dc, 0xc2880af7 },  /* 172: -1.3946942e+02  4.8771560e-01 -6.8021413e+01 */
    { 0xb3bda889, 0x3cdb27b2, 0xb1225c96 },  /* 173: -8.8316547e-08  2.6752327e-02 -2.3626731e-09 */
    { 0x80000000, 0x420bbf76, 0x80000000 },  /* 174: -0.0000000e+00  3.4936974e+01 -0.0000000e+00 */
    { 0xbfa9edee, 0xbfd36353, 0x400c5109 },  /* 175: -1.3275735e+00 -1.6514686e+00  2.1924461e+00 */
    { 0x454b3e54, 0x3b71e511, 0x41400b89 },  /* 176:  3.2518955e+03  3.6910216e-03  1.2002817e+01 */
    { 0xbd7a0828, 0x416ea8f6, 0xbf69189b },  /* 177: -6.1042935e-02  1.4916250e+01 -9.1053169e-01 */
    { 0xbdf5db33, 0xbf12c0a2, 0x3d8cf003 },  /* 178: -1.2004700e-01 -5.7325184e-01  6.8817162e-02 */
    { 0xc272a389, 0x3e0f3b26, 0xc107c169 },  /* 179: -6.0659702e+01  1.3987407e-01 -8.4847195e+00 */
    { 0xbfdc8b89, 0x3fd836f2, 0xc03a4512 },  /* 180: -1.7230083e+00  1.6891768e+00 -2.9104656e+00 */
    { 0xbf16958c, 0xc18d9ba4, 0x412697d6 },  /* 181: -5.8821940e-01 -1.7700996e+01  1.0412070e+01 */
    { 0xbf2a30f0, 0x424aad90, 0xc206be00 },  /* 182: -6.6480923e-01  5.0669495e+01 -3.3685548e+01 */
    { 0x4117656c, 0x3d0a4a65, 0x3ea39157 },  /* 183:  9.4622612e+00  3.3762354e-02  3.1946822e-01 */
    { 0xc10b7460, 0xbdd92ace, 0x3f6c99ed },  /* 184: -8.7159119e+00 -1.0603867e-01  9.2422374e-01 */
    { 0x3fed7173, 0xc85eeac3, 0xc8cec220 },  /* 185:  1.8550247e+00 -2.2826705e+05 -4.2344101e+05 */
    { 0xe0908f5e, 0xbfee00c3, 0x610665b8 },  /* 186: -8.3333183e+19 -1.8593982e+00  1.5494957e+20 */
    { 0xc0d3d443, 0x3fe5353b, 0xc13da8ec },  /* 187: -6.6196609e+00  1.7906870e+00 -1.1853740e+01 */
    { 0xc11241e0, 0x409efe12, 0xc235aba0 },  /* 188: -9.1410828e+00  4.9685144e+00 -4.5417602e+01 */
    { 0xbf09d579, 0xbfb91bad, 0x3f475456 },  /* 189: -5.3841358e-01 -1.4461571e+00  7.7863063e-01 */
    { 0x40b4bdfe, 0x3b7dd857, 0x3cb33882 },  /* 190:  5.6481924e+00  3.8733685e-03  2.1877531e-02 */
    { 0x3f34eccf, 0x40adcb44, 0x4075a75f },  /* 191:  7.0673841e-01  5.4310627e+00  3.8383406e+00 */
    { 0x3f4612be, 0x3fe0579a, 0x3fad942e },  /* 192:  7.7372348e-01  1.7526734e+00  1.3560846e+00 */
    { 0xbe7a9e86, 0xbf12ff67, 0x3e0fe871 },  /* 193: -2.4474534e-01 -5.7420963e-01  1.4053513e-01 */
    { 0xc10482c8, 0x40ebfb0a, 0xc2744bfe },  /* 194: -8.2819290e+00  7.3743944e+00 -6.1074211e+01 */
    { 0xbf007198, 0xb86a1b83, 0x37eaeb45 },  /* 195: -5.0173330e-01 -5.5815570e-05  2.8004530e-05 */
    { 0x3f28d1d2, 0x3e278ab0, 0x3ddcf8aa },  /* 196:  6.5945160e-01  1.6361499e-01  1.0789617e-01 */
    { 0x3fc7b70f, 0xc285fa1d, 0xc2d10a74 },  /* 197:  1.5602740e+00 -6.6988503e+01 -1.0452042e+02 */
    { 0xc0c2848c, 0x4400ba0c, 0xc5439f47 },  /* 198: -6.0786800e+00  5.1490698e+02 -3.1299548e+03 */
    { 0x41971d12, 0xc308f99b, 0xc521b591 },  /* 199:  1.8889194e+01 -1.3697502e+02 -2.5873478e+03 */
    { 0xbffcf661, 0xc2a3fa4c, 0x43220833 },  /* 200: -1.9762689e+00 -8.1988861e+01  1.6203204e+02 */
    { 0x40ea069c, 0xc7187e91, 0xc88b67a0 },  /* 201:  7.3133068e+00 -3.9038566e+04 -2.8550101e+05 */
    { 0xbfecc62a, 0xbfdd94ea, 0x404cf0cd },  /* 202: -1.8497975e+00 -1.7311070e+00  3.2021974e+00 */
    { 0x400bcd02, 0xc184d4b8, 0xc21113bf },  /* 203:  2.1843877e+00 -1.6603867e+01 -3.6269282e+01 */
    { 0x458da172, 0x3f37d0ba, 0x454b63c5 },  /* 204:  4.5321807e+03  7.1802866e-01  3.2542356e+03 */
    { 0x49d106eb, 0x41a4af15, 0x4c067763 },  /* 205:  1.7123494e+06  2.0585489e+01  3.5249550e+07 */
    { 0x3fe1101e, 0x443ea61c, 0x44a79bff },  /* 206:  1.7583044e+00  7.6259546e+02  1.3408749e+03 */
    { 0xbf3a6740, 0xbf26dd5d, 0x3ef30045 },  /* 207: -7.2813797e-01 -6.5181524e-01  4.7461142e-01 */
    { 0x3d70362c, 0xbffd002f, 0xbded65b6 },  /* 208:  5.8645412e-02 -1.9765681e+00 -1.1591665e-01 */
    { 0x4153ee83, 0xbea37a6d, 0xc0875637 },  /* 209:  1.3245730e+01 -3.1929341e-01 -4.2292744e+00 */
    { 0xbd64d25c, 0xbcddb171, 0x3ac62834 },  /* 210: -5.5864677e-02 -2.7062150e-02  1.5118182e-03 */
    { 0xbbe4a76b, 0x3cccc8d0, 0xb936e8c6 },  /* 211: -6.9779656e-03  2.4998099e-02 -1.7443587e-04 */
    { 0xc197e2ad, 0xbf28695d, 0x4147d689 },  /* 212: -1.8985682e+01 -6.5785772e-01  1.2489877e+01 */
    { 0xc0dd43e3, 0xbf2af3af, 0x4093c1b3 },  /* 213: -6.9145370e+00 -6.6778082e-01  4.6173951e+00 */
    { 0xbafe53a0, 0x3fc7964c, 0xbb464852 },  /* 214: -1.9403584e-03  1.5592742e+00 -3.0255508e-03 */
    { 0x510eda09, 0x40daa864, 0x52740745 },  /* 215:  3.8346461e+10  6.8330555e+00  2.6202350e+11 */
    { 0xbeb4edb3, 0xbd2b3278, 0x3c71fce4 },  /* 216: -3.5337600e-01 -4.1796178e-02  1.4769766e-02 */
    { 0x40c04255, 0x380cd163, 0x3953830e },  /* 217:  6.0080972e+00  3.3573608e-05  2.0171350e-04 */
    { 0xeeb9b9e4, 0x395447fa, 0xe89a0229 },  /* 218: -2.8739727e+28  2.0244709e-04 -5.8182741e+24 */
    { 0xbda0f171, 0x3ff97dac, 0xbe1cd9d9 },  /* 219: -7.8585513e-02  1.9491477e+00 -1.5317477e-01 */
    { 0xc134b29f, 0x5491df5a, 0xd64deda6 },  /* 220: -1.1293609e+01  5.0121398e+12 -5.6605146e+13 */
    { 0x45500303, 0x3d6a2ed9, 0x433e48d2 },  /* 221:  3.3281882e+03  5.7173584e-02  1.9028445e+02 */
    { 0x306ecb41, 0x00000000, 0x00000000 },  /* 222:  8.6872737e-10  0.0000000e+00  0.0000000e+00 */
    { 0xc0f69141, 0xbfdca46e, 0x41548333 },  /* 223: -7.7052312e+00 -1.7237680e+00  1.3282031e+01 */
    { 0xbffe68b3, 0x3f2e4a76, 0xbfad3529 },  /* 224: -1.9875702e+00  6.8082368e-01 -1.3531848e+00 */
    { 0xbf1b16fc, 0xc1b3156c, 0x4158fc19 },  /* 225: -6.0581946e-01 -2.2385460e+01  1.3561547e+01 */
    { 0x80000000, 0x412dbba8, 0x80000000 },  /* 226: -0.0000000e+00  1.0858315e+01 -0.0000000e+00 */
    { 0x3fbe0ba0, 0x38eb5a84, 0x392eb7de },  /* 227:  1.4847298e+00  1.1222533e-04  1.6662429e-04 */
    { 0x3ad3d1a0, 0x40c96e01, 0x3c26aa9c },  /* 228:  1.6160496e-03  6.2946782e+00  1.0172512e-02 */
    { 0x3fc09e1a, 0xbbf95520, 0xbc3b99d4 },  /* 229:  1.5048249e+00 -7.6090246e-03 -1.1450250e-02 */
    { 0x3d238ccd, 0x3c632263, 0x3a111bd2 },  /* 230:  3.9929200e-02  1.3863179e-02  5.5354564e-04 */
    { 0x406cf28f, 0xbf184d1a, 0xc00cf762 },  /* 231:  3.7023046e+00 -5.9492648e-01 -2.2025990e+00 */
    { 0x3f4e39a2, 0x43679a0f, 0x433a921c },  /* 232:  8.0556691e-01  2.3160179e+02  1.8657074e+02 */
    { 0xbe0b2bad, 0xbde07b7f, 0x3c7412b5 },  /* 233: -1.3590880e-01 -1.0961055e-01  1.4897038e-02 */
    { 0xb51088a6, 0x45ba1db1, 0xbb522818 },  /* 234: -5.3843030e-07  5.9557114e+03 -3.2067355e-03 */
    { 0x3e8f6c30, 0x3ddf27a5, 0x3cfa0ae7 },  /* 235:  2.8012228e-01  1.0896233e-01  3.0522778e-02 */
    { 0xbe2b8c42, 0xbd8a9b47, 0x3c39c352 },  /* 236: -1.6752723e-01 -6.7678981e-02  1.1338072e-02 */
    { 0x3ef3ba1a, 0x3783b05b, 0x36fac044 },  /* 237:  4.7602922e-01  1.5698539e-05  7.4729632e-06 */
    { 0xbe85860c, 0xbfe20867, 0x3eebc971 },  /* 238: -2.6078832e-01 -1.7658814e+00  4.6052125e-01 */
    { 0xb8cc18d5, 0xc7742370, 0x40c2a3ec },  /* 239: -9.7321034e-05 -6.2499438e+04  6.0825099e+00 */
    { 0xbe6e0dac, 0x3e297ee7, 0xbd1d9d08 },  /* 240: -2.3247403e-01  1.6552316e-01 -3.8479835e-02 */
    { 0xbcf8505b, 0x3f293ef6, 0xbca42a1e },  /* 241: -3.0311754e-02  6.6111696e-01 -2.0039615e-02 */
    { 0x3f0ee6bb, 0x3fd17f3a, 0x3f69e2c7 },  /* 242:  5.5820817e-01  1.6366951e+00  9.1361660e-01 */
    { 0x3e89eb4d, 0xbe155488, 0xbd20e6fd },  /* 243:  2.6937333e-01 -1.4583027e-01 -3.9282786e-02 */
    { 0xbdc1181d, 0x4187a3cc, 0xbfcc9e87 },  /* 244: -9.4284274e-02  1.6954979e+01 -1.5985879e+00 */
    { 0xc37ad088, 0xbf1a75a3, 0x431754b3 },  /* 245: -2.5081458e+02 -6.0335749e-01  1.5133085e+02 */
    { 0x3d581a85, 0x407960a6, 0x3e528361 },  /* 246:  5.2759666e-02  3.8965240e+00  2.0557930e-01 */
    { 0x3e778bc5, 0xbdd54fc4, 0xbcce446d },  /* 247:  2.4174412e-01 -1.0415605e-01 -2.5179112e-02 */
    { 0xbffb52e2, 0xbe85f090, 0x3f037e3a },  /* 248: -1.9634669e+00 -2.6160097e-01  5.1364484e-01 */
    { 0x3e6f20fb, 0x3e01a477, 0x3cf2327e },  /* 249:  2.3352425e-01  1.2660395e-01  2.9565091e-02 */
    { 0x3fa7578e, 0xc1b800f3, 0xc1f08f1a },  /* 250:  1.3073595e+00 -2.3000463e+01 -3.0069873e+01 */
    { 0x48cf7622, 0x3e9ec982, 0x4800ae36 },  /* 251:  4.2488106e+05  3.1013113e-01  1.3176885e+05 */
    { 0x3b315dc3, 0xc2d00c7d, 0xbe9024d5 },  /* 252:  2.7063943e-03 -1.0402439e+02 -2.8153102e-01 */
    { 0xc1038e71, 0xbe7c0395, 0x4001820e },  /* 253: -8.2222757e+00 -2.4610741e-01  2.0235630e+00 */
    { 0x4ce2e2d2, 0x4489ba21, 0x51f420b1 },  /* 254:  1.1895362e+08  1.1018165e+03  1.3106506e+11 */
    { 0xc0b8b4b0, 0xbcab14cc, 0x3df6df66 },  /* 255: -5.7720566e+00 -2.0883940e-02  1.2054328e-01 */
    { 0x3f1216f5, 0xbff911e9, 0xbf8e228d },  /* 256:  5.7066280e-01 -1.9458591e+00 -1.1104294e+00 */
    { 0xbde37eb4, 0xc0eef23c, 0x3f54570e },  /* 257: -1.1108151e-01 -7.4670696e+00  8.2945338e-01 */
    { 0xc0f740c7, 0x41948fc1, 0xc30f7c4b },  /* 258: -7.7266574e+00  1.8570192e+01 -1.4348551e+02 */
    { 0x3d73ae65, 0x3cdf6c11, 0x3ad4abc8 },  /* 259:  5.9492487e-02  2.7273210e-02  1.6225511e-03 */
    { 0xbe8c7b62, 0x40c614a8, 0xbfd96587 },  /* 260: -2.7437884e-01  6.1900215e+00 -1.6984109e+00 */
    { 0x42d20f31, 0x3f323b9e, 0x42923f7b },  /* 261:  1.0502967e+02  6.9622219e-01  7.3123987e+01 */
    { 0x3fd28f4a, 0x4eb424eb, 0x4f142b1d },  /* 262:  1.6449978e+00  1.5111592e+09  2.4858536e+09 */
    { 0x3fe5422e, 0xbe2eaf86, 0xbe9c702c },  /* 263:  1.7910821e+00 -1.7059144e-01 -3.0554329e-01 */
    { 0x273d9ea6, 0x80000000, 0x80000000 },  /* 264:  2.6315022e-15 -0.0000000e+00 -0.0000000e+00 */
    { 0x4799893e, 0xc11ef6d4, 0xc93ead7b },  /* 265:  7.8610484e+04 -9.9352608e+00 -7.8101566e+05 */
    { 0xc15a8a5a, 0x3f21c64a, 0xc10a1a49 },  /* 266: -1.3658777e+01  6.3193190e-01 -8.6314171e+00 */
    { 0xbe48c707, 0xcef586cf, 0x4dc09034 },  /* 267: -1.9607173e-01 -2.0596264e+09  4.0383450e+08 */
    { 0xbd51e27c, 0x3f15a65a, 0xbcf5626a },  /* 268: -5.1241383e-02  5.8456957e-01 -2.9954153e-02 */
    { 0x3c54fbd6, 0x3d68dd6c, 0x3a41bc71 },  /* 269:  1.2999495e-02  5.6851789e-02  7.3904458e-04 */
    { 0xb9a2bcf6, 0xbc61775e, 0x368f53f6 },  /* 270: -3.1039835e-04 -1.3761370e-02  4.2715064e-06 */
    { 0x2bd37be6, 0x63ca0ca6, 0x5026ea36 },  /* 271:  1.5026840e-12  7.4543074e+21  1.1201469e+10 */
    { 0xc0fcce53, 0x3e895784, 0xc007a0d7 },  /* 272: -7.9001861e+00  2.6824582e-01 -2.1191919e+00 */
    { 0x37302027, 0x3d386769, 0x34fdbc82 },  /* 273:  1.0497904e-05  4.5020495e-02  4.7262081e-07 */
    { 0x3f2239cf, 0x3d67f232, 0x3d12fba4 },  /* 274:  6.3369459e-01  5.6627460e-02  3.5884515e-02 */
    { 0x3d70e787, 0xba3c2fc1, 0xb83116f7 },  /* 275:  5.8814552e-02 -7.1787467e-04 -4.2221477e-05 */
    { 0xbfe60d60, 0xd176af87, 0x51ddae97 },  /* 276: -1.7972832e+00 -6.6219176e+10  1.1901461e+11 */
    { 0xbd624b90, 0xc2054a76, 0x3feba628 },  /* 277: -5.5247843e-02 -3.3322716e+01  1.8410082e+00 */
    { 0xbfd2350a, 0xc1787486, 0x41cc0310 },  /* 278: -1.6422436e+00 -1.5528448e+01  2.5501495e+01 */
    { 0x410c08a9, 0xc0aa8b5e, 0xc23a93f9 },  /* 279:  8.7521143e+00 -5.3295126e+00 -4.6644503e+01 */
    { 0x3f265b30, 0x3f008afc, 0x3ea70fd2 },  /* 280:  6.4982891e-01  5.0212073e-01  3.2629257e-01 */
    { 0x2f30d351, 0x4d4802e6, 0x3d0a2718 },  /* 281:  1.6082181e-10  2.0972707e+08  3.3728688e-02 */
    { 0xc1ccbbc5, 0xc3fbadef, 0x46494734 },  /* 282: -2.5591684e+01 -5.0335886e+02  1.2881801e+04 */
    { 0x444bcc2c, 0x3f083c0b, 0x43d8e888 },  /* 283:  8.1519019e+02  5.3216618e-01  4.3381665e+02 */
    { 0xc3f40ea6, 0xbf45eb0b, 0x43bcaf5a },  /* 284: -4.8811444e+02 -7.7311772e-01  3.7736992e+02 */
    { 0xbbcf1ec2, 0x40ba73ea, 0xbd16da21 },  /* 285: -6.3208053e-03  5.8266497e+00 -3.6829118e-02 */
    { 0x3dcaa23c, 0xbf1bb9b3, 0xbd76866f },  /* 286:  9.8942250e-02 -6.0830230e-01 -6.0186798e-02 */
    { 0xb5fe824a, 0x3de8e1bf, 0xb4678681 },  /* 287: -1.8962394e-06  1.1371183e-01 -2.1562484e-07 */
    { 0xbe76fae7, 0x419d5d39, 0xc097d1d0 },  /* 288: -2.4119149e-01  1.9670519e+01 -4.7443618e+00 */
    { 0x3fcf866b, 0xc130fd6c, 0xc18f79d9 },  /* 289:  1.6212896e+00 -1.1061871e+01 -1.7934496e+01 */
    { 0xbbc56dfe, 0xc096a57e, 0x3ce85c28 },  /* 290: -6.0250750e-03 -4.7077017e+00  2.8364256e-02 */
    { 0xbdb3a0c0, 0xbfc300d1, 0x3e08d405 },  /* 291: -8.7708950e-02 -1.5234624e+00  1.3362129e-01 */
    { 0x3f0a6bb2, 0x4d7e49b7, 0x4d097eb6 },  /* 292:  5.4070580e-01  2.6664024e+08  1.4417392e+08 */
    { 0xbf195698, 0xbdb6b470, 0x3d5adf48 },  /* 293: -5.9897757e-01 -8.9211345e-02  5.3435594e-02 */
    { 0x00000000, 0x3f0baa95, 0x00000000 },  /* 294:  0.0000000e+00  5.4557163e-01  0.0000000e+00 */
    { 0x3fd75fd1, 0x3e0bf701, 0x3e6b81aa },  /* 295:  1.6826116e+00  1.3668443e-01  2.2998681e-01 */
    { 0x3dc2fdec, 0x40e0fc20, 0x3f2b5e39 },  /* 296:  9.5210880e-02  7.0307770e+00  6.6940646e-01 */
    { 0xc4c61970, 0xbfe0b74e, 0x452de41b },  /* 297: -1.5847949e+03 -1.7555940e+00  2.7822565e+03 */
    { 0xbf1fa467, 0xb8b67b11, 0x38639740 },  /* 298: -6.2360233e-01 -8.7013592e-05  5.4261879e-05 */
    { 0xbd34b99b, 0xd2e1bfe2, 0x509f5e97 },  /* 299: -4.4122320e-02 -4.8479345e+11  2.1390212e+10 */
    { 0x44a687a0, 0x3ff81909, 0x452163ac },  /* 300:  1.3322383e+03  1.9382640e+00  2.5822295e+03 */
    { 0x41c889e3, 0x401118c4, 0x42635300 },  /* 301:  2.5067327e+01  2.2671366e+00  5.6831055e+01 */
    { 0x3de3ce15, 0xbe565907, 0xbcbebd7e },  /* 302:  1.1123291e-01 -2.0932399e-01 -2.3283717e-02 */
    { 0x3c28b572, 0x3f46d3f3, 0x3c030804 },  /* 303:  1.0297166e-02  7.7667159e-01  7.9975164e-03 */
    { 0x3e77e1ad, 0xaf7576a7, 0xae6dadde },  /* 304:  2.4207182e-01 -2.2324774e-10 -5.4041987e-11 */
    { 0xba103630, 0x382b5c32, 0xb2c11043 },  /* 305: -5.5012386e-04  4.0855441e-05 -2.2475553e-08 */
    { 0x3e7896ac, 0xbe0b3391, 0xbd072be2 },  /* 306:  2.4276227e-01 -1.3593890e-01 -3.3000835e-02 */
    { 0xbfe1d728, 0xbbbdcdd0, 0x3c277169 },  /* 307: -1.7643785e+00 -5.7923570e-03  1.0219910e-02 */
    { 0x4107276e, 0x410d3c82, 0x42952153 },  /* 308:  8.4471264e+00  8.8272724e+00  7.4565086e+01 */
    { 0x41ec810a, 0x42760ea2, 0x44e35184 },  /* 309:  2.9563007e+01  6.1514290e+01  1.8185474e+03 */
    { 0x0650546b, 0xbf0cc4fb, 0x85e51cef },  /* 310:  3.9182473e-35 -5.4988068e-01 -2.1545685e-35 */
    { 0x570a2c59, 0xbe6494d8, 0xd5f6bfab },  /* 311:  1.5192308e+14 -2.2322404e-01 -3.3912883e+13 */
    { 0xc2eea68e, 0xc1a175de, 0x451684a0 },  /* 312: -1.1932530e+02 -2.0182552e+01  2.4082892e+03 */
    { 0xbda3fea3, 0xb6d70cfc, 0x3509c32c },  /* 313: -8.0075525e-02 -6.4090109e-06  5.1320491e-07 */
    { 0xc6b50e96, 0x3da095a0, 0xc4e325e1 },  /* 314: -2.3175293e+04  7.8410387e-02 -1.8171837e+03 */
    { 0x3fb8e55d, 0x3f405355, 0x3f8ae836 },  /* 315:  1.4444996e+00  7.5127155e-01  1.0852115e+00 */
    { 0x4160dc9d, 0x3f06e733, 0x40ecfd1c },  /* 316:  1.4053861e+01  5.2696532e-01  7.4058972e+00 */
    { 0x41d7c197, 0x406fb113, 0x42ca02f9 },  /* 317:  2.6969526e+01  3.7451828e+00  1.0100580e+02 */
    { 0xbfb92520, 0xbe61b952, 0x3ea33fa8 },  /* 318: -1.4464455e+00 -2.2043350e-01  3.1884504e-01 */
    { 0xbf0d4f40, 0x3d8dd893, 0xbd1c9865 },  /* 319: -5.5199051e-01  6.9260739e-02 -3.8231270e-02 */
    { 0x2ee4a648, 0x3f087f2d, 0x2e73d3da },  /* 320:  1.0397777e-10  5.3319055e-01  5.5439965e-11 */
    { 0x52df3758, 0x413aa8ee, 0x54a2c182 },  /* 321:  4.7935311e+11  1.1666243e+01  5.5922497e+12 */
    { 0xc2f8cd07, 0x3e405da5, 0xc1baf4c8 },  /* 322: -1.2440044e+02  1.8785723e-01 -2.3369522e+01 */
    { 0xbf2765c5, 0x474fb230, 0xc707cfce },  /* 323: -6.5389663e-01  5.3170188e+04 -3.4767806e+04 */
    { 0x3fc49a8e, 0x446f5cb9, 0x44b7d380 },  /* 324:  1.5359666e+00  9.5744879e+02  1.4706094e+03 */
    { 0x4175fdf8, 0x3ca3ef04, 0x3e9d8661 },  /* 325:  1.5374504e+01  2.0011432e-02  3.0766585e-01 */
    { 0xbf0b1740, 0x44b2a936, 0xc4422434 },  /* 326: -5.4332352e-01  1.4292878e+03 -7.7656570e+02 */
    { 0xc177a403, 0x3be4bb53, 0xbddd4348 },  /* 327: -1.5477542e+01  6.9803386e-03 -1.0803848e-01 */
    { 0xc00223d1, 0x3c39b083, 0xbcbccb3b },  /* 328: -2.0334361e+00  1.1333588e-02 -2.3046126e-02 */
    { 0x38a4a82c, 0x3df288d1, 0x371bfef9 },  /* 329:  7.8514538e-05  1.1842502e-01  9.2980857e-06 */
    { 0xc0ed7b7c, 0x45e22066, 0xc751c512 },  /* 330: -7.4213238e+00  7.2360498e+03 -5.3701068e+04 */
    { 0x3c89204e, 0xa79fd965, 0xa4ab3f06 },  /* 331:  1.6739037e-02 -4.4367065e-15 -7.4266194e-17 */
    { 0xc4ec4b42, 0x40b7acfb, 0xc6298976 },  /* 332: -1.8903518e+03  5.7398658e+00 -1.0850366e+04 */
    { 0x430321f3, 0xbf0fb784, 0xc2933bef },  /* 333:  1.3113261e+02 -5.6139398e-01 -7.3617060e+01 */
    { 0xbfd05cc6, 0x3e015746, 0xbe528b91 },  /* 334: -1.6278312e+00  1.2630948e-01 -2.0561052e-01 */
    { 0xbb6b7445, 0x412ab413, 0xbd1d00d5 },  /* 335: -3.5927456e-03  1.0668963e+01 -3.8330872e-02 */
    { 0x3cc283f1, 0x3dbc23b9, 0x3b0ef40a },  /* 336:  2.3744555e-02  9.1865011e-02  2.1812938e-03 */
    { 0xbfba6c03, 0xc26e0748, 0x42ad55b8 },  /* 337: -1.4564213e+00 -5.9507111e+01  8.6667421e+01 */
    { 0xbf33d502, 0x3dcce6a8, 0xbd8fefc5 },  /* 338: -7.0246899e-01  1.0004932e-01 -7.0281543e-02 */
    { 0x3b339258, 0xc91a9d1a, 0xc4d8e878 },  /* 339:  2.7400460e-03 -6.3329762e+05 -1.7352646e+03 */
    { 0x3d6ab42c, 0x4122a021, 0x3f1518d3 },  /* 340:  5.7300732e-02  1.0164094e+01  5.8241002e-01 */
    { 0x3fde6171, 0xc78d7cd2, 0xc7f5d032 },  /* 341:  1.7373487e+00 -7.2441641e+04 -1.2585639e+05 */
    { 0xbf07d05f, 0xb9b2b342, 0x393d9bf8 },  /* 342: -5.3052324e-01 -3.4084363e-04  1.8082547e-04 */
    { 0xc12f5fa5, 0x3b30f6f4, 0xbcf275dd },  /* 343: -1.0960851e+01  2.7002664e-03 -2.9597217e-02 */
    { 0xbaf0a1d8, 0x3eff1b14, 0xba6fcaaa },  /* 344: -1.8358780e-03  4.9825346e-01 -9.1473258e-04 */
    { 0xc154aa89, 0xb80fb4ef, 0x39eec322 },  /* 345: -1.3291635e+01 -3.4262364e-05  4.5540283e-04 */
    { 0x430c4323, 0xc0062727, 0xc3930130 },  /* 346:  1.4026225e+02 -2.0961397e+00 -2.9400927e+02 */
    { 0x45f0df1d, 0x3a6a29c8, 0x40dc5340 },  /* 347:  7.7078892e+03  8.9326175e-04  6.8851626e+00 */
    { 0x3e59a8a7, 0x3f1eb563, 0x3e06f04f },  /* 348:  2.1255742e-01  6.1995524e-01  1.3177609e-01 */
    { 0xbdc5e44b, 0x41a14db6, 0xbff9614b },  /* 349: -9.6626841e-02  2.0162945e+01 -1.9482817e+00 */
    { 0x4181bede, 0xc0d134bb, 0xc2d40f1a },  /* 350:  1.6218197e+01 -6.5376868e+00 -1.0602949e+02 */
    { 0xbeffbbfe, 0x41488b54, 0xc0c8560d },  /* 351: -4.9948114e-01  1.2534016e+01 -6.2605044e+00 */
    { 0x40c6c323, 0x3fe97a5a, 0x4135469a },  /* 352:  6.2113204e+00  1.8240464e+00  1.1329736e+01 */
    { 0x43048c71, 0x3f2121fc, 0x42a6dbd7 },  /* 353:  1.3254860e+02  6.2942481e-01  8.3429377e+01 */
    { 0xbdbfd4c8, 0xc525fd84, 0x4378c43a },  /* 354: -9.3667567e-02 -2.6558447e+03  2.4876651e+02 */
    { 0x3e3914b9, 0x3ff75a5c, 0x3eb2d452 },  /* 355:  1.8074311e-01  1.9324450e+00  3.4927613e-01 */
    { 0x3ffcd4ea, 0x3dcbcc88, 0x3e4946d6 },  /* 356:  1.9752476e+00  9.9511206e-02  1.9655927e-01 */
    { 0x3dea1931, 0x3f3fafb0, 0x3daf4974 },  /* 357:  1.1430586e-01  7.4877453e-01  8.5589317e-02 */
    { 0xc0667dc5, 0x3ef35de7, 0xbfdb1dee },  /* 358: -3.6014264e+00  4.7532579e-01 -1.7118508e+00 */
    { 0xc0aef88b, 0x3fdff2be, 0xc119106a },  /* 359: -5.4678397e+00  1.7495954e+00 -9.5665072e+00 */
    { 0xc474e744, 0xbe949327, 0x438e2279 },  /* 360: -9.7961353e+02 -2.9018518e-01  2.8426933e+02 */
    { 0xc09cba90, 0x40e4ff43, 0xc20c326f },  /* 361: -4.8977737e+00  7.1561599e+00 -3.5049252e+01 */
    { 0x40659e0a, 0xb2f2b843, 0xb3d9b4ab },  /* 362:  3.5877709e+00 -2.8256300e-08 -1.0137713e-07 */
    { 0xc1aeb408, 0x3fca0724, 0xc209deee },  /* 363: -2.1837906e+01  1.5783429e+00 -3.4467704e+01 */
    { 0xb443e844, 0xc131f10f, 0x36082c10 },  /* 364: -1.8245288e-07 -1.1121352e+01  2.0291227e-06 */
    { 0x3cd2b17d, 0x40c67eae, 0x3e235d89 },  /* 365:  2.5719399e-02  6.2029638e+00  1.5953650e-01 */
    { 0x3f46045b, 0x41ba55de, 0x41902195 },  /* 366:  7.7350396e-01  2.3291927e+01  1.8016398e+01 */
    { 0xa3ee2cbc, 0x40be6842, 0xa5312633 },  /* 367: -2.5822957e-17  5.9502268e+00 -1.5365245e-16 */
    { 0x404ff4c5, 0x41123463, 0x41ed884d },  /* 368:  3.2493145e+00  9.1377897e+00  2.9691553e+01 */
    { 0x42483f82, 0x3cc36d63, 0x3f98ddf1 },  /* 369:  5.0062019e+01  2.3855871e-02  1.1942731e+00 */
    { 0xbd9426af, 0x3c92c8e3, 0xbaa9e4a3 },  /* 370: -7.2339408e-02  1.7918056e-02 -1.2961816e-03 */
    { 0xbe75d901, 0x41105f12, 0xc00aa55d },  /* 371: -2.4008562e-01  9.0232105e+00 -2.1663431e+00 */
    { 0x3cd6f2ee, 0x3f1393d4, 0x3c77d33c },  /* 372:  2.6238885e-02  5.7647443e-01  1.5126046e-02 */
    { 0x42cdf968, 0xb9cce355, 0xbd24d9a7 },  /* 373:  1.0298712e+02 -3.9079288e-04 -4.0246634e-02 */
    { 0x3f0e1ed9, 0x3f23ff86, 0x3eb616ff },  /* 374:  5.5515820e-01  6.4061773e-01  3.5564418e-01 */
    { 0xbfea41a2, 0x40c7505a, 0xc136628c },  /* 375: -1.8301280e+00  6.2285585e+00 -1.1399059e+01 */
    { 0x3a8afbf4, 0xbddd0ccb, 0xb8f004e7 },  /* 376:  1.0603652e-03 -1.0793456e-01 -1.1445005e-04 */
    { 0xc11d5778, 0xc21f8435, 0x43c4152a },  /* 377: -9.8338547e+00 -3.9879108e+01  3.9216536e+02 */
    { 0xbdd12265, 0x3d90c3bf, 0xbbec8684 },  /* 378: -1.0211638e-01  7.0685856e-02 -7.2181840e-03 */
    { 0xbc54a868, 0x3c91bc5d, 0xb9721fb8 },  /* 379: -1.2979604e-02  1.7790014e-02 -2.3090734e-04 */
    { 0xbae1af42, 0xbeefa82c, 0x3a5346e0 },  /* 380: -1.7218369e-03 -4.6807992e-01  8.0595727e-04 */
    { 0x3e65dc0d, 0x44384a5d, 0x432578ee },  /* 381:  2.2447224e-01  7.3716193e+02  1.6547239e+02 */
    { 0xbf17e0f3, 0x41b31e13, 0xc1548843 },  /* 382: -5.9327620e-01  2.2389685e+01 -1.3283267e+01 */
    { 0xbff3e857, 0xbbc6957f, 0x3c3d3423 },  /* 383: -1.9055279e+00 -6.0603018e-03  1.1548074e-02 */
    { 0x3deb509b, 0x3e56b941, 0x3cc55fab },  /* 384:  1.1489984e-01  2.0969106e-01  2.4093469e-02 */
    { 0x40047356, 0xbf1be15e, 0xbfa14cde },  /* 385:  2.0695395e+00 -6.0890758e-01 -1.2601583e+00 */
    { 0xbfba70be, 0xbf168958, 0x3f5b442c },  /* 386: -1.4565656e+00 -5.8803320e-01  8.5650894e-01 */
    { 0xbdd66f42, 0xbe7709b4, 0x3cceed79 },  /* 387: -1.0470439e-01 -2.4124795e-01  2.5259721e-02 */
    { 0x3f155ad5, 0xc88ce46f, 0xc82465e4 },  /* 388:  5.8341724e-01 -2.8854747e+05 -1.6834357e+05 */
    { 0xbca38167, 0xbcce7020, 0x3a03d9be },  /* 389: -1.9959165e-02 -2.5199950e-02  5.0296995e-04 */
    { 0xbf349945, 0x3f41141e, 0xbf0835be },  /* 390: -7.0546371e-01  7.5421321e-01 -5.3207005e-01 */
    { 0x3a16aa0b, 0x41e443af, 0x3c865747 },  /* 391:  5.7473843e-04  2.8533049e+01  1.6399040e-02 */
    { 0x412929bf, 0xd32f5869, 0xd4e7bbeb },  /* 392:  1.0572692e+01 -7.5310255e+11 -7.9623213e+12 */
    { 0xbc98c4f3, 0xbfc0d768, 0x3ce62883 },  /* 393: -1.8648600e-02 -1.5065737e+00  2.8095490e-02 */
    { 0x00000000, 0x3ac90b3a, 0x00000000 },  /* 394:  0.0000000e+00  1.5338429e-03  0.0000000e+00 */
    { 0xc1ebf5ba, 0x3cc6ea4c, 0xbf375803 },  /* 395: -2.9494984e+01  2.4281643e-02 -7.1618667e-01 */
    { 0xca7634a8, 0x42893ddf, 0xcd83fdaf },  /* 396: -4.0338340e+06  6.8620842e+01 -2.7680509e+08 */
    { 0xbc484803, 0xbddca7cf, 0x3aaca12c },  /* 397: -1.2224200e-02 -1.0774194e-01  1.3170591e-03 */
    { 0x062523bf, 0x4298bec3, 0x0945108f },  /* 398:  3.1059313e-35  7.6372581e+01  2.3720799e-33 */
    { 0xbf158913, 0x3f1c608a, 0xbeb6afd7 },  /* 399: -5.8412284e-01  6.1084807e-01 -3.5681031e-01 */
    { 0x52a7c74b, 0x3f020df6, 0x522a78b5 },  /* 400:  3.6030156e+11  5.0802553e-01  1.8304239e+11 */
    { 0xc11e38c0, 0x40c861e8, 0xc277b1b2 },  /* 401: -9.8888550e+00  6.2619514e+00 -6.1923530e+01 */
    { 0xc13345bd, 0xc0addbc8, 0x42738013 },  /* 402: -1.1204526e+01 -5.4330788e+00  6.0875072e+01 */
    { 0xbb253270, 0xc1443027, 0x3cfd3361 },  /* 403: -2.5207065e-03 -1.2261756e+01  3.0908288e-02 */
    { 0x3f366bfa, 0xc2033cdf, 0xc1bb0942 },  /* 404:  7.1258509e-01 -3.2809444e+01 -2.3379521e+01 */
    { 0x40d815a3, 0x3e5f538f, 0x3fbc8161 },  /* 405:  6.7526412e+00  2.1809219e-01  1.4726983e+00 */
    { 0xae31d7f6, 0x381633dd, 0xa6d0b123 },  /* 406: -4.0436952e-11  3.5811088e-05 -1.4480913e-15 */
    { 0xc1a0d02f, 0xc10a8bd6, 0x432e1022 },  /* 407: -2.0101652e+01 -8.6591396e+00  1.7406301e+02 */
    { 0x419c6416, 0x3f4536ed, 0x4170f526 },  /* 408:  1.9548870e+01  7.7036935e-01  1.5059850e+01 */
    { 0xbf208301, 0x42e9a5dd, 0xc2927f3b },  /* 409: -6.2699896e-01  1.1682395e+02 -7.3248496e+01 */
    { 0x3f2f4d73, 0x3d6b06fc, 0x3d20f0e1 },  /* 410:  6.8477553e-01  5.7379708e-02  3.9292220e-02 */
    { 0x3d3ba38b, 0x4169131b, 0x3f2ad5da },  /* 411:  4.5810264e-02  1.4567164e+01  6.6732564e-01 */
    { 0x3eff8a5c, 0xbdd1f65b, 0xbd5195df },  /* 412:  4.9910247e-01 -1.0252067e-01 -5.1168318e-02 */
    { 0xc0f574fd, 0xe3634407, 0x64d9e7f6 },  /* 413: -7.6705308e+00 -4.1923128e+21  3.2157264e+22 */
    { 0xbd6f3747, 0xbfc68a1f, 0x3db985d2 },  /* 414: -5.8402326e-02 -1.5510901e+00  9.0587271e-02 */
    { 0xbee59e7c, 0xbf11e889, 0x3e82df57 },  /* 415: -4.4847476e-01 -5.6995445e-01  2.5561019e-01 */
    { 0x40057ec9, 0x40c7bfb3, 0x4150530a },  /* 416:  2.0858634e+00  6.2421508e+00  1.3020274e+01 */
    { 0xbf1c9418, 0xe2cb1145, 0x627867fe },  /* 417: -6.1163473e-01 -1.8729667e+21  1.1455715e+21 */
    { 0x70ca9d4e, 0xa9d3f09d, 0xdb27be17 },  /* 418:  5.0164913e+29 -9.4120221e-14 -4.7215327e+16 */
    { 0xbf3706bd, 0x3e209bb3, 0xbde5a70e },  /* 419: -7.1494657e-01  1.5684395e-01 -1.1213504e-01 */
    { 0x3fdd6a18, 0x4077b903, 0x40d64161 },  /* 420:  1.7298002e+00  3.8706672e+00  6.6954810e+00 */
    { 0xb28fecca, 0xbfc88f9f, 0x32e18379 },  /* 421: -1.6755070e-08 -1.5668830e+00  2.6253234e-08 */
    { 0x4072a068, 0xbf2b0680, 0xc022174f },  /* 422:  3.7910404e+00 -6.6806793e-01 -2.5326725e+00 */
    { 0x40e0230a, 0xc10888ad, 0xc26f148f },  /* 423:  7.0042772e+00 -8.5333681e+00 -5.9770076e+01 */
    { 0x40936f61, 0xbdc1214b, 0xbede7449 },  /* 424:  4.6073461e+00 -9.4301783e-02 -4.3448095e-01 */
    { 0x4193ea57, 0x41489f01, 0x4367d5e6 },  /* 425:  1.8489424e+01  1.2538819e+01  2.3183554e+02 */
    { 0x3c99e52a, 0x3eebe383, 0x3c0dce23 },  /* 426:  1.8786032e-02  4.6072015e-01  8.6551034e-03 */
    { 0x3df8de4c, 0x3aaad7e7, 0x39261582 },  /* 427:  1.2151775e-01  1.3034315e-03  1.5839006e-04 */
    { 0xbfd95efe, 0x40079371, 0xc0663c93 },  /* 428: -1.6982114e+00  2.1183741e+00 -3.5974471e+00 */
    { 0xbfe29377, 0xd61abe95, 0x5688f563 },  /* 429: -1.7701253e+00 -4.2535834e+13  7.5293754e+13 */
    { 0xbf1a0bcb, 0xbe3a2cd0, 0x3de00f11 },  /* 430: -6.0174245e-01 -1.8181157e-01  1.0940374e-01 */
    { 0xc8070709, 0x43173389, 0xcb9f80aa },  /* 431: -1.3826814e+05  1.5120131e+02 -2.0906324e+07 */
    { 0x3fc867d6, 0xbe6f64d5, 0xbebb67e0 },  /* 432:  1.5656688e+00 -2.3378308e-01 -3.6602688e-01 */
    { 0x3fa27039, 0x3a43e804, 0x3a789d67 },  /* 433:  1.2690498e+00  7.4732327e-04  9.4839042e-04 */
    { 0x3ff442a5, 0xd0515ea8, 0xd0c7c4b9 },  /* 434:  1.9082838e+00 -1.4050566e+10 -2.6812468e+10 */
    { 0xc0dd6836, 0x4ce00533, 0xce41bfae },  /* 435: -6.9189711e+00  1.1745116e+08 -8.1264118e+08 */
    { 0x40f8b1de, 0xbf206986, 0xc09bd5ae },  /* 436:  7.7717123e+00 -6.2661016e-01 -4.8698339e+00 */
    { 0xbf38f4b6, 0xbad05471, 0x3a9683d6 },  /* 437: -7.2248399e-01 -1.5894306e-03  1.1483382e-03 */
    { 0xbf1349cd, 0xc0ed31af, 0x408877e9 },  /* 438: -5.7534486e-01 -7.4123149e+00  4.2646373e+00 */
    { 0xbff0961a, 0x3f357560, 0xbfaa886f },  /* 439: -1.8795807e+00  7.0882225e-01 -1.3322886e+00 */
    { 0xb5569b35, 0x40a21b7c, 0xb687e542 },  /* 440: -7.9947068e-07  5.0658550e+00 -4.0500026e-06 */
    { 0xc083243d, 0xc214114b, 0x4317b39e },  /* 441: -4.0981736e+00 -3.7016888e+01  1.5170163e+02 */
    { 0xbef3869d, 0x42b2baec, 0xc22a0569 },  /* 442: -4.7563639e-01  8.9365082e+01 -4.2505285e+01 */
    { 0xbd9c00ef, 0x40abac6d, 0xbed13b65 },  /* 443: -7.6173656e-02  5.3647981e+00 -4.0865628e-01 */
    { 0xc5db724e, 0xbfc02159, 0x4624b251 },  /* 444: -7.0222881e+03 -1.5010177e+00  1.0540579e+04 */
    { 0xc1650e7b, 0x3ef30c16, 0xc0d9778f },  /* 445: -1.4316035e+01  4.7470158e-01 -6.7958446e+00 */
    { 0x3e680c52, 0x35b5854c, 0x34a48989 },  /* 446:  2.2660950e-01  1.3524345e-06  3.0647451e-07 */
    { 0x6a4018fd, 0x3e837c10, 0x694553c3 },  /* 447:  5.8057940e+25  2.5680590e-01  1.4909621e+25 */
    { 0xbe8f451b, 0x45f7eea5, 0xc50ac13c },  /* 448: -2.7982411e-01  7.9338306e+03 -2.2200771e+03 */
    { 0xbf590a45, 0xbf18c726, 0x3f0186f0 },  /* 449: -8.4781295e-01 -5.9678876e-01  5.0596524e-01 */
    { 0x3f13df05, 0x3fc39e5e, 0x3f61fcb5 },  /* 450:  5.7762176e-01  1.5282705e+00  8.8276228e-01 */
    { 0x46ef36e5, 0x3ff1deed, 0x476202fd },  /* 451:  3.0619447e+04  1.8896157e+00  5.7858987e+04 */
    { 0xc4390315, 0xbe3049bd, 0x42feced2 },  /* 452: -7.4004816e+02 -1.7215629e-01  1.2740394e+02 */
    { 0xbfa6e3ea, 0x3e13f73c, 0xbe40ec19 },  /* 453: -1.3038304e+00  1.4449781e-01 -1.8840064e-01 */
    { 0xc4c99eb1, 0x41e15c69, 0xc7317d41 },  /* 454: -1.6129591e+03  2.8170122e+01 -4.5437255e+04 */
    { 0x3e1a5cba, 0x41ce5a12, 0x4078d9da },  /* 455:  1.5074435e-01  2.5793980e+01  3.8882967e+00 */
    { 0x3a778892, 0x3fe97c27, 0x3ae1c359 },  /* 456:  9.4426528e-04  1.8241013e+00  1.7224356e-03 */
    { 0x40125f4f, 0xbd79be66, 0xbe0ecb91 },  /* 457:  2.2870672e+00 -6.0972594e-02 -1.3944842e-01 */
    { 0x41429b88, 0x3f3634c5, 0x410a82b0 },  /* 458:  1.2162971e+01  7.1174270e-01  8.6569062e+00 */
    { 0xbe88f965, 0xbfd02b81, 0x3edec3d2 },  /* 459: -2.6752773e-01 -1.6263276e+00  4.3508774e-01 */
    { 0x3e2b332f, 0xbd5ae9d4, 0xbc1265f5 },  /* 460:  1.6718744e-01 -5.3445652e-02 -8.9354416e-03 */
    { 0x3dbb7afd, 0xbe907145, 0xbcd39044 },  /* 461:  9.1543175e-02 -2.8211418e-01 -2.5825628e-02 */
    { 0xbdd26c5d, 0xbae71f68, 0x393df999 },  /* 462: -1.0274575e-01 -1.7633261e-03  1.8117426e-04 */
    { 0x3fc85790, 0xc1081a3a, 0xc1550616 },  /* 463:  1.5651722e+00 -8.5064030e+00 -1.3313985e+01 */
    { 0xbe66e156, 0xc0dc653c, 0x3fc6c4f3 },  /* 464: -2.2546896e-01 -6.8873577e+00  1.5528854e+00 */
    { 0x3fe5bb47, 0x400dd234, 0x407e8991 },  /* 465:  1.7947778e+00  2.2159548e+00  3.9771463e+00 */
    { 0x3db45a35, 0x43455565, 0x418b0594 },  /* 466:  8.8062681e-02  1.9733357e+02  1.7377723e+01 */
    { 0x3fd3ff68, 0xbdade8c1, 0xbe100459 },  /* 467:  1.6562319e+00 -8.4916599e-02 -1.4064158e-01 */
    { 0xbe7d67fb, 0xc1287802, 0x4026c307 },  /* 468: -2.4746697e-01 -1.0529299e+01  2.6056536e+00 */
    { 0x46ea0390, 0x3f194d96, 0x468c230d },  /* 469:  2.9953781e+04  5.9884012e-01  1.7937526e+04 */
    { 0x3fc1fe48, 0xc082ae84, 0xc0c60ebf },  /* 470:  1.5155725e+00 -4.0838032e+00 -6.1893000e+00 */
    { 0x3629f0a1, 0x2c301b5c, 0x22e9cf30 },  /* 471:  2.5323027e-06  2.5026292e-12  6.3374146e-18 */
    { 0x321d5e50, 0xc1553980, 0xb40312d1 },  /* 472:  9.1600469e-09 -1.3326538e+01 -1.2207171e-07 */
    { 0xbdf13286, 0x3e715f98, 0xbce36aa1 },  /* 473: -1.1777215e-01  2.3571622e-01 -2.7760806e-02 */
    { 0xc109cc60, 0x3dc71ca9, 0xbf565a98 },  /* 474: -8.6123962e+00  9.7222634e-02 -8.3731984e-01 */
    { 0xc15e7e8d, 0xbbc768c8, 0x3dad4f71 },  /* 475: -1.3905896e+01 -6.0854889e-03  8.4624178e-02 */
    { 0x40c80528, 0x40de1845, 0x422d876f },  /* 476:  6.2506294e+00  6.9404626e+00  4.3382260e+01 */
    { 0x40aeba64, 0x3e0bf18c, 0x3f3f0823 },  /* 477:  5.4602528e+00  1.3666362e-01  7.4621789e-01 */
    { 0x3e10f5f9, 0xc1308204, 0xbfc7e575 },  /* 478:  1.4156331e-01 -1.1031742e+01 -1.5616899e+00 */
    { 0x383b2d4c, 0x3e619215, 0x3724ed9f },  /* 479:  4.4626460e-05  2.2028382e-01  9.8304872e-06 */
    { 0xbdbc4df0, 0xc0df618a, 0x3f244fa3 },  /* 480: -9.1945529e-02 -6.9806566e+00  6.4184017e-01 */
    { 0x459cf2f2, 0x40ff847a, 0x471ca737 },  /* 481:  5.0223682e+03  7.9849215e+00  4.0103215e+04 */
    { 0xce0387ee, 0x3a251669, 0xc8a9a440 },  /* 482: -5.5168090e+08  6.2975899e-04 -3.4742600e+05 */
    { 0x3f02af97, 0xc9ab974e, 0xc92f310f },  /* 483:  5.1049179e-01 -1.4056738e+06 -7.1758491e+05 */
    { 0xbf14547d, 0x40a507d5, 0xc03f3dfd },  /* 484: -5.7941419e-01  5.1572061e+00 -2.9881584e+00 */
    { 0xc086ba59, 0x3e3cc23f, 0xbf46ae27 },  /* 485: -4.2102475e+00  1.8433474e-01 -7.7609488e-01 */
    { 0xb3af41ce, 0x3ff27a50, 0xb425fff1 },  /* 486: -8.1610423e-08  1.8943577e+00 -1.5459933e-07 */
    { 0xc12317a8, 0x3f16206a, 0xc0bf4906 },  /* 487: -1.0193275e+01  5.8643210e-01 -5.9776639e+00 */
    { 0x3d36193e, 0x3fed6e85, 0x3da8e3fc },  /* 488:  4.4457667e-02  1.8549353e+00  8.2466095e-02 */
    { 0xb0fdbad4, 0xc0d6f16a, 0x32550973 },  /* 489: -1.8461273e-09 -6.7169695e+00  1.2400380e-08 */
    { 0xbd954e87, 0xbd82f705, 0x3b98c3e4 },  /* 490: -7.2903685e-02 -6.3947715e-02  4.6620241e-03 */
    { 0xc35a4daa, 0x39381251, 0xbd1cf771 },  /* 491: -2.1830338e+02  1.7554431e-04 -3.8321915e-02 */
    { 0x3b3dbeb8, 0x4452ad8d, 0x401c2715 },  /* 492:  2.8952789e-03  8.4271173e+02  2.4398855e+00 */
    { 0xbfe35771, 0x40b27050, 0xc11e768a },  /* 493: -1.7761060e+00  5.5762100e+00 -9.9039401e+00 */
    { 0xbd916fe0, 0xb9e8cdf7, 0x38044266 },  /* 494: -7.1014166e-02 -4.4403944e-04  3.1533090e-05 */
    { 0x48bd0e29, 0x4b78c851, 0x54b7b9a7 },  /* 495:  3.8718528e+05  1.6304209e+07  6.3127497e+12 */
    { 0x40ebd255, 0x41008f4a, 0x426cda52 },  /* 496:  7.3694253e+00  8.0349827e+00  5.9213205e+01 */
    { 0xbf359629, 0xbf21f72b, 0x3ee5c584 },  /* 497: -7.0932251e-01 -6.3267773e-01  4.4877256e-01 */
    { 0xc1d388ad, 0x4162407f, 0xc3baf3f4 },  /* 498: -2.6441736e+01  1.4140746e+01 -3.7390588e+02 */
    { 0x3f3a3450, 0x49451e08, 0x490f601a },  /* 499:  7.2736073e-01  8.0739250e+05  5.8726559e+05 */
    { 0x411b3e36, 0xbfdd408f, 0xc1862bdb },  /* 500:  9.7026882e+00 -1.7285327e+00 -1.6771414e+01 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x,y,z;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	y.lo = pgm_read_dword (& t[i].y);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = x.fl * y.fl;
	/* Comparison is integer to verify the zero sign.	*/
	if (v.lo != z.lo)
	    x_exit (i+1);
    }
    return 0;
}
