(***********************************************************************)
(*                                                                     *)
(*                         Applied Type System                         *)
(*                                                                     *)
(*                              Hongwei Xi                             *)
(*                                                                     *)
(***********************************************************************)

(*
** ATS - Unleashing the Potential of Types!
**
** Copyright (C) 2002-2010 Hongwei Xi, Boston University
**
** All rights reserved
**
** ATS is free software;  you can  redistribute it and/or modify it under
** the terms of the GNU LESSER GENERAL PUBLIC LICENSE as published by the
** Free Software Foundation; either version 2.1, or (at your option)  any
** later version.
** 
** ATS is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without  even  the  implied  warranty  of MERCHANTABILITY or
** FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
** for more details.
** 
** You  should  have  received  a  copy of the GNU General Public License
** along  with  ATS;  see the  file COPYING.  If not, please write to the
** Free Software Foundation,  51 Franklin Street, Fifth Floor, Boston, MA
** 02110-1301, USA.
*)

(* ****** ****** *)

// Author of the file: Hongwei Xi (hwxi AT cs DOT bu DOT edu)
// Starting time: January, 2010

(* ****** ****** *)

#include "contrib/SDL/SATS/SDL_active.sats"
#include "contrib/SDL/SATS/SDL_keyboard.sats"

(* ****** ****** *)

abst@ype SDL_EventType = $extype"SDL_EventType"

typedef SDL_Event =
  $extype_struct "SDL_Event" of {
  type= SDL_EventType
, _rest= undefined_t // this field cannot be accessed
} // end of [SDL_Event]

propdef SDL_Event_castdn_t (a:t@ype) = {l:addr}
  (SDL_Event @ l) -<prf> (a @ l, a @ l -<lin,prf> SDL_Event @ l)
// end of [SDL_Event_castdn_t]

(* ****** ****** *)

castfn
int_of_SDL_EventType
  (x: SDL_EventType):<> int
overload int_of with int_of_SDL_EventType
//
fun
eq_SDL_EventType_SDL_EventType (
  x1: SDL_EventType, x2: SDL_EventType
) :<> bool
  = "atsctrb_eq_SDL_EventType_SDL_EventType"
overload = with eq_SDL_EventType_SDL_EventType
//
macdef SDL_ACTIVEEVENT =
  $extval (SDL_EventType, "SDL_ACTIVEEVENT")
macdef SDL_KEYDOWN = $extval (SDL_EventType, "SDL_KEYDOWN")
macdef SDL_KEYUP = $extval (SDL_EventType, "SDL_KEYUP")
macdef SDL_MOUSEMOTION = $extval (SDL_EventType, "SDL_MOUSEMOTION")
macdef SDL_MOUSEBUTTONDOWN = $extval (SDL_EventType, "SDL_MOUSEBUTTONDOWN")
macdef SDL_MOUSEBUTTONUP = $extval (SDL_EventType, "SDL_MOUSEBUTTONUP")
macdef SDL_JOYAXISMOTION = $extval (SDL_EventType, "SDL_JOYAXISMOTION")
macdef SDL_JOYBALLMOTION = $extval (SDL_EventType, "SDL_JOYBALLMOTION")
macdef SDL_JOYHATMOTION = $extval (SDL_EventType, "SDL_JOYHATMOTION")

macdef SDL_JOYBUTTONDOWN = $extval (SDL_EventType, "SDL_JOYBUTTONDOWN")
macdef SDL_JOYBUTTONUP = $extval (SDL_EventType, "SDL_JOYBUTTONUP")
macdef SDL_QUIT = $extval (SDL_EventType, "SDL_QUIT")
macdef SDL_SYSWMEVENT = $extval (SDL_EventType, "SDL_SYSWMEVENT")
macdef SDL_VIDEORESIZE = $extval (SDL_EventType, "SDL_VIDEORESIZE")
macdef SDL_VIDEOEXPOSE = $extval (SDL_EventType, "SDL_VIDEOEXPOSE")

fun SDL_Event_type
  (x: &SDL_Event):<> SDL_EventType = "mac#atsctrb_SDL_Event_type"
// end of [SDL_Event_type]

(* ****** ****** *)

typedef SDL_ActiveEvent =
  $extype_struct "SDL_ActiveEvent" of {
  type= Uint8, gain= Uint8, state= Uint8
} // end of [SDL_ActiveEvent]

praxi SDL_Event_active_castdn : SDL_Event_castdn_t (SDL_ActiveEvent)

(* ****** ****** *)

typedef SDL_KeyboardEvent =
  $extype_struct "SDL_KeyboardEvent" of {
  type= Uint8, which= Uint8, state= Uint8, keysym= SDL_keysym
} // end of [SDL_KeyboardEvent]

praxi SDL_Event_key_castdn : SDL_Event_castdn_t (SDL_KeyboardEvent)

(* ****** ****** *)
  
typedef SDL_MouseMotionEvent =
  $extype_struct "SDL_MouseMotionEvent" of {
  type= Uint8
, which= Uint8
, state= Uint8
, x= Uint16
, y= Uint16
, xrel= Sint16
, yrel= Sint16
} // end of [SDL_MouseMotionEvent]

praxi SDL_Event_motion_castdn : SDL_Event_castdn_t (SDL_MouseMotionEvent)

(* ****** ****** *)

typedef SDL_MouseButtonEvent =
  $extype_struct "SDL_MouseButtonEvent" of {
  type= Uint8
, which= Uint8
, button= Uint8
, state= Uint8
, x= Uint16
, y= Uint16
} // end of [SDL_MouseButtonEvent]

praxi SDL_Event_button_castdn : SDL_Event_castdn_t (SDL_MouseButtonEvent)

(* ****** ****** *)

typedef SDL_JoyAxisEvent =
  $extype_struct "SDL_JoyAxisEvent" of {
  type= Uint8
, which= Uint8
, axis= Uint8
, value= Sint16
} // end of [SDL_JoyAxisEvent]

praxi SDL_Event_jaxis_castdn : SDL_Event_castdn_t (SDL_JoyAxisEvent)

(* ****** ****** *)

typedef SDL_JoyBallEvent =
  $extype_struct "SDL_JoyBallEvent" of {
  type= Uint8
, which= Uint8
, ball= Uint8
, xrel= Sint16
, yrel= Sint16
} // end of [SDL_JoyBallEvent]

praxi SDL_Event_jball_castdn : SDL_Event_castdn_t (SDL_JoyBallEvent)

(* ****** ****** *)

typedef SDL_JoyButtonEvent =
  $extype_struct "SDL_JoyButtonEvent" of {
  type= Uint8
, which= Uint8
, button= Uint8
, state= Uint8
} // end of [SDL_JoyButtonEvent]

praxi SDL_Event_jbutton_castdn : SDL_Event_castdn_t (SDL_JoyButtonEvent)

(* ****** ****** *)

typedef SDL_ResizeEvent =
  $extype_struct "SDL_ResizeEvent" of { type= Uint8, w= int, h= int }
// end of [SDL_ResizeEvent]

praxi SDL_Event_resize_castdn : SDL_Event_castdn_t (SDL_ResizeEvent)

(* ****** ****** *)

typedef SDL_ExposeEvent =
  $extype_struct "SDL_ExposeEvent" of { type= Uint8 } 
// end of [SDL_ExposeEvent]

praxi SDL_Event_expose_castdn : SDL_Event_castdn_t (SDL_ExposeEvent)

(* ****** ****** *)

typedef SDL_QuitEvent =
  $extype_struct "SDL_QuitEvent" of { type= Uint8 } 
// end of [SDL_QuitEvent]

(* ****** ****** *)

fun SDL_PollEvent (
  event: &SDL_Event? >> opt (SDL_Event, i>0)
) : #[i:two] int i
  = "mac#atsctrb_SDL_PollEvent"

fun SDL_PollEvent_null
  (): [i:two] int i = "mac#atsctrb_SDL_PollEvent_null"
// end of [SDL_PollEvent_null]

(* ****** ****** *)

////

/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997-2009 Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Sam Lantinga
    slouken@libsdl.org
*/

/**
 *  @file SDL_events.h
 *  Include file for SDL event handling
 */

#ifndef _SDL_events_h
#define _SDL_events_h

#include "SDL_stdinc.h"
#include "SDL_error.h"
#include "SDL_active.h"
#include "SDL_keyboard.h"
#include "SDL_mouse.h"
#include "SDL_joystick.h"
#include "SDL_quit.h"

#include "begin_code.h"
/* Set up for C function definitions, even when using C++ */
#ifdef __cplusplus
extern "C" {
#endif

/** @name General keyboard/mouse state definitions */
/*@{*/
#define SDL_RELEASED	0
#define SDL_PRESSED	1
/*@}*/

/** Event enumerations */
typedef enum {
       SDL_NOEVENT = 0,			/**< Unused (do not remove) */
       SDL_ACTIVEEVENT,			/**< Application loses/gains visibility */
       SDL_KEYDOWN,			/**< Keys pressed */
       SDL_KEYUP,			/**< Keys released */
       SDL_MOUSEMOTION,			/**< Mouse moved */
       SDL_MOUSEBUTTONDOWN,		/**< Mouse button pressed */
       SDL_MOUSEBUTTONUP,		/**< Mouse button released */
       SDL_JOYAXISMOTION,		/**< Joystick axis motion */
       SDL_JOYBALLMOTION,		/**< Joystick trackball motion */
       SDL_JOYHATMOTION,		/**< Joystick hat position change */
       SDL_JOYBUTTONDOWN,		/**< Joystick button pressed */
       SDL_JOYBUTTONUP,			/**< Joystick button released */
       SDL_QUIT,			/**< User-requested quit */
       SDL_SYSWMEVENT,			/**< System specific event */
       SDL_EVENT_RESERVEDA,		/**< Reserved for future use.. */
       SDL_EVENT_RESERVEDB,		/**< Reserved for future use.. */
       SDL_VIDEORESIZE,			/**< User resized video mode */
       SDL_VIDEOEXPOSE,			/**< Screen needs to be redrawn */
       SDL_EVENT_RESERVED2,		/**< Reserved for future use.. */
       SDL_EVENT_RESERVED3,		/**< Reserved for future use.. */
       SDL_EVENT_RESERVED4,		/**< Reserved for future use.. */
       SDL_EVENT_RESERVED5,		/**< Reserved for future use.. */
       SDL_EVENT_RESERVED6,		/**< Reserved for future use.. */
       SDL_EVENT_RESERVED7,		/**< Reserved for future use.. */
       /** Events SDL_USEREVENT through SDL_MAXEVENTS-1 are for your use */
       SDL_USEREVENT = 24,
       /** This last event is only for bounding internal arrays
	*  It is the number of bits in the event mask datatype -- Uint32
        */
       SDL_NUMEVENTS = 32
} SDL_EventType;

/** @name Predefined event masks */
/*@{*/
#define SDL_EVENTMASK(X)	(1<<(X))
typedef enum {
	SDL_ACTIVEEVENTMASK	= SDL_EVENTMASK(SDL_ACTIVEEVENT),
	SDL_KEYDOWNMASK		= SDL_EVENTMASK(SDL_KEYDOWN),
	SDL_KEYUPMASK		= SDL_EVENTMASK(SDL_KEYUP),
	SDL_KEYEVENTMASK	= SDL_EVENTMASK(SDL_KEYDOWN)|
	                          SDL_EVENTMASK(SDL_KEYUP),
	SDL_MOUSEMOTIONMASK	= SDL_EVENTMASK(SDL_MOUSEMOTION),
	SDL_MOUSEBUTTONDOWNMASK	= SDL_EVENTMASK(SDL_MOUSEBUTTONDOWN),
	SDL_MOUSEBUTTONUPMASK	= SDL_EVENTMASK(SDL_MOUSEBUTTONUP),
	SDL_MOUSEEVENTMASK	= SDL_EVENTMASK(SDL_MOUSEMOTION)|
	                          SDL_EVENTMASK(SDL_MOUSEBUTTONDOWN)|
	                          SDL_EVENTMASK(SDL_MOUSEBUTTONUP),
	SDL_JOYAXISMOTIONMASK	= SDL_EVENTMASK(SDL_JOYAXISMOTION),
	SDL_JOYBALLMOTIONMASK	= SDL_EVENTMASK(SDL_JOYBALLMOTION),
	SDL_JOYHATMOTIONMASK	= SDL_EVENTMASK(SDL_JOYHATMOTION),
	SDL_JOYBUTTONDOWNMASK	= SDL_EVENTMASK(SDL_JOYBUTTONDOWN),
	SDL_JOYBUTTONUPMASK	= SDL_EVENTMASK(SDL_JOYBUTTONUP),
	SDL_JOYEVENTMASK	= SDL_EVENTMASK(SDL_JOYAXISMOTION)|
	                          SDL_EVENTMASK(SDL_JOYBALLMOTION)|
	                          SDL_EVENTMASK(SDL_JOYHATMOTION)|
	                          SDL_EVENTMASK(SDL_JOYBUTTONDOWN)|
	                          SDL_EVENTMASK(SDL_JOYBUTTONUP),
	SDL_VIDEORESIZEMASK	= SDL_EVENTMASK(SDL_VIDEORESIZE),
	SDL_VIDEOEXPOSEMASK	= SDL_EVENTMASK(SDL_VIDEOEXPOSE),
	SDL_QUITMASK		= SDL_EVENTMASK(SDL_QUIT),
	SDL_SYSWMEVENTMASK	= SDL_EVENTMASK(SDL_SYSWMEVENT)
} SDL_EventMask ;
#define SDL_ALLEVENTS		0xFFFFFFFF
/*@}*/

/** Application visibility event structure */
typedef struct SDL_ActiveEvent {
	Uint8 type;	/**< SDL_ACTIVEEVENT */
	Uint8 gain;	/**< Whether given states were gained or lost (1/0) */
	Uint8 state;	/**< A mask of the focus states */
} SDL_ActiveEvent;

/** Keyboard event structure */
typedef struct SDL_KeyboardEvent {
	Uint8 type;	/**< SDL_KEYDOWN or SDL_KEYUP */
	Uint8 which;	/**< The keyboard device index */
	Uint8 state;	/**< SDL_PRESSED or SDL_RELEASED */
	SDL_keysym keysym;
} SDL_KeyboardEvent;

/** Mouse motion event structure */
typedef struct SDL_MouseMotionEvent {
	Uint8 type;	/**< SDL_MOUSEMOTION */
	Uint8 which;	/**< The mouse device index */
	Uint8 state;	/**< The current button state */
	Uint16 x, y;	/**< The X/Y coordinates of the mouse */
	Sint16 xrel;	/**< The relative motion in the X direction */
	Sint16 yrel;	/**< The relative motion in the Y direction */
} SDL_MouseMotionEvent;

/** Mouse button event structure */
typedef struct SDL_MouseButtonEvent {
	Uint8 type;	/**< SDL_MOUSEBUTTONDOWN or SDL_MOUSEBUTTONUP */
	Uint8 which;	/**< The mouse device index */
	Uint8 button;	/**< The mouse button index */
	Uint8 state;	/**< SDL_PRESSED or SDL_RELEASED */
	Uint16 x, y;	/**< The X/Y coordinates of the mouse at press time */
} SDL_MouseButtonEvent;

/** Joystick axis motion event structure */
typedef struct SDL_JoyAxisEvent {
	Uint8 type;	/**< SDL_JOYAXISMOTION */
	Uint8 which;	/**< The joystick device index */
	Uint8 axis;	/**< The joystick axis index */
	Sint16 value;	/**< The axis value (range: -32768 to 32767) */
} SDL_JoyAxisEvent;

/** Joystick trackball motion event structure */
typedef struct SDL_JoyBallEvent {
	Uint8 type;	/**< SDL_JOYBALLMOTION */
	Uint8 which;	/**< The joystick device index */
	Uint8 ball;	/**< The joystick trackball index */
	Sint16 xrel;	/**< The relative motion in the X direction */
	Sint16 yrel;	/**< The relative motion in the Y direction */
} SDL_JoyBallEvent;

/** Joystick hat position change event structure */
typedef struct SDL_JoyHatEvent {
	Uint8 type;	/**< SDL_JOYHATMOTION */
	Uint8 which;	/**< The joystick device index */
	Uint8 hat;	/**< The joystick hat index */
	Uint8 value;	/**< The hat position value:
			 *   SDL_HAT_LEFTUP   SDL_HAT_UP       SDL_HAT_RIGHTUP
			 *   SDL_HAT_LEFT     SDL_HAT_CENTERED SDL_HAT_RIGHT
			 *   SDL_HAT_LEFTDOWN SDL_HAT_DOWN     SDL_HAT_RIGHTDOWN
			 *  Note that zero means the POV is centered.
			 */
} SDL_JoyHatEvent;

/** Joystick button event structure */
typedef struct SDL_JoyButtonEvent {
	Uint8 type;	/**< SDL_JOYBUTTONDOWN or SDL_JOYBUTTONUP */
	Uint8 which;	/**< The joystick device index */
	Uint8 button;	/**< The joystick button index */
	Uint8 state;	/**< SDL_PRESSED or SDL_RELEASED */
} SDL_JoyButtonEvent;

/** The "window resized" event
 *  When you get this event, you are responsible for setting a new video
 *  mode with the new width and height.
 */
typedef struct SDL_ResizeEvent {
	Uint8 type;	/**< SDL_VIDEORESIZE */
	int w;		/**< New width */
	int h;		/**< New height */
} SDL_ResizeEvent;

/** The "screen redraw" event */
typedef struct SDL_ExposeEvent {
	Uint8 type;	/**< SDL_VIDEOEXPOSE */
} SDL_ExposeEvent;

/** The "quit requested" event */
typedef struct SDL_QuitEvent {
	Uint8 type;	/**< SDL_QUIT */
} SDL_QuitEvent;

/** A user-defined event type */
typedef struct SDL_UserEvent {
	Uint8 type;	/**< SDL_USEREVENT through SDL_NUMEVENTS-1 */
	int code;	/**< User defined event code */
	void *data1;	/**< User defined data pointer */
	void *data2;	/**< User defined data pointer */
} SDL_UserEvent;

/** If you want to use this event, you should include SDL_syswm.h */
struct SDL_SysWMmsg;
typedef struct SDL_SysWMmsg SDL_SysWMmsg;
typedef struct SDL_SysWMEvent {
	Uint8 type;
	SDL_SysWMmsg *msg;
} SDL_SysWMEvent;

/** General event structure */
typedef union SDL_Event {
	Uint8 type;
	SDL_ActiveEvent active;
	SDL_KeyboardEvent key;
	SDL_MouseMotionEvent motion;
	SDL_MouseButtonEvent button;
	SDL_JoyAxisEvent jaxis;
	SDL_JoyBallEvent jball;
	SDL_JoyHatEvent jhat;
	SDL_JoyButtonEvent jbutton;
	SDL_ResizeEvent resize;
	SDL_ExposeEvent expose;
	SDL_QuitEvent quit;
	SDL_UserEvent user;
	SDL_SysWMEvent syswm;
} SDL_Event;


/* Function prototypes */

/** Pumps the event loop, gathering events from the input devices.
 *  This function updates the event queue and internal input device state.
 *  This should only be run in the thread that sets the video mode.
 */
extern DECLSPEC void SDLCALL SDL_PumpEvents(void);

typedef enum {
	SDL_ADDEVENT,
	SDL_PEEKEVENT,
	SDL_GETEVENT
} SDL_eventaction;

/**
 *  Checks the event queue for messages and optionally returns them.
 *
 *  If 'action' is SDL_ADDEVENT, up to 'numevents' events will be added to
 *  the back of the event queue.
 *  If 'action' is SDL_PEEKEVENT, up to 'numevents' events at the front
 *  of the event queue, matching 'mask', will be returned and will not
 *  be removed from the queue.
 *  If 'action' is SDL_GETEVENT, up to 'numevents' events at the front 
 *  of the event queue, matching 'mask', will be returned and will be
 *  removed from the queue.
 *
 *  @return
 *  This function returns the number of events actually stored, or -1
 *  if there was an error.
 *
 *  This function is thread-safe.
 */
extern DECLSPEC int SDLCALL SDL_PeepEvents(SDL_Event *events, int numevents,
				SDL_eventaction action, Uint32 mask);

/** Polls for currently pending events, and returns 1 if there are any pending
 *  events, or 0 if there are none available.  If 'event' is not NULL, the next
 *  event is removed from the queue and stored in that area.
 */
extern DECLSPEC int SDLCALL SDL_PollEvent(SDL_Event *event);

/** Waits indefinitely for the next available event, returning 1, or 0 if there
 *  was an error while waiting for events.  If 'event' is not NULL, the next
 *  event is removed from the queue and stored in that area.
 */
extern DECLSPEC int SDLCALL SDL_WaitEvent(SDL_Event *event);

/** Add an event to the event queue.
 *  This function returns 0 on success, or -1 if the event queue was full
 *  or there was some other error.
 */
extern DECLSPEC int SDLCALL SDL_PushEvent(SDL_Event *event);

/** @name Event Filtering */
/*@{*/
typedef int (SDLCALL *SDL_EventFilter)(const SDL_Event *event);
/**
 *  This function sets up a filter to process all events before they
 *  change internal state and are posted to the internal event queue.
 *
 *  The filter is protypted as:
 *      @code typedef int (SDLCALL *SDL_EventFilter)(const SDL_Event *event); @endcode
 *
 * If the filter returns 1, then the event will be added to the internal queue.
 * If it returns 0, then the event will be dropped from the queue, but the 
 * internal state will still be updated.  This allows selective filtering of
 * dynamically arriving events.
 *
 * @warning  Be very careful of what you do in the event filter function, as 
 *           it may run in a different thread!
 *
 * There is one caveat when dealing with the SDL_QUITEVENT event type.  The
 * event filter is only called when the window manager desires to close the
 * application window.  If the event filter returns 1, then the window will
 * be closed, otherwise the window will remain open if possible.
 * If the quit event is generated by an interrupt signal, it will bypass the
 * internal queue and be delivered to the application at the next event poll.
 */
extern DECLSPEC void SDLCALL SDL_SetEventFilter(SDL_EventFilter filter);

/**
 *  Return the current event filter - can be used to "chain" filters.
 *  If there is no event filter set, this function returns NULL.
 */
extern DECLSPEC SDL_EventFilter SDLCALL SDL_GetEventFilter(void);
/*@}*/

/** @name Event State */
/*@{*/
#define SDL_QUERY	-1
#define SDL_IGNORE	 0
#define SDL_DISABLE	 0
#define SDL_ENABLE	 1
/*@}*/

/**
* This function allows you to set the state of processing certain events.
* If 'state' is set to SDL_IGNORE, that event will be automatically dropped
* from the event queue and will not event be filtered.
* If 'state' is set to SDL_ENABLE, that event will be processed normally.
* If 'state' is set to SDL_QUERY, SDL_EventState() will return the 
* current processing state of the specified event.
*/
extern DECLSPEC Uint8 SDLCALL SDL_EventState(Uint8 type, int state);

/* Ends C function definitions when using C++ */
#ifdef __cplusplus
}
#endif
#include "close_code.h"

#endif /* _SDL_events_h */
