// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __join_point_model_element_h__
#define __join_point_model_element_h__

#include <set>
using std::set;
#include <vector>
using std::vector;
#include <map>
using std::map;
#include <sstream>
using std::istringstream;

typedef vector<class JoinPointModelElement *> IdElementMap;
 
// The base class of all join point model elements

class JoinPointModelElement {
  // needed for reconciling the translation unit model with the project model
  mutable bool _ref;
  mutable JoinPointModelElement *_partner;
  
  /// a unique id for each joinpoint location
  int _id;
  
  /// map needed to locate model elements based on their ID
  IdElementMap *_map;

  /// assigned JPID for code generation
  int _assigned_id;
    
public:
  JoinPointModelElement () : _ref (false), _partner (0), _id (-1), _map (0),
    _assigned_id (-1) {}
  JoinPointModelElement (const JoinPointModelElement &copy) :
    _ref (false), _partner (0), _id (-1), _map (0), _assigned_id (-1) {}
  void assigned_id (int id) { _assigned_id = id; }
  int assigned_id () const { return _assigned_id; }
  bool is_ref () const { return _ref; }
  void ref (bool r = true) const { _ref = r; }
  JoinPointModelElement *partner () const { return _partner; }
  void partner (JoinPointModelElement *p) const { _partner = p; }
  int id () const { return _id; }
  void id (int new_id) {
    if (!_map) {
      cout << "element without map" << endl;
    }
    else {
      if (new_id == _id)
        return;
      if (_id != -1) {
        (*_map)[_id] = 0;
      }
      while ((unsigned)new_id >= _map->size ())
        _map->push_back (0);
      (*_map)[new_id] = this;
    }
    _id = new_id;
  }
  IdElementMap *map () const { return _map; }
  JoinPointModelElement *map (int id) const { return (*_map)[id]; }
  void map (IdElementMap *map) { _map = map; }
};

// container for element IDs

class IdSet : public set<int> {
  typedef set<int> _Base;
public:
  string to_string () const {
    if (_Base::empty ())
      return "";
    ostringstream out;
    for (_Base::iterator i = _Base::begin (); i != _Base::end (); ++i) {
      if (i != _Base::begin ())
        out << " ";
      out << *i;
    }
    return out.str ();
  }
  bool from_string (const string &id_str) {
    istringstream in (id_str, istringstream::in);
    int id;
    while (!in.eof ()) {
      in >> id;
      if (in.fail ())
        return false;
      else
        insert (id);
    }
    return true;
  }
};

#endif // __join_point_model_element_h__
