/* :: ascii-jump project
   :: $Id: jumper.c,v 1.2 2003/03/02 20:38:01 loth Exp $
   
   :: (C)opyright 2003  grzegorz moskal, g.moskal@opengruop.org
   :: license gnu gpl v 2						*/

#define JUMPER_C
#include "jumper.h"
#define OX ((K/2 < 100) ? wgp1[jumper->bend].ox : wgp2[jumper->bend].ox)
#define OY ((K/2 < 100) ? wgp1[jumper->bend].oy : wgp2[jumper->bend].oy)
#define SN ((K/2 < 100) ? wgp1[jumper->bend].sn : wgp2[jumper->bend].sn)
#define K  (jumper->current_hill->k)


void jumper_cpujump(struct object *jumper)
{
	int fail = 0, i;
	double k = K/2;
	jumper->bend = d(4)-1;
	for (i = 0; i < 5; i++) 
		jumper->judge[i] = 0;
	switch (jumper->level) {
	case 1:
		fail = 7;
		k -= k/3 + k/4;
		break;
	case 2:
		fail = 3;
		k -= k/4;
		break;
	case 3:
		k -= k/4;
		fail = 1;
		jumper->bend = d(2)-1;
		break;
	}

	if (d(10) <= fail)
		k -= K/2;
	else
		k += (d(jumper->level) ? 3 : 2) * d(K/10);
	jumper->alight = k;
	jumper_setpoints(jumper);
}

void jumper_tabsort(struct object **tab, int len)
{
	int i = 1;
	struct object *o;
	for (i = 1; tab[i] && i < len; i++)
		if (tab[i]->points < tab[i-1]->points) {
			o = tab[i-1];
			tab[i-1] = tab[i];
			tab[i] = o;
			i = 0;
		}
		
}

void jumper_change_mode(struct object *jumper, char *name, int color, int level, int in_use)
{
	jumper->color = color;
	jumper->in_use = in_use;
	jumper->level = level;
	if (name) {
		xfree(jumper->name);
		jumper->name = strdup(name);
	}
}

struct object* object_init(int color, int cx, int cy)
{
	struct object *obj = XALLOC(object);
	
	obj->current_x = cx;
	obj->current_y = cy;
	obj->color = color;
	
	return obj;
}

void jumper_flush(struct object *jumper, struct hill *m)
{
	jumper->current_hill = m;
	jumper->x = 62;
	jumper->y = m->caption[jumper->x]-1;
	jumper_animate(jumper, START);

	jumper->vx = 0.0; 
	jumper->vy = 0.0;
	jumper->px = 0.0;
	jumper->py = 0.0;

	jumper->bend = 0;
}

struct object* jumper_init(struct hill *m, struct frame *f, char *name)
{
	struct object *jumper =
		object_init(3, sl_screen_width/2-4, sl_screen_height/2-2);
	jumper->current_frame = f;
	jumper->color2 = Cyan;
	jumper_flush(jumper, m);
	jumper_change_mode(jumper, name, 1 + d(8), d(3), 0);
	return jumper;
}

void object_draw(struct object *o)
{
	frame_draw(o->current_frame, o->current_x, o->current_y, "oO0@-/\\_", o->color, o->color2);
}

void jumper_draw(struct object *jumper)
{
	char result[20];
	
	object_draw(jumper);
	
	sl_color(Green);
	sl_goto(0, HEIGHT-1);
	sl_addstr(jumper->name);

	if (jumper->state > TELEMARK) {
		int i = 0;
		sprintf(result, "%.2f _m  %.1f", jumper->alight, jumper->last_points);
		sl_goto(WIDTH-strlen(result)-1, HEIGHT-1);
		sl_addstr_alt(result, sl_strlen_alt(result), Cyan, Lcyan);
		for (; i < 5; i++) {
			sl_goto(WIDTH-7, 2*i+1);
			sprintf(result, "%1.1f ", jumper->judge[i]);
			sl_addstr_alt(result, sl_strlen_alt(result), Cyan, Lcyan);
		}
	} else {
		if (jumper->current_hill->owner)
			sprintf(result, "%10.10s - %3.2f", jumper->current_hill->owner,
				jumper->current_hill->record);
		else
			sprintf(result, "%10.10s - 0.0 m", "none");
		sl_goto(WIDTH-strlen(result)-7, HEIGHT-1);
		sl_color(Green);
		sl_addstr("record: ");
		sl_addstr(result);
	}
}

static int jumper_animate(struct object *jumper, int state)
{
	struct frame *f = jumper->current_frame;
	if (state == NEXT_FRAME) {
		for (; f; SWITCH(f))
			if (f->state != jumper->current_frame->state)
				break;
		jumper->current_frame = f;
	} else if (state == NEXT_GRASP) {
		if (jumper->current_frame->next && 
			jumper->current_frame->next->state ==
			jumper->current_frame->state) 
			SWITCH(jumper->current_frame);
		else
			return 0;
	} else if (state == PREV_GRASP) {
		if (jumper->current_frame->prev && 
			jumper->current_frame->prev->state ==
			jumper->current_frame->state) 
			PREV(jumper->current_frame);
		else
			return 0;
	} else {
		for (; f->prev; PREV(f));
		for (; f; SWITCH(f))
			if (f->state == state) 
				break;
		jumper->current_frame = f;
	}
	
	jumper->state = jumper->current_frame->state;
	return 1;
}

static void jumper_setpoints(struct object *jumper)
{
	double unit, points = 60;
	double lowest = 100, bigest = -2;
	int k = K/2, i;
	
	if (k >= 150) {
		unit = 1.2;
		points = 120;
	} else if (k >= 100)
		unit = 1.8;
	else if (k >= 50)
		unit = 2;
	else
		unit = 2.1;
		
	if (jumper->alight > k)
		for (; k <= jumper->alight; k++)
			points += unit;
	else if (jumper->alight < k)
		for (; k >= jumper->alight; k--)
			points -= unit;

	for (i = 0; i < 5; i++) {
		if (jumper->alight < K/2)
			jumper->judge[i] -= 3;
		if (jumper->bend == 3)
			jumper->judge[i] -= 1;
		jumper->judge[i] += 20;
		jumper->judge[i] -= d(jumper->bend)/d(2);
		if (d(2)-1)
			jumper->judge[i] -= 0.5;
		if (lowest > jumper->judge[i])
			lowest = jumper->judge[i];
		if (bigest < jumper->judge[i])
			bigest = jumper->judge[i];
	}

	for (i =0; i < 5; i++) {
		if (jumper->judge[i] == bigest) 
			bigest = -1;
		else if (jumper->judge[i] == lowest)
			lowest = -1;
		else
			points += jumper->judge[i];
	}
	
	jumper->points += points;
	jumper->last_points = points;

	if (jumper->current_hill->record < jumper->alight && jumper->state != CRASH) {
		jumper->current_hill->record = jumper->alight;
		xfree(jumper->current_hill->owner);
		jumper->current_hill->owner = strdup(jumper->name);
		jumper->new_owner = 1;
		record_write(jumper->current_hill->name, jumper->alight, jumper->name);
	}
}

static void jumper_service_crash(struct object *jumper)
{
	if (jumper->current_hill->caption[jumper->x] - jumper->y < 0) {
		int i = 0;
		jumper_animate(jumper, CRASH);
		jumper->alight = (jumper->x - jumper->current_hill->leapsill)/2;
		for (; i < 5; i++)
			jumper->judge[i] = -7;
		jumper_setpoints(jumper);
	}
}

static void jumper_service_telemark(struct object *jumper)
{
	int r = jumper->current_hill->caption[jumper->x] - jumper->y;

	if (r < 8 && r > 0) {
		if (r > 1 || d(10) > jumper->bend) {
			int i = 0;
			jumper_animate(jumper, TELEMARK);
			jumper->alight = (jumper->x - 
				jumper->current_hill->leapsill)/2 +
				((jumper->bend == 1) ? d(2): d(2)-1);
			if (d(13) ==  7)
				jumper->alight++;
			else if (d(13) == 13)
				jumper->alight--;
			for (; i < 5; i++) 
				jumper->judge[i] = 0;
			jumper->alight += (0.01 * d(100));
			jumper_setpoints(jumper);
		}
	} else 
			jumper_service_crash(jumper);
}

static void jumper_service_jump(struct object *jumper)
{
	double px = 0;

	if (jumper->x <= jumper->current_hill->leapsill -5)
		px = 0.4/d(4);
	else if (jumper->x <= jumper->current_hill->leapsill - 4)
		px = 0.6/d(10);
	else if (jumper->x <= jumper->current_hill->leapsill - 2)
		px = 0.3/d(12);
	else if (jumper->x >= jumper->current_hill->leapsill)
		px = 1.2/d(2);
		
	jumper->bend = 2;

	jumper->vx = 2.3 + K/100 - px;
	if (K/2 >= 100) {
		jumper->vx -= (K/2-99) * 0.013;
		jumper->y -= 2;
	}
	jumper->vy = K/230;
	
	jumper->px = jumper->x;
	jumper->py = jumper->y;
	
	jumper_animate(jumper, JUMP);
}

struct opory {
	double ox, oy ,sn;
} wgp1[] = {
	{ 3, 40, 2 },
	{ 0, 0, 1 },
	{ 3, 3, 2 },
	{ 3, 10, 4.6 }
},wgp2[] = {
	{ 8, 30, 6 },
	{ 0, 0, 1 },
	{ 10, 8, 5 },
	{ 3, 5, 3.2 },
};

void jumper_service_move(struct object *jumper)
{
	if (jumper->state == FLY || jumper->state == JUMP) {
		const double w1 = 1000, w2 = 200, G = 0.098; 
		double ax, ay = G;

		ax = -(OX * jumper->vx) / w1;
		ay = G + (OY * jumper->vy) / w1 - (SN * jumper->vx) / w2;

		jumper->vx += ax;
		jumper->vy += ay;
		jumper->px += jumper->vx;
		jumper->py += jumper->vy;

		jumper->x = (int)jumper->px;
		jumper->y = (int)jumper->py;
		if (d(50) == -7)
			jumper_service_lucky(jumper);
			
	} else if (jumper->state != START && jumper->state != FINISH) {
		jumper->y = jumper->current_hill->caption[jumper->x];
		jumper->vx = 3;
		if (jumper->state == RIDE || jumper->state == RIDE2)
			jumper->vx+= 0.5;
		jumper->x+= jumper->vx;
	} else
		jumper->vx = 0;
}

static void jumper_service_lucky(struct object *jumper)
{
	if (K/2 > 100)
		jumper->vx=2.5;
	else if (K/2 > 70)
		jumper->vx=3;
	else
		jumper->vx=3.5;
		
	jumper->vy=1;
}

int jumper_service(struct object *jumper, int key)
{
	jumper_service_move(jumper);
	
	if (key == 'q' && jumper->state > TELEMARK)
		jumper->state = FINISH;

	
	switch (jumper->state) {
	case START:
		if (key == '\n' || jumper->current_frame->prev) {
			if (jumper_animate(jumper, NEXT_GRASP) == 0)
				jumper_animate(jumper, DESCENT);
		}
		break; 
	case DESCENT:
		jumper_animate(jumper, NEXT_GRASP);
		if (jumper->x >= jumper->current_hill->pns)
			jumper_animate(jumper, RIDE);
		break; 
	case RIDE:
		jumper_animate(jumper, NEXT_GRASP);
		if (key == '\n' || jumper->x >= jumper->current_hill->leapsill)
			jumper_service_jump(jumper);
		break; 
	case JUMP:
		if (jumper_animate(jumper, NEXT_GRASP) == 0) {
			jumper_animate(jumper, FLY);
			jumper_animate(jumper, NEXT_GRASP);
			jumper_animate(jumper, NEXT_GRASP);
		}
		break; 
	case FLY:
		jumper_service_crash(jumper);
		if (key == sl_key_left && jumper->bend > 0) {
			jumper_animate(jumper, PREV_GRASP);	
			jumper->bend--;
		} else if (key == sl_key_right && jumper->bend < 3) {
			jumper_animate(jumper, NEXT_GRASP);	
			jumper->bend++;
		} else if (key == '\n') 
			jumper_service_telemark(jumper);
		else if (key == '`' && jumper->bend == 1) 
			jumper_service_lucky(jumper);
		
		break; 
		
	case TELEMARK:
		if (jumper_animate(jumper, NEXT_GRASP) == 0) {
			if (jumper->x < jumper->current_hill->pnz)
				jumper_animate(jumper, DESCENT2);
			else 
				jumper_animate(jumper, RIDE2);
		}
		break;
	case DESCENT2:
		jumper_animate(jumper, NEXT_GRASP);
		if (jumper->x >= jumper->current_hill->pnz)
			jumper_animate(jumper, RIDE2);
		break;
	case RIDE2:
		jumper_animate(jumper, NEXT_GRASP);
		if (jumper->x > jumper->current_hill->len-jumper->current_x-25)
			jumper_animate(jumper, STOP);
		
	break;
	case STOP:
		if (jumper_animate(jumper, NEXT_GRASP) == 0 &&
			jumper->x > jumper->current_hill->len-jumper->current_x-5)
			jumper->state = FINISH;
		break;
	case CRASH:
		jumper_animate(jumper, NEXT_GRASP);
		if (jumper->x > jumper->current_hill->len-jumper->current_x-15)
			jumper->state = FINISH;
		break;
	case FINISH:
		if (jumper->new_owner)
			jumper->new_owner = 0;
		if (key)
			return 0;
	}

	return 1;
}
