%define ver 3.0
%if %{?rel:0}%{!?rel:1}
%define rel 0
%endif
%if %{?srcext:0}%{!?srcext:1}
%define srcext .gz
%endif
Summary: ARGUS Software
Name: argus
Version: %ver
Release: %{rel}
License: see COPYING file
Group: Applications/Internet
Source: %{name}-%{version}.%{rel}.tar%{srcext}
URL: http://qosient.com/argus

%description
The ARGUS (Network Transaction Activity Monitor) is an IP network
transaction auditing tool.  The data generated by argus can be used
for a wide range of tasks such as network operations, security
and performance management.
Copyright: (c) 2000-2005 QoSient, LLC

%define argusdir	/usr/local
%define arguslog	/var/log/argus
%define argusdocs	/usr/share/doc/argus-%{ver}
%define argusdata	%{argusdir}/argus

%define argusbin	%{argusdir}/bin
%define argussbin	%{argusdir}/sbin

%prep
%setup -n %{name}-%{ver}.%{rel}
%build
%configure --prefix=/usr
make
mkdir -p %{argusdir}
mkdir -p %{argusbin}
mkdir -p %{argusdocs}
mkdir -p %{argusdata}
mkdir -p %{argusdata}/archive
mkdir -p %{argussbin}
mkdir -p %{arguslog}

cp -Rp support %{argusdocs}
cp -Rp doc/* %{argusdocs}

install -m 0444 -o root -g root README %{argusdata}
install -m 0444 -o root -g root COPYING %{argusdata}

install -m 0555 -o root -g root bin/argus %{argussbin}
install -m 0555 -o root -g root bin/ntasbug %{argusbin}

install -m 0444 -o root -g root man/man5/* %{_mandir}/man5/
install -m 0444 -o root -g root man/man8/* %{_mandir}/man8/

install -m 0600 -o root -g root support/Config/argus.conf /etc/argus.conf
install -m 0755 -o root -g root support/Startup/argus /etc/rc.d/init.d/argus

install -m 0755 -o root -g root support/Archive/argusarchive %{argusbin}/argusarchive

%post
/sbin/chkconfig --add argus
service argus start >/dev/null 2>&1

%preun
if [ "$1" = 0 ] ; then
  service argus stop >/dev/null 2>&1
  /sbin/chkconfig --del argus
fi

%postun
if [ "$1" -ge "1" ]; then
  service argus condrestart >/dev/null 2>&1
fi

%files
%defattr(-,root,root)
%{argussbin}/argus
%{argusbin}/ntasbug
%{argusdata}
%doc %{argusdocs}
%{_mandir}/man5/argus.5
%{_mandir}/man5/argus.conf.5
%{_mandir}/man8/argus.8

/var/log/argus
/etc/rc.d/init.d/argus

%config /etc/argus.conf
