/*
 * Argus Software.  Argus files - Arp Procession
 * Copyright (c) 2000-2006 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* 
 * $Id: $
 * $DateTime: $
 * $Change: $
 */

#if !defined(ArgusArp)
#define ArgusArp
#endif

#include <stdio.h>
#include <ArgusModeler.h>
#include <argus_os.h>

#if !defined(__OpenBSD__)
#include <net/if_arp.h>
#endif

#include <string.h>
#include <errno.h>


#if !defined(REVARP_REQUEST)
#define REVARP_REQUEST          3
#endif
#if !defined(REVARP_REPLY)
#define REVARP_REPLY            4
#endif

void ArgusUpdateArpState (struct ArgusModelerStruct *, struct ArgusFlowStruct *, unsigned char *);

struct ArgusSystemFlow *
ArgusCreateArpFlow (struct ArgusModelerStruct *model, struct ether_header *ep) 
{
   struct ArgusSystemFlow *retn = NULL;
   unsigned char *srcehost = NULL;
   unsigned char *tarehost = NULL;
   unsigned int arp_tpa, arp_spa;
   struct ether_arp *arp = (struct ether_arp *)model->ArgusThisUpHdr;

   if (STRUCTCAPTURED(model, *arp)) {
      retn = model->ArgusThisFlow;

      retn->hdr.type              = ARGUS_FLOW_DSR;
      retn->hdr.subtype           = ARGUS_FLOW_CLASSIC5TUPLE;
      retn->hdr.argus_dsrvl8.len  = 5;
#if defined(ALIGN_64BIT)
      retn->hdr.pad[0] = 0;
      retn->hdr.pad[1] = 0;
      retn->hdr.pad[2] = 0;
#endif

#ifdef _LITTLE_ENDIAN
      arp->arp_hrd = ntohs(arp->arp_hrd);
      arp->arp_pro = ntohs(arp->arp_pro);
      arp->arp_op  = ntohs(arp->arp_op);
#endif

      switch (arp->arp_op) {
         case ARPOP_REQUEST:
            retn->hdr.argus_dsrvl8.qual = ARGUS_TYPE_ARP;
            srcehost = (unsigned char *) &model->ArgusThisEpHdr->ether_shost;
            bcopy ((char *)&arp->arp_tpa, &arp_tpa, sizeof(arp_tpa));
            bcopy ((char *)&arp->arp_spa, &arp_spa, sizeof(arp_spa));
#ifdef _LITTLE_ENDIAN
            arp_spa = ntohl(arp_spa);
            arp_tpa = ntohl(arp_tpa);
#endif
            if (arp_spa > arp_tpa)
               model->state |= ARGUS_DIRECTION;

            bcopy (srcehost, retn->arp_flow.etheraddr, sizeof (retn->arp_flow.etheraddr));

            retn->arp_flow.arp_tpa = arp_tpa;
            retn->arp_flow.arp_spa = arp_spa;
            retn->arp_flow.pad = 0;
            break;
   
         case ARPOP_REPLY:
            retn->hdr.argus_dsrvl8.qual = ARGUS_TYPE_ARP;
            srcehost = (unsigned char *) &model->ArgusThisEpHdr->ether_dhost;

            bcopy ((char *)&arp->arp_spa, &arp_spa, sizeof(arp_tpa));
            bcopy ((char *)&arp->arp_tpa, &arp_tpa, sizeof(arp_spa));
#ifdef _LITTLE_ENDIAN
            arp_spa = ntohl(arp_spa);
            arp_tpa = ntohl(arp_tpa);
#endif

            if (arp_tpa > arp_spa)
               model->state |= ARGUS_DIRECTION;
   
            bcopy (srcehost, retn->arp_flow.etheraddr, sizeof (retn->arp_flow.etheraddr));

            retn->arp_flow.arp_tpa = arp_tpa;
            retn->arp_flow.arp_spa = arp_spa;
            retn->arp_flow.pad = 0;
            break;

         case REVARP_REQUEST:
            retn->hdr.argus_dsrvl8.qual = ARGUS_TYPE_RARP;
            bcopy ((char *)&arp->arp_tpa, &arp_tpa, sizeof(arp_tpa));
#ifdef _LITTLE_ENDIAN
            arp_tpa = ntohl(arp_tpa);
#endif

            srcehost = (unsigned char *)&THA(arp);
            tarehost = (unsigned char *)&SHA(arp);
            bcopy ((char *)&arp->arp_tpa, &retn->rarp_flow.arp_tpa, sizeof(arp_tpa));
            bcopy (srcehost, retn->rarp_flow.srceaddr, sizeof (retn->rarp_flow.srceaddr));
            bcopy (tarehost, retn->rarp_flow.tareaddr, sizeof (retn->rarp_flow.tareaddr));
            break;

         case REVARP_REPLY:
            retn->hdr.argus_dsrvl8.qual = ARGUS_TYPE_RARP;
            bcopy ((char *)&arp->arp_tpa, &arp_tpa, sizeof(arp_tpa));
#ifdef _LITTLE_ENDIAN
            arp_tpa = ntohl(arp_tpa);
#endif
            srcehost = (unsigned char *)&SHA(arp);
            tarehost = (unsigned char *)&THA(arp);
            bcopy ((char *)&arp->arp_tpa, &retn->rarp_flow.arp_tpa, sizeof(arp_tpa));
            bcopy (srcehost, retn->rarp_flow.srceaddr, sizeof (retn->rarp_flow.srceaddr));
            bcopy (tarehost, retn->rarp_flow.tareaddr, sizeof (retn->rarp_flow.tareaddr));
            break;
      }
   }

#ifdef ARGUSDEBUG
   ArgusDebug (8, "ArgusCreateArpFlow (0x%x) returning %d\n", ep, retn);
#endif

   return (retn);
}

void
ArgusUpdateArpState (struct ArgusModelerStruct *model, struct ArgusFlowStruct *flowstr, unsigned char *state)
{
   struct ether_arp *arp = NULL;
   struct ArgusARPObject *arpobj = NULL;

   if (model->ArgusThisEpHdr == NULL)
      return;

   arp = (struct ether_arp *)(model->ArgusThisEpHdr + 1);

   if (STRUCTCAPTURED(model, *arp)) {
      model->ArgusThisLength -= sizeof(*arp);
      model->ArgusSnapLength -= sizeof(*arp);
      model->ArgusThisUpHdr = (unsigned char *)(arp + 1);

      arpobj = &flowstr->canon.net.net_union.arp;

      switch (arp->arp_op) {
         case ARPOP_REQUEST:
            break;

         case ARPOP_REPLY:
            bcopy ((unsigned char *)&SHA(arp), arpobj->respaddr, 6);
            break;
      }
   }
}
