import gtk
import msg

(DOWNLOAD_FINISHED, CREATE_FINISHED) =range(2)
class MessageBox:
    
    def ShowInfo(self, text = '', parentWindow= None):
        dlg = gtk.MessageDialog(parentWindow, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, text)
        dlg.set_markup(text)
        dlg.run()
        dlg.destroy()
        return
  
    def ShowError(self, text = '', parentWindow= None):
        dlg= gtk.MessageDialog(parentWindow, gtk.DIALOG_MODAL,    gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, text)
        dlg.set_markup(text)
        dlg.run()
        dlg.destroy()
        return
        
    def ShowQuestionOkCancel(self,text, parentWindow= None):
        dlg = gtk.MessageDialog (parentWindow, gtk.DIALOG_MODAL, gtk.MESSAGE_WARNING, gtk.BUTTONS_OK_CANCEL, text)
        dlg.set_markup(text)
        response = dlg.run ()
        dlg.destroy ()
        
        return (response == gtk.RESPONSE_OK)
        
    def ShowQuestion(self,text, parentWindow= None):
        dlg = gtk.MessageDialog (parentWindow, gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, text)
        dlg.set_markup(text)
        response = dlg.run ()
        dlg.destroy ()
        
        return (response == gtk.RESPONSE_YES)

    def ShowFinished(self,gladeFile,filePath):
        a = BurnCreateMsg(gladeFile,filePath)
        result =  a.run()
        return result, a.checked()

class BurnCreateMsg:
    def __init__(self, gladeFileName,filepath =''):
        self.formName = "frmDownloadFinished"
        self.filepath = filepath
        self.gladeFile = gtk.glade.XML(gladeFileName, self.formName)
        self.__checked = False
    
    def checked(self):
        return self.__checked
    
    def run(self):
        """This function will show the aboutDialog"""
        #Get the actual dialog widget
        frmMsg = self.gladeFile.get_widget(self.formName)
        frmMsg.set_position(gtk.WIN_POS_CENTER)
        frmMsg.set_modal(True)
        
        self.lblMsg = self.gladeFile.get_widget("lblMsg")
        self.ckboxRemoveTemp = self.gladeFile.get_widget("ckboxRemoveTemp")
        
        self.lblMsg.set_markup(msg.MESSAGE_0068 % self.filepath)           
            
        #run the dialog and store the response        
        result = frmMsg.run()
        
        self.__checked = self.ckboxRemoveTemp.get_active() 
        #we are done with the dialog, destory it
        frmMsg.destroy()
        
        #return the result
        return     result
        
        