#!/usr/bin/python
# -*- coding: iso-8859-15 -*-
######################################################
##
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
##
######################################################
## 
#  Project: AptOnCd
#  File: MediaSplitter.py
#  Author: Laudeci Oliveira <laudeci@gmail.com>
#  Creation: 09/01/2007
#  Changed: 
#  Purpose: 
##
######################################################
import PackagesParser
import os

class Splitter:
    """
        Class used to split repository's files into cds/dvds.
    """
    def __init__(self, fromPath, toPath, dist, version, sections, arch, cdSize):
        self.fromPath = os.path.expanduser( fromPath)
        self.toPath = os.path.expanduser(toPath)
        self.defaultPath = fromPath
        self.destPath = toPath
        self.dist = dist
        self.version = version
        self.sections = sections
        self.section_size = dict.fromkeys(sections, 0)
        self.arch= arch
        self.cdSize = cdSize
        self.tar_paths = (self.defaultPath  +'/'+ self.dist  + '/dists/'  + self.version +"/%s"+'/binary-'+self.arch).replace('//','/')
        self.pack_paths = (self.tar_paths + '/Packages.gz' ).replace('//','/')
        
    def SplitMedia(self):
        """
            Function used to create a list of files splitted into medias
            based in a given media size.
        """
        #get files from packages.gz
        # and store it in a dictionary based by section name and it's files.
        values ={}
        for section in self.sections:
            #get Packages.gz contents
            sFile =self.pack_paths % section
            s= PackagesParser.ParseGZ(sFile)
            #return only existing itens
            values[section] = self.check_Exist(s.Parse())

        # get sections sizes and order it desc by section size.
        # using this method the biggest package will be processed first.
        for sec in self.sections:
            for n in values[sec]:
                self.section_size[sec] = float(self.section_size[sec]) + float(n.Size)
                n.PackageSection = sec

        iSorted = sorted(self.section_size.items(), lambda x, y: cmp(x[1], y[1]), reverse=True)
        print iSorted
        cds = self.CreateIsoList(self.cdSize, iSorted, values)

        return cds
        
    def CreateIsoList(self,size,packList = [],values = []):
        
        cds = {}
        actualSize = 0
        currentCD =0
        FolderDest = os.path.join(self.toPath,'repository/'+self.dist)
        
        FolderDest = os.path.join(FolderDest,self.version + '/media')
        for n in packList:
            pkgs = values[n[0]]

            for pkg in pkgs:
                if not (FolderDest  + str(currentCD)) in cds: 
                    cds[FolderDest  + str(currentCD)] = []
                    
                if ( actualSize + float(pkg.Size)) > size:
                        actualSize = 0
                        currentCD += 1
                        cds[FolderDest  + str(currentCD)] = []
                
                pkg.Destination = os.path.join( FolderDest + str(currentCD) , pkg.Filename)
                pkg.SourceLocation = os.path.join( self.defaultPath  +'/'+ self.dist , pkg.Filename) 
                pkg.TarGZ_Path =  FolderDest + str(currentCD) + '/dists/' + self.version + '/%s/binary-' + self.arch
                cds[FolderDest  + str(currentCD)].append(pkg)
                
                actualSize += float(pkg.Size)
        iSorted = sorted(cds.items(), lambda x, y: cmp(x[0][0], y[0][0]), reverse=True)
        return iSorted
        
    def check_Exist(self,lista):
        """
            This function gets packages returned from the parser and
            checks if all files listed in packages.gz exists locally.
            
            Returns: List with all packages files found locally and listed in Packages.gz sorted by package's name.
        """
        inti = 0 
        exist=[]
        for pack in lista:
            filepath = os.path.join(self.defaultPath , self.dist)
            filepath = os.path.join(filepath,pack.Filename)
            inti +=1
            #print inti, filepath ,os.path.isfile(filepath)
            if not os.path.isfile(filepath):
               #values.remove(pack)
               pass
            else:
               exist.append(pack)
        #sort alphabetically
        exist.sort(lambda x,b:cmp(x.Package,b.Package))
        return exist
        
