#ifndef EXPIRATION_H_
#define EXPIRATION_H_

#include "cacheman.h"

class expiration : public tCacheMan
{
public:
	expiration(int);
	virtual ~expiration();

protected:

	tS2DAT m_trashCandSet;
	set<tFileNdir> m_trashCandHeadSet; // just collect the list of seen head files

	void RemoveAndStoreStatus(bool bPurgeNow);
	void LoadTrashMapFromFile(bool bForceInsert);

	// callback implementations
	virtual void Action(const mstring &);
	// for FileHandler
	virtual bool ProcessRegular(const mstring &sPath, const struct stat &);

	// for ifileprocessor
	virtual void HandlePkgEntry(const tRemoteFileInfo &entry, bool bUnpackForCsumming);

	virtual void UpdateFingerprint(const mstring &sPathRel, off_t nOverrideSize,
				uint8_t *pOverrideSha1, uint8_t *pOverrideMd5);

	void LoadIgnoreList();

	void PurgeMaintLogs();

	void DropExceptionalVersions();

};

#endif /*EXPIRATION_H_*/
