#ifndef SOCKIO_H_
#define SOCKIO_H_

#include "meta.h"

#include <netinet/in.h>
#include <netinet/tcp.h>
#include <pthread.h>

#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netdb.h>

#include <cstddef>

using namespace MYSTD;


#ifndef AI_NUMERICSERV
#define AI_NUMERICSERV 0
#endif
#ifndef AI_ADDRCONFIG
#define AI_ADDRCONFIG 0
#endif

#ifndef MSG_NOSIGNAL
#define MSG_NOSIGNAL 0
#endif

#ifndef MSG_MORE
#define MSG_MORE 0
#endif

void termsocket(int);


#define forceShutdownClose(fd) if(fd>=0) { ::shutdown(fd, O_RDWR); while(0 != ::close(fd)) { if(errno != EINTR) break; }; fd=-1; }
// DUDES, who writes TCP implementations... why can this just not be done easy and reliable? Why do we need hacks like termsocket?
// For details, see: http://blog.netherlabs.nl/articles/2009/01/18/the-ultimate-so_linger-page-or-why-is-my-tcp-not-reliable
#define flushShutdownClose(fd) if(fd>=0) { ::termsocket(fd); fd=-1; }




#endif /*SOCKIO_H_*/
