#!/usr/bin/perl
#

use strict;
my %fddset;
my %fdvset;
# temp values within one data set
my @hosts;
my @pathsdeb;
my @pathsvol;

while(<>)
{
   chomp;
   s/^\s+//;
   s/\s+$//;
   next if /^#/;
   if(/(\S+)\s*:\s*(\S+)/)
   {
      my $key=$1;
      my $value=$2;

      if($key eq "Site" || $key eq "Alias" || $key eq "Includes" || $key eq "Aliases")
      {
         push(@hosts, split(/\s/, $value));
      }
      if($key eq "Archive-http" || $key eq "X-Archive-http")
      {
         push(@pathsdeb, $value);
      }
      if($key eq "Volatile-http" || $key eq "X-Volatile-http")
      {
         push(@pathsvol, $value);
      }
   }
   elsif(@hosts)
   {
      foreach my $h (@hosts)
      {
         $fddset{"$h$_"}=1 foreach @pathsdeb;
         $fdvset{"$h$_"}=1 foreach @pathsvol;
      }
      undef @hosts;
      undef @pathsdeb;
      undef @pathsvol;
   }

}

open(fdd, ">conf/deb_mirrors") || die;
open(fdv, ">conf/debvol_mirrors") || die;
print fdd "http://$_\n" foreach(sort(keys %fddset));
print fdv "http://$_\n" foreach(sort(keys %fdvset));
close(fdd) || die;
print "conf/deb_mirrors created\n";
close(fdv) || die;
print "conf/debvol_mirrors created\n";
