/* amSynth
 * (c) 2001-2003 Nick Dowell
 */
 
#include "Config.h"

#include <fstream>
#include <iostream>
#include <cstdlib>
#include <sstream>

using namespace std;

Config::Config()
{
	amsynthrc_fname = string(getenv("HOME")) + string("/.amSynthrc");
	sample_rate = midi_channel = active_voices = polyphony = debug_drivers = xruns = 0;
#ifdef ENABLE_REALTIME
	realtime = 0;
#endif
}

void
Config::Defaults	()
{
	audio_driver = "auto";
	midi_driver = "auto";
	oss_midi_device = "/dev/midi";
	midi_channel = 0;
	oss_audio_device = "/dev/dsp";
	alsa_audio_device = "default";
	sample_rate = 44100;
	channels = 2;
	buffer_size = 128;
	polyphony = 10;
	alsa_seq_client_name = "amSynth";
	current_bank_file = string (getenv ("HOME")) +
		string("/.amSynth.presets");
}

bool
Config::ParseCOpts	(int argc, char* argv[])
{
	optind = 1; // reset getopt
	int opt;
	while( (opt=getopt(argc, argv, "vhstdzm:c:a:r:p:b:U:P:"))!= -1 ) {
		switch(opt) {
			case 'm': 
				midi_driver = optarg;
				break;
			case 'b': 
				current_bank_file = optarg;
				break;
			case 'c':
				midi_channel = atoi( optarg ); 
				break;
			case 'a':
				audio_driver = optarg; 
				break;
			case 'd':
				debug_drivers = 1;
				break;
			case 'r':
				sample_rate = atoi( optarg );
				break;
			case 'p':
				polyphony = atoi( optarg );
				break;	
			case 'U':
				jack_session_uuid = optarg;
				break;
			default:
				break;
		}
	}
	return true;
}

int
Config::load	()
{
	string buffer;

	fstream file( amsynthrc_fname.c_str(), ios::in );
	while( file.good() ) {
		file >> buffer;
		if( buffer[0]=='#' ){
			// ignore lines beginning with '#' (comments)
			// this next line is needed to deal with a line with 
			// just a '#'
			file.unget();
			// this moves file on by a whole line, so we ignore it
			getline(file, buffer);
		} else if (buffer=="audio_driver"){
			file >> buffer;
			audio_driver = buffer;
		} else if (buffer=="midi_driver"){
			file >> buffer;
			midi_driver = buffer;
		} else if (buffer=="oss_midi_device"){
			file >> buffer;
			oss_midi_device = buffer;
		} else if (buffer=="midi_channel"){
			file >> buffer;
			istringstream(buffer) >> midi_channel;
		} else if (buffer=="oss_audio_device"){
			file >> buffer;
			oss_audio_device = buffer;
		} else if (buffer=="alsa_audio_device"){
			file >> buffer;
			alsa_audio_device = buffer;
		} else if (buffer=="sample_rate"){
			file >> buffer;
			istringstream(buffer) >> sample_rate;
		} else if (buffer=="polyphony"){
			file >> buffer;
			istringstream(buffer) >> polyphony;
		} else {
			file >> buffer;
		}
	}
	file.close();
	
	return 0;
}

int
Config::save	()
{
	FILE *fout = fopen (amsynthrc_fname.c_str(), "w"); if (NULL == fout) return -1;
	fprintf (fout, "midi_driver\t%s\n", midi_driver.c_str());
	fprintf (fout, "oss_midi_device\t%s\n", oss_midi_device.c_str());
	fprintf (fout, "midi_channel\t%d\n", midi_channel);
	fprintf (fout, "audio_driver\t%s\n", audio_driver.c_str());
	fprintf (fout, "oss_audio_device\t%s\n", oss_audio_device.c_str());
	fprintf (fout, "alsa_audio_device\t%s\n", alsa_audio_device.c_str());
	fprintf (fout, "sample_rate\t%d\n", sample_rate);
	fprintf (fout, "polyphony\t%d\n", polyphony);
	fclose (fout);
	return 0;
}
