#include "amanda.h"

#include "scsi-defs.h"
/*
 Handling of Sense codes which are returned from the device
 At the moment the following status us returned
 SENSE_ABORT	       	-> -1 , some strange happend, abort everything
 SENSE_IGNORE	       	-> 0 , nothing special, only info
 SENSE_NO_TAPE	       	-> 1 , this is for tape devices, not tape online (not used any longer ??)
 SENSE_RETRY	       	-> 2 , retry the command
 SENSE_IES	       	-> 3 , initialize element status
 SENSE_TAPE_NOT_LOADED 	-> 4 , no tape loaded
 SENSE_NO              	-> 5 , no sense information
 SENSE_TAPE_NOT_UNLOADED -> 6 , tape is not ejected
 SENSE_IES		-> FF , Sense from initialize element status
 */

	SenseType_T SenseType [] = {
/*
 * Generic one, this is used if not information is found based on the ident of the device
 */
	{ "generic", "", TYPE_TAPE,  SENSE_NULL, 0x0, 0x0, SENSE_NO, T_("No Sense")},
	{ "generic", "", TYPE_TAPE,  SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "generic", "", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, T_("Recovered Error")},
	{ "generic", "", TYPE_TAPE,  SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_RECOVERED_ERROR")},

	{ "generic", "", TYPE_TAPE , SENSE_NOT_READY, 0x0, 0x0, SENSE_IGNORE, T_("Not Ready")},
	{ "generic", "", TYPE_TAPE , SENSE_NOT_READY, 0x4, 0x1, SENSE_RETRY, T_("The drive is not ready, but it is in the process of becoming ready")},
	{ "generic", "", TYPE_TAPE , SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "generic", "", TYPE_TAPE,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "generic", "", TYPE_TAPE , SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Medium Error")},
	{ "generic", "", TYPE_TAPE,  SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_MEDIUM_ERROR")},

	{ "generic", "", TYPE_TAPE , SENSE_HARDWARE_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Hardware Error")},
	{ "generic", "", TYPE_TAPE,  SENSE_HARDWARE_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{ "generic", "", TYPE_TAPE , SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "generic", "", TYPE_TAPE,  SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "generic", "", TYPE_TAPE , SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "generic", "", TYPE_TAPE,  SENSE_UNIT_ATTENTION, UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "generic", "", TYPE_TAPE , UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},

	{ "generic", "", TYPE_CHANGER,  SENSE_NULL, 0x0, 0x0, SENSE_NO, T_("No Sense")},
	{ "generic", "", TYPE_CHANGER,  SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "generic", "", TYPE_CHANGER , SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, T_("Recovered Error")},
	{ "generic", "", TYPE_CHANGER,  SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_RECOVERED_ERROR")},

	{ "generic", "", TYPE_CHANGER , SENSE_NOT_READY, 0x0, 0x0, SENSE_IGNORE, T_("Not Ready")},
	{ "generic", "", TYPE_CHANGER , SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "generic", "", TYPE_CHANGER,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "generic", "", TYPE_CHANGER , SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Medium Error")},
	{ "generic", "", TYPE_CHANGER,  SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_MEDIUM_ERROR")},

	{ "generic", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Hardware Error")},
	{ "generic", "", TYPE_CHANGER,  SENSE_HARDWARE_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{ "generic", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "generic", "", TYPE_CHANGER,  SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "generic", "", TYPE_CHANGER , SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "generic", "", TYPE_CHANGER,  SENSE_UNIT_ATTENTION, UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "generic", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "generic", "", TYPE_CHANGER , UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},
/*
 *
 * ADIC DAT Autochanger
 *
 */
	{ "DAT AutoChanger", "", TYPE_CHANGER,  SENSE_NULL, 0x0, 0x0, SENSE_NO, T_("No Sense")},
	{ "DAT AutoChanger", "", TYPE_CHANGER,  SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "DAT AutoChanger", "", TYPE_CHANGER , SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, T_("Recovered Error")},
	{ "DAT AutoChanger", "", TYPE_CHANGER,  SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_RECOVERED_ERROR")},

	{ "DAT AutoChanger", "", TYPE_CHANGER , SENSE_NOT_READY, 0x0, 0x0, SENSE_IGNORE, T_("Not Ready")},
	{ "DAT AutoChanger", "", TYPE_CHANGER,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "DAT AutoChanger", "", TYPE_CHANGER , SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Medium Error")},
	{ "DAT AutoChanger", "", TYPE_CHANGER,  SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_MEDIUM_ERROR")},

	{ "DAT AutoChanger", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Hardware Error")},
	{ "DAT AutoChanger", "", TYPE_CHANGER,  SENSE_HARDWARE_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{ "DAT AutoChanger", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "DAT AutoChanger", "", TYPE_CHANGER,  SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "DAT AutoChanger", "", TYPE_CHANGER , SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "DAT AutoChanger", "", TYPE_CHANGER , SENSE_UNIT_ATTENTION, 0x28, 0x01, SENSE_IES, T_("Door opend")},
	{ "DAT AutoChanger", "", TYPE_CHANGER,  SENSE_UNIT_ATTENTION, UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "DAT AutoChanger", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "DAT AutoChanger", "", TYPE_CHANGER , UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},

/*
 *
 *	L500 (for the L500 ATL library)
 * */

	{ "L500", "", TYPE_CHANGER,  SENSE_NULL, 0x0, 0x0, SENSE_NO, T_("No Sense")},
	{ "L500", "", TYPE_CHANGER,  SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "L500", "", TYPE_CHANGER , SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, T_("Recovered Error")},
	{ "L500", "", TYPE_CHANGER , SENSE_RECOVERED_ERROR, 0x0a, 0x0, SENSE_IGNORE, T_("Error Log overflow")},
	{ "L500", "", TYPE_CHANGER , SENSE_RECOVERED_ERROR, 0x44, 0xc1, SENSE_IGNORE, T_("EEPROM Copy 1 bad")},
	{ "L500", "", TYPE_CHANGER , SENSE_RECOVERED_ERROR, 0x44, 0xc2, SENSE_IGNORE, T_("EEPROM Copy 2 bad")},
	{ "L500", "", TYPE_CHANGER , SENSE_RECOVERED_ERROR, 0x47, 0x0, SENSE_IGNORE, T_("SCSI parity error")},
	{ "L500", "", TYPE_CHANGER , SENSE_RECOVERED_ERROR, 0x48, 0x0, SENSE_IGNORE, T_("SCSI IDE message received")},
	{ "L500", "", TYPE_CHANGER,  SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_RECOVERED_ERROR")},

	{ "L500", "", TYPE_CHANGER , SENSE_NOT_READY, 0x0, 0x0, SENSE_ABORT, T_("Scsi port not initialized")},
	{ "L500", "", TYPE_CHANGER , SENSE_NOT_READY, 0x04, 0x01, SENSE_RETRY, T_("Becoming ready, scanning magazines, etc")},
	{ "L500", "", TYPE_CHANGER , SENSE_NOT_READY, 0x04, 0x03, SENSE_ABORT, T_("Unit not ready: manual intervention required: Door Open")},
/* needed? */
	{ "L500", "", TYPE_CHANGER , SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
  	{ "L500", "", TYPE_CHANGER,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

/*	Not used by L500
	{ "L500", "", TYPE_CHANGER , SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Medium Error")},
	{ "L500", "", TYPE_CHANGER,  SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_MEDIUM_ERROR")},
*/
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x0,  0x0,  SENSE_ABORT, T_("Hardware Error")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x3a, 0x80, SENSE_ABORT, T_("Media not present")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x40, 0x84, SENSE_ABORT, T_("POST soft failure")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x44, 0x80, SENSE_ABORT, T_("Loader Communications timeout")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x44, 0x81, SENSE_ABORT, T_("Loader communications UART error or buffer overflow")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x44, 0x86, SENSE_ABORT, T_("bad status returned from loader")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x44, 0xc3, SENSE_ABORT, T_("EEPROM both copies bad")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x44, 0xff, SENSE_ABORT, T_("Unexpected status from test")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x70, SENSE_ABORT, T_("Cartridge has no home")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x71, SENSE_ABORT, T_("Loader mechanism problem")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x72, SENSE_ABORT, T_("Tape drive handle problem")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x73, SENSE_IGNORE, T_("No cartridge in drive during unload")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x74, SENSE_ABORT, T_("Loader mechanism problem, after retries")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x75, SENSE_ABORT, T_("Timeout moving cartridge from drive")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x76, SENSE_ABORT, T_("Timeout unloading cartridge into slot")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x77, SENSE_ABORT, T_("Couldn't unlock door after retries")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x78, SENSE_ABORT, T_("Error during SCAN MAGAZINE")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x79, SENSE_ABORT, T_("Couldn't lock door after retries")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x80, SENSE_ABORT, T_("Unexpected door open")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x81, SENSE_ABORT, T_("Didn't find all expected slots during elevator movement")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x82, SENSE_ABORT, T_("Cartridge alreay in drive during LOAD CARTRIDGE")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x83, SENSE_ABORT, T_("Slot empty during LOAD CARTRIDGE")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x84, SENSE_ABORT, T_("Cleaning Tape expired")},
	{ "L500", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x80, 0x85, SENSE_ABORT, T_("Cleaning Failed")},
	{ "L500", "", TYPE_CHANGER,  SENSE_HARDWARE_ERROR,   UCHAR_MAX,   UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x0, 0x0,   SENSE_ABORT, T_("Illegal Request")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x1a, 0x0,  SENSE_ABORT, T_("Parameter length error")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x20, 0x0,  SENSE_ABORT, T_("SCSI invalid opcode")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x21, 0x01, SENSE_ABORT, T_("Invalid element address")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x00, SENSE_ABORT, T_("Invalid CDB")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x81, SENSE_ABORT, T_("Invalid mode on WRITE BUFFER")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x82, SENSE_ABORT, T_("Invalid drive specified")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x83, SENSE_ABORT, T_("SEND DIAG Invalid test number")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x86, SENSE_ABORT, T_("Invalid offset on WRITE BUFFER")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x87, SENSE_ABORT, T_("Invalid size on WRITE BUFFER")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x89, SENSE_ABORT, T_("Image data too large on WRITE BUFFER")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x8b, SENSE_ABORT, T_("Invalid image for CUP")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x8c, SENSE_ABORT, T_("Non-immediate command during CUP")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x8e, SENSE_ABORT, T_("Invalid personality for CUP")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x24, 0x8f, SENSE_ABORT, T_("Bad controller image EDC")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x25, 0x0,  SENSE_ABORT, T_("Invalid LUN")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x26, 0x0,  SENSE_ABORT, T_("Parameter list error: invalid field")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x26, 0x01, SENSE_ABORT, T_("Parameter list error: parameter not supported")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x39, 0x0,  SENSE_ABORT, T_("Saving parameters not supported")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x3a, 0x81, SENSE_ABORT, T_("Cleaning Slot empty")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x3a, 0x82, SENSE_ABORT, T_("Cleaning slot doesn't have a cleaning slot")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x3b, 0x0d, SENSE_ABORT, T_("Destination element full")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x3b, 0x0e, SENSE_ABORT, T_("Source slot or drive empty")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x3d, 0x0,  SENSE_ABORT, T_("SCSI invalid ID message")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x53, 0x0,  SENSE_ABORT, T_("Media Load/Eject failure")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x53, 0x01, SENSE_ABORT, T_("Cartridge failed to unload")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0xf1, 0x0,  SENSE_ABORT, T_("Command unspecified")},
	{ "L500", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0xf1, 0x02, SENSE_ABORT, T_("Unrecognized loader command")},
	{ "L500", "", TYPE_CHANGER,  SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX,    SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "L500", "", TYPE_CHANGER , SENSE_UNIT_ATTENTION, 0x0,  0x0,  SENSE_RETRY, T_("Unit Attention")},
	{ "L500", "", TYPE_CHANGER , SENSE_UNIT_ATTENTION, 0x28, 0x0,  SENSE_RETRY, T_("Not ready to Ready transition")},
	{ "L500", "", TYPE_CHANGER , SENSE_UNIT_ATTENTION, 0x29, 0x0,  SENSE_RETRY, T_("Reset occured")},
	{ "L500", "", TYPE_CHANGER , SENSE_UNIT_ATTENTION, 0x2a, 0x01, SENSE_ABORT, T_("Mode parameters changed")},
	{ "L500", "", TYPE_CHANGER , SENSE_UNIT_ATTENTION, 0x3f, 0x01, SENSE_ABORT, T_("Microcode has changed")},
	{ "L500", "", TYPE_CHANGER,  SENSE_UNIT_ATTENTION, UCHAR_MAX, UCHAR_MAX,     SENSE_ABORT, T_("Default for SENSE_UNIT_ATTENTION")},

/*	Not used by L500
	{ "L500", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},
*/
	{ "L500", "", TYPE_CHANGER,  SENSE_ABORTED_COMMAND, 0x43, 0x0, SENSE_ABORT, T_("SCSI message error")},
	{ "L500", "", TYPE_CHANGER,  SENSE_ABORTED_COMMAND, 0x47, 0x0, SENSE_ABORT, T_("SCSI parity error")},
	{ "L500", "", TYPE_CHANGER,  SENSE_ABORTED_COMMAND, 0x48, 0x0, SENSE_ABORT, T_("SCSI IDE message received")},
	{ "L500", "", TYPE_CHANGER,  SENSE_ABORTED_COMMAND, 0x49, 0x0, SENSE_ABORT, T_("SCSI invalid message")},
	{ "L500", "", TYPE_CHANGER,  SENSE_ABORTED_COMMAND, 0x4e, 0x0, SENSE_ABORT, T_("SCSI overlapped commands")},

	{ "L500", "", TYPE_CHANGER,  SENSE_ABORTED_COMMAND, UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ABORTED_COMMAND")},
	{ "L500", "", TYPE_CHANGER , UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},

/*
 * HP C1553A Tape
 */
	{ "C1553A", "", TYPE_TAPE,  SENSE_NULL, 0x0, 0x0, SENSE_NO, T_("No Sense")},
	{ "C1553A", "", TYPE_TAPE,  SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "C1553A", "", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, T_("Recovered Error")},
	{ "C1553A", "", TYPE_TAPE,  SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_RECOVERED_ERROR")},

	{ "C1553A", "", TYPE_TAPE , SENSE_NOT_READY, 0x0, 0x0, SENSE_IGNORE, T_("Not Ready")},
	{ "C1553A", "", TYPE_TAPE , SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "C1553A", "", TYPE_TAPE,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "C1553A", "", TYPE_TAPE , SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Medium Error")},
	{ "C1553A", "", TYPE_TAPE,  SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_MEDIUM_ERROR")},

	{ "C1553A", "", TYPE_TAPE , SENSE_HARDWARE_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Hardware Error")},
	{ "C1553A", "", TYPE_TAPE,  SENSE_HARDWARE_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{ "C1553A", "", TYPE_TAPE , SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "C1553A", "", TYPE_TAPE,  SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "C1553A", "", TYPE_TAPE , SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "C1553A", "", TYPE_TAPE,  SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "C1553A", "", TYPE_TAPE , UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},

	{ "C1553A", "", TYPE_CHANGER,  SENSE_NULL, 0x0, 0x0, SENSE_NO, T_("No Sense")},
	{ "C1553A", "", TYPE_CHANGER,  SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "C1553A", "", TYPE_CHANGER , SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, T_("Recovered Error")},
	{ "C1553A", "", TYPE_CHANGER,  SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_RECOVERED_ERROR")},

	{ "C1553A", "", TYPE_CHANGER , SENSE_NOT_READY, 0x0, 0x0, SENSE_IGNORE, T_("Not Ready")},
	{ "C1553A", "", TYPE_CHANGER , SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "C1553A", "", TYPE_CHANGER,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "C1553A", "", TYPE_CHANGER , SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Medium Error")},
	{ "C1553A", "", TYPE_CHANGER,  SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_MEDIUM_ERROR")},

	{ "C1553A", "", TYPE_CHANGER , SENSE_HARDWARE_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Hardware Error")},
	{ "C1553A", "", TYPE_CHANGER,  SENSE_HARDWARE_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{ "C1553A", "", TYPE_CHANGER , SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "C1553A", "", TYPE_CHANGER,  SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "C1553A", "", TYPE_CHANGER , SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "C1553A", "", TYPE_CHANGER,  SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "C1553A", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "C1553A", "", TYPE_CHANGER , UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},
/*
 * HP C1537A Tape
 */
	{ "C1537A", "", TYPE_TAPE,  SENSE_NULL, 0x0, 0x0, SENSE_NO, T_("No Sense")},
	{ "C1537A", "", TYPE_TAPE,  SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "C1537A", "", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, T_("Recovered Error")},
	{ "C1537A", "", TYPE_TAPE,  SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_RECOVERED_ERROR")},

	{ "C1537A", "", TYPE_TAPE , SENSE_NOT_READY, 0x0, 0x0, SENSE_IGNORE, T_("Not Ready")},
	{ "C1537A", "", TYPE_TAPE , SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "C1537A", "", TYPE_TAPE , SENSE_NOT_READY, 0x04, 0x0, SENSE_RETRY, T_("tape is being ejected")},
	{ "C1537A", "", TYPE_TAPE , SENSE_NOT_READY, 0x04, 0x01, SENSE_RETRY, T_("tape is being loaded")},
	{ "C1537A", "", TYPE_TAPE,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "C1537A", "", TYPE_TAPE , SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Medium Error")},
	{ "C1537A", "", TYPE_TAPE,  SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_MEDIUM_ERROR")},

	{ "C1537A", "", TYPE_TAPE , SENSE_HARDWARE_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Hardware Error")},
	{ "C1537A", "", TYPE_TAPE,  SENSE_HARDWARE_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{ "C1537A", "", TYPE_TAPE , SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "C1537A", "", TYPE_TAPE,  SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "C1537A", "", TYPE_TAPE , SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "C1537A", "", TYPE_TAPE , SENSE_UNIT_ATTENTION, 0x28, 0x0, SENSE_RETRY, T_("Not Ready to Ready Transition")},
	{ "C1537A", "", TYPE_TAPE,  SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "C1537A", "", TYPE_TAPE,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "C1537A", "", TYPE_TAPE , UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},
/*
 * Tandberg TapeLibrary 1420
 */
	{ "TDS 1420", "", TYPE_TAPE, SENSE_NULL, 0x0, 0x0, SENSE_NO, T_("No Sense")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "TDS 1420", "", TYPE_TAPE, SENSE_IES, 0x83, 0x0, SENSE_IES, T_("IES")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_IES, 0x83, 0x1, SENSE_IES, T_("IES")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_IES, 0x83, 0x4, SENSE_IGNORE, T_("IES")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, T_("Recovered Error")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_RECOVERED_ERROR")},

	{ "TDS 1420", "", TYPE_TAPE, SENSE_NOT_READY, 0x0, 0x0, SENSE_IGNORE, T_("Not Ready")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "TDS 1420", "", TYPE_TAPE, SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Medium Error")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_MEDIUM_ERROR")},

	{ "TDS 1420", "", TYPE_TAPE, SENSE_HARDWARE_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Hardware Error")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_HARDWARE_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{ "TDS 1420", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "TDS 1420", "", TYPE_TAPE, SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "TDS 1420", "", TYPE_TAPE, SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, "Default for SENSE_UNIT_ATTENTION"},

	{ "TDS 1420", "", TYPE_TAPE, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},

/*
 * Tandberg SLR100 Tape Drive
 */

	{ "SLR100", "", TYPE_TAPE,  SENSE_NULL, 0x0, 0x0, SENSE_NO, "No Sense"},
	{ "SLR100", "", TYPE_TAPE, SENSE_NULL ,0x00 ,0x01 , SENSE_ABORT ," FILEMARK_DETECTED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_NULL ,0x00 ,0x02 , SENSE_IGNORE ," END-OF-PARTITION/MEDIUM_DETECTED_ON_WRITE__LEW_PASSED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_NULL ,0x00 ,0x03 , SENSE_ABORT ," SETMARK_DETECTED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_NULL ,0x00 ,0x04 , SENSE_ABORT ," BEGINNING-OF-PARTITION/MEDIUM_DETECTED "},
	{ "SLR100", "", TYPE_TAPE,  SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, "Default for SENSE_NULL"},

	{ "SLR100", "", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, "Recovered Error"},
	{ "SLR100", "", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x00, 0x17, SENSE_IGNORE, "Cleaning Requested"},
	{ "SLR100", "", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x03, 0x02, SENSE_IGNORE, "Excessive Write Errors"},
	{ "SLR100", "", TYPE_TAPE,  SENSE_RECOVERED_ERROR ,0x0C ,0x05 , SENSE_ABORT ," DATA_EXPANSION_OCCURRED_DURING_COMPRESSION "},
	{ "SLR100", "", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x5B, 0x02, SENSE_IGNORE, "Log Counter at Maximum"},
	{ "SLR100", "", TYPE_TAPE,  SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, "Default for SENSE_RECOVERED_ERROR"},

	{ "SLR100", "", TYPE_TAPE , SENSE_NOT_READY, 0x0, 0x0, SENSE_IGNORE, "Not Ready"},
	{ "SLR100", "", TYPE_TAPE, SENSE_NOT_READY ,0x04 ,0x00 , SENSE_ABORT ," LOGICAL_UNIT_NOT_READY_CAUSE_NOT_REPORTABLE "},
	{ "SLR100", "", TYPE_TAPE, SENSE_NOT_READY ,0x04 ,0x01 , SENSE_RETRY ," LOGICAL_UNIT_IS_IN_THE_PROCESS_OF_BECOMMING_READY "},
	{ "SLR100", "", TYPE_TAPE, SENSE_NOT_READY ,0x04 ,0x02 , SENSE_ABORT ," LOGICAL-UNIT_NOT_READY_INITIALIZING_COMMAND_REQUIRED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_NOT_READY ,0x30 ,0x03 , SENSE_ABORT ," CLEANING_CARTRIDGE_INSTALLED "},
	{ "SLR100", "", TYPE_TAPE ,SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, "No Tape online"},
	{ "SLR100", "", TYPE_TAPE, SENSE_NOT_READY ,0x53 ,0x02 , SENSE_ABORT ," MEDIUM_REMOVAL_PREVENTED "},
	{ "SLR100", "", TYPE_TAPE,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, "Default for SENSE_NOT_READY"},

	{ "SLR100", "", TYPE_TAPE ,SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, "Medium Error"},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x00 ,0x02 , SENSE_ABORT ," END-OF-PARTITION/MEDIUM_DETECTED_ON_READ__PHYSICAL_END_REACHED "},
	{ "SLR100", "", TYPE_TAPE ,SENSE_MEDIUM_ERROR, 0x03, 0x02, SENSE_IGNORE, "Excessive Write Errors(SERVO)"},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x09 ,0x00 , SENSE_ABORT ," TRACK_FOLLOWING_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x11 ,0x00 , SENSE_IGNORE ," UNRECOVERED_READ_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x11 ,0x01 , SENSE_IGNORE ," READ_RETRIES_EXHAUSTED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x11 ,0x0D , SENSE_ABORT ," DECOMPRESSION_CRC_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x11 ,0x0E , SENSE_ABORT ," CANNOT_DECOMPRESS_USING_THE_DECLARED_ALGORITHM "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x15 ,0x01 , SENSE_ABORT ," MECHANICAL_POSITIONING_ERROR__ILLEGAL_HEAD_POSITION "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x30 ,0x01 , SENSE_ABORT ," CANNOT_READ_MEDIUM_-_UNKNOWN_FORMAT "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x30 ,0x02 , SENSE_ABORT ," CANNOT_READ_MEDIUM__INCOMPATIBLE_FORMAT "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x30 ,0x07 , SENSE_ABORT ," CLEANING_FAILURE "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x50 ,0x01 , SENSE_IGNORE ," WRITE_APPEND_POSITION_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x51 ,0x00 , SENSE_ABORT ," ERASE_FAILURE "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x52 ,0x00 , SENSE_ABORT ," CARTRIDGE_FAULT__BAD_CARTRIDGE "},
	{ "SLR100", "", TYPE_TAPE, SENSE_MEDIUM_ERROR ,0x52 ,0x00 , SENSE_IGNORE ," CARTRIDGE_FAULT__REFERENCE_BURST_SEEK_FAILURE "},
	{ "SLR100", "", TYPE_TAPE,  SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, "Default for SENSE_MEDIUM_ERROR"},

	{ "SLR100", "", TYPE_TAPE ,SENSE_HARDWARE_ERROR, 0x0, 0x0, SENSE_ABORT, "Hardware Error"},
	{ "SLR100", "", TYPE_TAPE, SENSE_HARDWARE_ERROR ,0x09 ,0x01 , SENSE_ABORT ," TRACKING_SERVO_FAILURE "},
	{ "SLR100", "", TYPE_TAPE, SENSE_HARDWARE_ERROR ,0x40 ,0x80 , SENSE_ABORT ," DIAGNOSTIC_FAILURE__BUFFER_PARITY_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_HARDWARE_ERROR ,0x40 ,0x81 , SENSE_ABORT ," DIAGNOSTIC_FAILURE__WRITE_CHIP_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_HARDWARE_ERROR ,0x40 ,0xA0 , SENSE_ABORT ," DIAGNOSTIC_FAILURE__MULTIPLE_ERRORS "},
	{ "SLR100", "", TYPE_TAPE, SENSE_HARDWARE_ERROR ,0x44 ,0x00 , SENSE_ABORT ," INTERNAL_TARGET_FAILURE "},
	{ "SLR100", "", TYPE_TAPE, SENSE_HARDWARE_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, "Default for SENSE_HARDWARE_ERROR"},

	{ "SLR100", "", TYPE_TAPE ,SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, "Illegal Request"},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x1A ,0x00 , SENSE_ABORT ," PARAMETER_LIST_LENGTH_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x20 ,0x00 , SENSE_ABORT ," INVALID_COMMAND_OPERATION_CODE "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x24 ,0x00 , SENSE_ABORT ," INVALID_FIELD_IN_CDB "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x25 ,0x00 , SENSE_ABORT ," LOGICAL_UNIT_NOT_SUPPORTED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x26 ,0x00 , SENSE_ABORT ," INVALID_FIELD_IN_PARAMETER_LIST "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x2C ,0x00 , SENSE_ABORT ," COMMAND_SEQUENCE_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x30 ,0x00 , SENSE_ABORT ," INCOMPATIBLE_MEDIUM_INSTALLED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x30 ,0x06 , SENSE_ABORT ," CANNOT_FORMAT_MEDIUM__INCOMPATIBLE_MEDIUM "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x3D ,0x00 , SENSE_ABORT ," INVALID_BITS_IN_IDENTIFY_MESSAGE "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x43 ,0x00 , SENSE_ABORT ," MESSAGE_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST ,0x50 ,0x00 , SENSE_ABORT ," WRITE_APPEND_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, "Default for SENSE_ILLEGAL_REQUEST"},

	{ "SLR100", "", TYPE_TAPE ,SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, "Unit Attention"},
	{ "SLR100", "", TYPE_TAPE, SENSE_UNIT_ATTENTION ,0x28 ,0x00 , SENSE_RETRY ," NOT_READY_TO_READY_TRANSITION__MEDIUM_MAY_HAVE_CHANGED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_UNIT_ATTENTION ,0x29 ,0x00 , SENSE_RETRY ," POWER_ON_/_RESET_OCCURRED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_UNIT_ATTENTION ,0x2A ,0x01 , SENSE_RETRY ," MODE_PARAMETERS_CHANGED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_UNIT_ATTENTION ,0x2A ,0x02 , SENSE_RETRY ," LOG_PARAMETERS_CHANGED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_UNIT_ATTENTION ,0x3F ,0x01 , SENSE_RETRY ," MICROCODE_HAS_BEEN_CHANGED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_UNIT_ATTENTION ,0x5B ,0x01 , SENSE_RETRY ," THRESHOLD_CONDITION_MET "},
	{ "SLR100", "", TYPE_TAPE, SENSE_UNIT_ATTENTION ,0x82 ,0x83 , SENSE_RETRY ," CLEANING_CARTRIDGE_EJECTED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_UNIT_ATTENTION, UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, "Default for SENSE_UNIT_ATTENTION"},

	{ "SLR100", "", TYPE_TAPE, SENSE_ABORTED_COMMAND ,0x47 ,0x00 , SENSE_RETRY ," SCSI_PARITY_ERROR "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ABORTED_COMMAND ,0x48 ,0x00 , SENSE_ABORT ," INITIATOR_DETECTED_ERROR_MESSAGE_RECEIVED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ABORTED_COMMAND ,0x4E ,0x00 , SENSE_ABORT ," OVERLAPPED_COMMANDS_ATTEMPTED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_ABORTED_COMMAND ,0x53 ,0x00 , SENSE_ABORT ," MEDIA_LOAD_OR_EJECT_FAILED "},

	{ "SLR100", "", TYPE_TAPE, SENSE_CHG_ELEMENT_STATUS ,0x1D ,0x00 , SENSE_IGNORE ," MISCOMPARE_DURING_VERIFY_OPERATION "},

	{ "SLR100", "", TYPE_TAPE, SENSE_DATA_PROTECT ,0x27 ,0x05 , SENSE_ABORT ," PERMANENT_WRITE_PROTECTED_(CARTRIDGE_END_OF_LIFE) "},
	{ "SLR100", "", TYPE_TAPE, SENSE_DATA_PROTECT ,0x27 ,0x00 , SENSE_RETRY ," WRITE_PROTECTED "},

	{ "SLR100", "", TYPE_TAPE, SENSE_VOLUME_OVERFLOW ,0x00 ,0x02 , SENSE_IGNORE ," END-OF-PARTITION/MEDIUM_DETECTED_ON_WRITE__PHYSICAL_END_REACHED "},

	{ "SLR100", "", TYPE_TAPE, SENSE_BLANK_CHECK ,0x00 ,0x05 , SENSE_ABORT ," END-OF-DATA_DETECTED "},
	{ "SLR100", "", TYPE_TAPE, SENSE_BLANK_CHECK ,0x14 ,0x00 , SENSE_ABORT ," RECORDED_ENTITY_NOT_FOUND "},

	{ "SLR100", "", TYPE_TAPE , UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, "Nothing Found"},

/*
 * DLT 8000 Tape
 */
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_NULL, 0x0, 0x0,   SENSE_NO, T_("No Sense")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_NULL, 0x0, 0x01,  SENSE_NO, T_("Unexpected FM encountered")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_NULL, 0x0, 0x02,  SENSE_NO, T_("EOM encountered")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_NULL, 0x0, 0x04,  SENSE_NO, T_("BOM encountered")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_NULL, 0x5d, 0x00, SENSE_NO, T_("Failure prediction threshold exceeded")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_NULL, 0x27, 0x82, SENSE_NO, T_("Data safety write protect")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_NULL , UCHAR_MAX, UCHAR_MAX,    SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x0, 0x0, SENSE_IGNORE, T_("Recovered Error")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x0, 0x17, SENSE_IGNORE, T_("Cleaning requested")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x0a, 0x00, SENSE_IGNORE, T_("Error log overflow")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x0a, 0x80, SENSE_IGNORE, T_("Error log generated")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x37, 0x0,  SENSE_IGNORE, T_("Rounded parameter")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x38, 0x08, SENSE_IGNORE, T_("repositioning error")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x44, 0xc1, SENSE_IGNORE, T_("EEPROM copy1 area bad")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x44, 0xc2, SENSE_IGNORE, T_("EEPROM copy2 area bad")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x47, 0x00, SENSE_IGNORE, T_("SCSI parity error")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x48, 0x00, SENSE_IGNORE, T_("IDE Message received")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x51, 0x00, SENSE_IGNORE, T_("Erase Failure")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x53, 0x01, SENSE_IGNORE, T_("Unload Tape failure")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x5b, 0x01, SENSE_IGNORE, T_("Threshold met")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x5b, 0x02, SENSE_IGNORE, T_("Log counter at maximum")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x80, 0x02, SENSE_IGNORE, T_("Cleaning requested")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x80, 0x03, SENSE_IGNORE, T_("Soft error exceeds threshold")},
/*	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_RECOVERED_ERROR, 0x47, 0x0, SENSE_IGNORE, T_("Scsi Parity Error")}, */
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_RECOVERED_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_RECOVERED_ERROR")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_NOT_READY, 0x0, 0x0, SENSE_IGNORE, T_("Not Ready (this shouldn't happen should it?)")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_NOT_READY, 0x4, 0x1, SENSE_RETRY, T_("The drive is not ready, but it is in the process of becoming ready")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_NOT_READY, 0x30,0x02, SENSE_ABORT, T_("Incompatible tape format")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_NOT_READY, 0x30,0x03, SENSE_ABORT, T_("Cleaning Cartridge in drive")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_NOT_READY, 0x5a,0x01, SENSE_ABORT, T_("Asynchronous eject occurred")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_MEDIUM_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Medium Error")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_MEDIUM_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_MEDIUM_ERROR")},

	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_HARDWARE_ERROR, 0x0, 0x0, SENSE_ABORT, T_("Hardware Error")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_HARDWARE_ERROR , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE , SENSE_UNIT_ATTENTION, 0x28, 0x0, SENSE_RETRY, T_("Not ready to ready transition")},
	{ "DLT8000", "QUANTUM", TYPE_TAPE,  SENSE_UNIT_ATTENTION, UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "DLT8000", "QUANTUM", TYPE_TAPE , UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},

/*
 * DLT 7000 Tape
 */
	{ "DLT7000", "", TYPE_TAPE, SENSE_NOT_READY, 0x4, 0x0, SENSE_RETRY, T_("Logical Unit not ready, no additional sense")},
	{ "DLT7000", "", TYPE_TAPE, SENSE_NOT_READY, 0x4, 0x2, SENSE_TAPE_NOT_ONLINE, T_("Logical Unit not ready, in progress becoming ready")},
	{ "DLT7000", "", TYPE_TAPE, SENSE_NOT_READY, 0x30, 0x3, SENSE_RETRY, T_("The tape drive is being cleaned")},
	{ "DLT7000", "", TYPE_TAPE, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "DLT7000", "", TYPE_TAPE, SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "DLT7000", "", TYPE_TAPE, SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "DLT7000", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "DLT7000", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "DLT7000", "", TYPE_TAPE, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},
/*
 * DLT 4000 Tape
 */
	{ "DLT4000", "", TYPE_TAPE, SENSE_NOT_READY, 0x4, 0x0, SENSE_RETRY, T_("Logical Unit not ready, no additional sense")},
	{ "DLT4000", "", TYPE_TAPE, SENSE_NOT_READY, 0x4, 0x2, SENSE_TAPE_NOT_ONLINE, T_("Logical Unit not ready, in progress becoming ready")},
	{ "DLT4000", "", TYPE_TAPE, SENSE_NOT_READY, 0x30, 0x3, SENSE_RETRY, T_("The tape drive is being cleaned")},
	{ "DLT4000", "", TYPE_TAPE,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "DLT4000", "", TYPE_TAPE, SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "DLT4000", "", TYPE_TAPE, SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "DLT4000", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "DLT4000", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "DLT4000", "", TYPE_TAPE, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},
/*
 * AIT VLS DLT Library
 */
	{ "VLS_DLT", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x0, SENSE_RETRY, T_("Logical Unit not ready, no additional sense")},
	{ "VLS_DLT", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x2, SENSE_TAPE_NOT_ONLINE, T_("Logical Unit not ready, in progress becoming ready")},
	{ "VLS_DLT", "", TYPE_CHANGER, SENSE_NOT_READY, 0x30, 0x3, SENSE_RETRY, T_("The tape drive is being cleaned")},
	{ "VLS_DLT", "", TYPE_CHANGER, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "VLS_DLT", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "VLS_DLT", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "VLS_DLT", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "VLS_DLT", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "VLS_DLT", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "VLS_DLT", "", TYPE_CHANGER, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},
/*
 * AIT VLS SDX Library
 */
	{ "VLS_SDX", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x0, SENSE_RETRY, T_("Logical Unit not ready, no additional sense")},
	{ "VLS_SDX", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x2, SENSE_TAPE_NOT_ONLINE, T_("Logical Unit not ready, in progress becoming ready")},
	{ "VLS_SDX", "", TYPE_CHANGER, SENSE_NOT_READY, 0x30, 0x3, SENSE_RETRY, T_("The tape drive is being cleaned")},
	{ "VLS_SDX", "", TYPE_CHANGER, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "VLS_SDX", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "VLS_SDX", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "VLS_SDX", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "VLS_SDX", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "VLS_SDX", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "VLS_SDX", "", TYPE_CHANGER, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},
/*
 * Exabyte 85058 Tape
 */
	{ "EXB-85058HE-0000", "", TYPE_TAPE, SENSE_NOT_READY, 0x4, 0x0, SENSE_RETRY, T_("Logical Unit not ready, no additional sense")},
	{ "EXB-85058HE-0000", "", TYPE_TAPE, SENSE_NOT_READY, 0x4, 0x1, SENSE_RETRY, T_("Logical Unit not ready, in progress becoming ready")},
	{ "EXB-85058HE-0000", "", TYPE_TAPE, SENSE_NOT_READY, 0x30, 0x3, SENSE_RETRY, T_("The tape drive is being cleaned")},
	{ "EXB-85058HE-0000", "", TYPE_TAPE, SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "EXB-85058HE-0000", "", TYPE_TAPE,  SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "EXB-85058HE-0000", "", TYPE_TAPE, SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "EXB-85058HE-0000", "", TYPE_TAPE, SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "EXB-85058HE-0000", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "EXB-85058HE-0000", "", TYPE_TAPE, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},
	{ "EXB-85058HE-0000", "", TYPE_TAPE, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found")},
/*
 * Exabyte 10e Library (Robot)
 */
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NULL, 0x0, 0x0, SENSE_RETRY, T_("Retry, no sense")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NULL, 0x90, 0x2, SENSE_ABORT, T_("Illegal Request")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NULL , 0x90, 0x3, SENSE_IES, T_("IES")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x0, SENSE_RETRY, T_("Logical Unit not ready, no additional sense")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x1, SENSE_RETRY, T_("Logical Unit not ready, in progress becoming ready")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x85, SENSE_ABORT, T_("Library door is open")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x85, SENSE_ABORT, T_("The data cartridge magazine is missing")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x89, SENSE_ABORT, T_("The library is in CHS Monitor mode")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x8C, SENSE_RETRY, T_("The library is performing a power-on self test")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x8D, SENSE_ABORT, T_("The library is in LCD mode")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x8E, SENSE_ABORT, T_("The library is in Sequential mode")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x30, 0x3, SENSE_RETRY, T_("The tape drive is being cleaned")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "EXB-10e", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "EXB-10e", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x91, 0x0, SENSE_CHM_FULL, T_("CHM full during reset")},
	{ "EXB-10e", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "EXB-10e", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "EXB-10e", "", TYPE_CHANGER, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found for EXB-10e")},

/*
 * Exabyte 210 Library (Robot)
 */
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NULL, 0x0, 0x0, SENSE_RETRY, T_("Retry, no sense")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NULL, 0x90, 0x2, SENSE_ABORT, T_("Illegal Request")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NULL , 0x90, 0x3, SENSE_IES, T_("IES")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x0, SENSE_RETRY, T_("Logical Unit not ready, no additional sense")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x1, SENSE_RETRY, T_("Logical Unit not ready, in progress becoming ready")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x85, SENSE_ABORT, T_("Library door is open")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x85, SENSE_ABORT, T_("The data cartridge magazine is missing")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x89, SENSE_ABORT, T_("The library is in CHS Monitor mode")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x8C, SENSE_RETRY, T_("The library is performing a power-on self test")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x8D, SENSE_ABORT, T_("The library is in LCD mode")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x8E, SENSE_ABORT, T_("The library is in Sequential mode")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x30, 0x3, SENSE_RETRY, T_("The tape drive is being cleaned")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "EXB-210", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x91, 0x0, SENSE_CHM_FULL, T_("CHM full during reset")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x21, 0x01, SENSE_ABORT, T_("Invalid element address")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x24, 0x00, SENSE_ABORT, T_("Invalid Invert Field")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x3b, 0x0d, SENSE_ABORT, T_("Destination element occupied")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x3b, 0x0e, SENSE_ABORT, T_("Source Element empty")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x3b, 0x87, SENSE_ABORT, T_("Cartridge stuck in tape")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x3b, 0x90, SENSE_ABORT, T_("Source cart is loaded inside the tape drive and not accessible")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x80, 0x03, SENSE_ABORT, T_("Source magazine not installed")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x80, 0x04, SENSE_ABORT, T_("Destination magazine no installed")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x80, 0x05, SENSE_ABORT, T_("Source tape drive not installed")},
	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x80, 0x06, SENSE_ABORT, T_("Destination tape drive not installed")},

	{ "EXB-210", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, 0x83, 0x0, SENSE_IES, T_("Label questionable")},
	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, 0x83, 0x1, SENSE_IGNORE, T_("Cannot read bar code label")},
	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, 0x83, 0x2, SENSE_ABORT, T_("Cartzridge magazine not present")},
	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, 0x83, 0x3, SENSE_IES, T_("Label and full status questionable")},
       	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, 0x83, 0x4, SENSE_ABORT, T_("Tape drive not installed")},
	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, 0x83, 0x7, SENSE_IES, T_("Full status questionable")},
	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, 0x83, 0x8, SENSE_IGNORE, T_("Bar code label upside down")},
	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, 0x83, 0x9, SENSE_IGNORE, T_("No bar code label")},
	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, 0x83, 0xa, SENSE_IGNORE, T_("Ignore")},
	{ "EXB-210", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "EXB-210", "", TYPE_CHANGER, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found for EXB-10e")},

/*
 * Exabyte 230D Library (Robot)
 */
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NULL, 0x0, 0x0, SENSE_RETRY, T_("Retry, no sense")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NULL, 0x90, 0x2, SENSE_ABORT, T_("Illegal Request")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NULL , 0x90, 0x3, SENSE_IES, T_("IES")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NULL , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NULL")},

	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x0, SENSE_RETRY, T_("Logical Unit not ready, no additional sense")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x1, SENSE_RETRY, T_("Logical Unit not ready, in progress becoming ready")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x85, SENSE_ABORT, T_("Library door is open")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x85, SENSE_ABORT, T_("The data cartridge magazine is missing")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x89, SENSE_ABORT, T_("The library is in CHS Monitor mode")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x8C, SENSE_RETRY, T_("The library is performing a power-on self test")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x8D, SENSE_ABORT, T_("The library is in LCD mode")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x8E, SENSE_ABORT, T_("The library is in Sequential mode")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x30, 0x3, SENSE_RETRY, T_("The tape drive is being cleaned")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY, 0x3A, 0x0, SENSE_TAPE_NOT_ONLINE, T_("No Tape online")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_NOT_READY , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "EXB-230D", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION, 0x0, 0x0, SENSE_RETRY, T_("Unit Attention")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_UNIT_ATTENTION , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_UNIT_ATTENTION")},

	{ "EXB-230D", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x0, 0x0, SENSE_ABORT, T_("Illegal Request")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x91, 0x0, SENSE_CHM_FULL, T_("CHM full during reset")},
	{ "EXB-230D", "", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST , UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{ "EXB-230D", "", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "EXB-230D", "", TYPE_CHANGER, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing Found for EXB-10e")},
/*
 * Spectra TreeFrog  library
 */
 	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_NULL, 0x0, 0x0, SENSE_NO, T_("No Sense, Unit Ready")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_NULL, UCHAR_MAX, UCHAR_MAX, SENSE_NO, T_("No Sense, Unit Ready")},

	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x0, SENSE_RETRY, T_("Unit Not Ready")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x1, SENSE_RETRY, T_("Unit is Becoming Ready")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_NOT_READY, 0x4, 0x83, SENSE_ABORT, T_("Door is open, Robot is Disabled")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_NOT_READY, UCHAR_MAX, UCHAR_MAX, SENSE_RETRY, T_("Default for SENSE_NOT_READY")},

	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x4C, 0x0, SENSE_ABORT, T_("Unit Failed Initialization")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x84, 0x4, SENSE_ABORT, T_("DRAM Memory Failure")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x84, 0x4, SENSE_ABORT, T_("Two ore More SCSI ID's in the library are tehe same")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x81, 0x4, SENSE_ABORT, T_("Tape may be broken;of tape is a cleaning tape;or Drive B is broken")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x87, 0x0, SENSE_ABORT, T_("Bad FPROM or invalid device in socket")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x87, 0x1, SENSE_ABORT, T_("FPROM Erase Operation Failed")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x87, 0x2, SENSE_ABORT, T_("FFPROM Write Operation Failed")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x85, 0x1, SENSE_ABORT, T_("Robot not Initialized")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x85, 0x99, SENSE_ABORT, T_("Generic Robotics  Error")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x85, 0x2, SENSE_ABORT, T_("Long Axis Robotics Error")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x85, 0x3, SENSE_ABORT, T_("Short Axis Robotics Error")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, 0x85, 0x4, SENSE_ABORT, T_("Ambient Light Detected")},
	{ "215", "SPECTRA", TYPE_CHANGER, SENSE_HARDWARE_ERROR, UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_HARDWARE_ERROR")},

	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x1A, 0x0, SENSE_ABORT, T_("Parameter List Length Error")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x20, 0x0, SENSE_ABORT, T_("Invalid Command Code")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x21, 0x01, SENSE_ABORT, T_("Invalid Element Address")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x24, 0x0, SENSE_ABORT, T_("Invalid Field in CDB")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x25, 0x0, SENSE_ABORT, T_("LUN Not Supported")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x26, 0x0, SENSE_ABORT, T_("Invalid Parameter Field")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x3b, 0xd, SENSE_ABORT, T_("Medium Destination is full")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x3b, 0xe, SENSE_ABORT, T_("Medium Source Element is Full")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x3d, 0x80, SENSE_ABORT, T_("Disconnects Must be Allowed")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x80, 0x18, SENSE_ABORT, T_("Conflict, Element is Reserved")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x81, 0x2, SENSE_ABORT, T_("Library is Full of Tapes")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, 0x81, 0x3, SENSE_ABORT, T_("Grip Arm not Empty")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_ILLEGAL_REQUEST, UCHAR_MAX , UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_ILLEGAL_REQUEST")},

	{"215", "SPECTRA", TYPE_CHANGER, SENSE_UNIT_ATTENTION, 0x28, 0x0, SENSE_IES, T_("Inventory possible Altered")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_UNIT_ATTENTION, 0x29, 0x0, SENSE_RETRY, T_("A Reset Has Occured")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_UNIT_ATTENTION, 0x24, 0x1, SENSE_IGNORE, T_("Mode Parameter Have CHanged")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_UNIT_ATTENTION, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_UNIT_ATTENTION")},

	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC, 0x83, 0x00, SENSE_ABORT, T_("Barcode Label is Unread")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC, 0x83, 0x01, SENSE_ABORT, T_("Problem Reading Barcode")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC, 0x83, 0x11, SENSE_ABORT, T_("Tape in Drive & Unmounted")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC, 0x84, 0x00, SENSE_ABORT, T_("Unsupported SCSI Command")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC, 0x84, 0x01, SENSE_ABORT, T_("No Response from SCSI Target")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC, 0x84, 0x02, SENSE_ABORT, T_("Check Condition form Target")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC, 0x84, 0x03, SENSE_ABORT, T_("SCSI ID Same as Library's ID")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC, 0x84, 0x08,  SENSE_ABORT, T_("Busy Condition from Target")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC, 0x84, 0x18, SENSE_ABORT, T_("SCSI Reservation Conflict")},
	{"215", "SPECTRA", TYPE_CHANGER, SENSE_VENDOR_SPECIFIC,  UCHAR_MAX, UCHAR_MAX, SENSE_ABORT, T_("Default for SENSE_VENDOR_SPECIFIC")},

	{ "215", "SPECTRA", TYPE_CHANGER,  SENSE_CHG_ELEMENT_STATUS, UCHAR_MAX, UCHAR_MAX, SENSE_IGNORE, T_("Default for SENSE_CHG_ELEMENT_STATUS")},

	{ "215", "SPECTRA", TYPE_CHANGER, UCHAR_MAX, 0x0, 0x0, SENSE_ABORT, T_("Nothing found for Spectra/215")},

	{ NULL, "", 0x0, UCHAR_MAX, 0x0, 0x0, 0x0, ""},

	};


void
DumpSense(void)
{
	SenseType_T *pwork = (SenseType_T *)&SenseType;

	while (pwork->ident != NULL)
	{
		if (pwork->sense == UCHAR_MAX)
		{
			g_printf("\n");
		} else {
			g_printf(_("%s %s %02X %02X %02X %d %s\n"),pwork->ident, pwork->vendor,
				pwork->sense,
				pwork->asc,
				pwork->ascq,
				pwork->ret,
				_(pwork->text));
		}
		pwork++;
	}
}

/*
 * Decode the Sense Key,ASC, ASCQ and device type, and return an action Type.
 *	type describes the device type as returned by the inquiry command
 *	ignsense changes the way the ASC/ASCQ values are handled.
 *	 if = 0 the sense key is also used for decoding,
 *	 if > 0 the sense key is ignored in the search, and only ASC/ASCQ will be checked
 *	sense is the sense key returned by the scsi command
 *	ASC is the ASC value returned by the scsi command
 *	ASCQ is the ASCQ value returned by the scsi command
 *	text is a pointer to store the clear text reason from the table.
 *
 *	TODO:
 *
*/
int
Sense2Action(
    char *		ident,
    unsigned char	type,
    unsigned char	ignsense,
    unsigned char	sense,
    unsigned char	asc,
    unsigned char	ascq,
    char **		text)
{
	/*
	 * Decode the combination of sense key, ASC, ASCQ and return what to do with this
	 * status
	 * A future extension could be to call direct a function which handles this case
	 *
	 */
	SenseType_T *pwork = (SenseType_T *)&SenseType;
	SenseType_T *generic = NULL;
        int in = 0;

	dbprintf(_("Sense2Action START : type(%d), ignsense(%d), sense(%02X), asc(%02X), ascq(%02X)\n"),
		type,
		ignsense,
		sense,
		asc,
		ascq);

	while (pwork->ident != NULL)
	{
		if (strcmp(pwork->ident, "generic") == 0 && pwork->type == type && generic == NULL)
		{
			generic = pwork;
		}

		if (strcmp((char *)pwork->ident, (char *)ident) == 0 && pwork->type == type)
                {
			in = 1;
                } else {
			if (in == 1)
			{
				dbprintf(_("Sense2Action       : no match\n"));
				break;
			}
			pwork++;
			continue;
		}

		if (in == 1)
		{
			/* End of definitions for this device */
			if (pwork->sense == UCHAR_MAX)
			{
				*text = stralloc(pwork->text);
				dbprintf(_("Sense2Action   END : no match for %s %s\n"),
					pwork->ident,
					pwork->vendor);
				return(pwork->ret);
			}

			if (ignsense)
			{
				if (pwork->asc ==  asc && pwork->ascq == ascq)
				{
					*text = stralloc(pwork->text);
					dbprintf(_("Sense2Action END(IGN) : match for %s %s  return -> %d/%s\n"),
						pwork->ident,
						pwork->vendor,
						pwork->ret,
						_(*text));
					return(pwork->ret);
				}
				pwork++;
				continue;
			}

			if (pwork->sense == sense)
			{
				/* Matching ASC/ASCQ, if yes return the defined result code */
				if (pwork->asc ==  asc && pwork->ascq == ascq)
				{
					*text = (char *)stralloc(pwork->text);
					dbprintf(_("Sense2Action   END : match for %s %s  return -> %d/%s\n"),
						pwork->ident,
						pwork->vendor,
						pwork->ret,
						_(*text));
					return(pwork->ret);
				}

				/* End of definitions for this sense type, if yes return the default
				 * for this type
				 */
				if ( 	pwork->asc == UCHAR_MAX && pwork->ascq == UCHAR_MAX)
				{
					*text = (char *)stralloc(pwork->text);
					dbprintf(_("Sense2Action   END : no match for %s %s  return -> %d/%s\n"),
						pwork->ident,
						pwork->vendor,
						pwork->ret,
						_(*text));
					return(pwork->ret);
				}
			}
		}
		pwork++;
	}

	/*
	 * Ok no match found, so lets return the values from the generic table
	 */
	dbprintf(_("Sense2Action generic start :\n"));
	while (generic != NULL) {
		if (generic->ident == NULL)
		   break;

		if (generic->sense == UCHAR_MAX)
		{
			*text = (char *)stralloc(generic->text);
			dbprintf(_("Sense2Action generic END : match for %s %s  return -> %d/%s\n"),
				generic->ident,
				generic->vendor,
				generic->ret,
				_(*text));
			return(generic->ret);
		}

		if (ignsense)
		{
			if (generic->asc ==  asc && generic->ascq == ascq)
			{
				*text = (char *)stralloc(generic->text);
				dbprintf(_("Sense2Action generic END(IGN) : match for %s %s  return -> %d/%s\n"),
					generic->ident,
					generic->vendor,
					generic->ret,
					_(*text));
				return(generic->ret);
			}
			generic++;
			continue;
		}

		if (generic->sense == sense)
		{
			/* Matching ASC/ASCQ, if yes return the defined result code */
			if (generic->asc ==  asc && generic->ascq == ascq)
			{
				*text = (char *)stralloc(generic->text);
				dbprintf(_("Sense2Action generic END : match for %s %s  return -> %d/%s\n"),
					generic->ident,
					generic->vendor,
					generic->ret,
					_(*text));
				return(generic->ret);
			}

			/* End of definitions for this sense type, if yes return the default
			 * for this type
			 */
			if ( 	generic->asc == UCHAR_MAX && generic->ascq == UCHAR_MAX)
			{
				*text = (char *)stralloc(generic->text);
				dbprintf(_("Sense2Action generic END : no match for %s %s  return -> %d/%s\n"),
					generic->ident,
					generic->vendor,
					generic->ret,
					_(*text));
				return(generic->ret);
			}
			generic++;
			continue;
		}
		generic++;
	}

	dbprintf(_("Sense2Action END:\n"));
	*text = (char *)stralloc("No match found");
	return(SENSE_ABORT);
}
