//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_EDITING_MANIPULATIONS_MOSAICOPTIONSDIALOG_H
#define GUI_EDITING_MANIPULATIONS_MOSAICOPTIONSDIALOG_H

//--------------------
//forward declarations
class MosaicOptions;
class QComboBox;
class QSpinBox;
class QLabel;
class QRadioButton;
class QLineEdit;
class ClickableLabel;
//--------------------

#include <qdialog.h>
#include <qsize.h>

//=====================================
/*! \brief Interface for choosing mosiac effect options. */
//=====================================

class MosaicOptionsDialog : public QDialog
{
Q_OBJECT

public:
  ///Constructs layout
  MosaicOptionsDialog(QWidget *parent=0);

  ///returns a populate options object
  MosaicOptions* getOptions();

private:
  QSize determineTileSize();
  QStringList determineFilesList();
  void appendImagesInPath(QStringList& files, QString path, int depth);

  QLabel* tileSizePreview;
  QComboBox* tileSizes;
  QSpinBox* tileWidth;
  QLabel*    tileSizeX;
  QSpinBox* tileHeight;

  QRadioButton* tileType_albumPhotos;
  QRadioButton* tileType_solidColors;
  QRadioButton* tileType_imagesFrom;
  QLineEdit* locationVal;
  ClickableLabel* browseButton;
    
private slots:
  void updateTileSizePreview();
  void updateImagesFromOptions();
  void browse();

};
//======================

#endif //GUI_EDITING_MANIPULATIONS_MOSAICOPTIONSDIALOG_H
