//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qstring.h>

//Projectwide includes
#include "setting.h"

//==============================================
Setting::Setting(QString key, QString value)
{
    this->key = key;
    this->value = value;
    this->defaultValue = value;
    next = NULL;
}
//==============================================
QString Setting::getKey()
{
  return key;
}
//==============================================
QString Setting::getValue()
{
  return value;
}
//==============================================
void Setting::setValue(QString value)
{
  this->value = value;
}
//==============================================
Setting* Setting::getNext()
{
  return next;
}
//==============================================
void Setting::setNext( Setting* next )
{
  this->next = next;
}
//==============================================
void Setting::resetSetting()
{
  this->value = this->defaultValue;
}
//==============================================

