from threading import Thread
import gst

import gtk
import time

class VolumeFade(Thread):
	def __init__(self, InitialVolume, FinalVolume, Duration, Button,
				 RepeatTime, PlayerInstance):

		Thread.__init__(self)

		self.setDaemon(True)
		self.InitialVolume = InitialVolume
		self.FinalVolume = FinalVolume * 10
		self.PlayerInstance = PlayerInstance
		self.TimeSecond = Duration * 10
		self.Button = Button
		self.Bus = self.PlayerInstance.get_bus()
		self.Bus.add_signal_watch()
		self.Bus.connect('message', self.FadeMessage)

		self.TimeFormat = gst.Format(gst.FORMAT_TIME)
		self.count = 0
		self.RepeatTime = RepeatTime
		self.IsRepeatingNow = False

		if InitialVolume > FinalVolume:
			self.FadeDirection = 0
			self.FadeSpacing = InitialVolume - FinalVolume
		else:
			self.FadeDirection = 1
			self.FadeSpacing = FinalVolume - InitialVolume

		self.change = self.FadeSpacing / self.TimeSecond / 1000

		FadeStopped = False


	def run(self):
		self.volume_current = self.InitialVolume / 100
		self.PlayerInstance.set_property("volume", self.volume_current)
		self.PlayerInstance.set_state(gst.STATE_PLAYING)

		while True:
			if self.PlayerInstance.get_state()[1] == gst.STATE_PAUSED or \
				self.PlayerInstance.get_state()[2] == gst.STATE_PAUSED:


				self.PlayerInstance.seek_simple(self.TimeFormat, gst.SEEK_FLAG_FLUSH, 0)
				self.PlayerInstance.set_property("volume", self.volume_current)

			self.PlayerInstance.set_state(gst.STATE_PLAYING)



			if not self.IsRepeatingNow:
				if self.FadeDirection == 0:
					self.volume_current = self.volume_current - self.change
				if self.FadeDirection == 1:
					self.volume_current = self.volume_current + self.change
				self.PlayerInstance.set_property("volume", self.volume_current)
			self.count = self.count + 1

			time.sleep(0.01)

			if self.PlayerInstance.get_state()[1] == gst.STATE_NULL:
				break



			if self.count >= self.TimeSecond * 10:
				if not self.IsRepeatingNow:
					self.count = 0
					self.TimeSecond = self.RepeatTime * 10
					self.IsRepeatingNow = True
					continue
				else:
					self.PlayerInstance.set_state(gst.STATE_NULL)
					break

		self.PlayerInstance.set_property("volume", 0)
		self.PlayerInstance.set_state(gst.STATE_NULL)
		self.volume_current = 0
		self.count = 0



		gtk.gdk.threads_enter()
		self.Button.set_sensitive(False)
		gtk.gdk.threads_leave()



	def FadeMessage(self, Bus, Message):
		if Message.type == gst.MESSAGE_EOS:
			self.PlayerInstance.set_state(gst.STATE_PAUSED)
			self.PlayerInstance.seek_simple(self.TimeFormat, gst.SEEK_FLAG_FLUSH, 0)
			self.PlayerInstance.set_property("volume", self.volume_current)
			self.PlayerInstance.set_state(gst.STATE_PLAYING)


