unsigned char	encode_7[]= {
	0x21, 0x22, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
	0x2a, 0x2b, 0x2c, 0x2d, 0x2f, 0x30, 0x31, 0x32,
	0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a,
	0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42,
	0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
	0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52,
	0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a,
	0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x61, 0x62, 0x63,
	0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b,
	0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73,
	0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b,
	0x7c, 0x7d, 0x7e,

	0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90,
	0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x99,
	0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f, 0xe0, 0xe1,
	0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9,
	0,0,0,0,0
};

unsigned char	fstchar_7[]= {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x00, 0x01, 0xff, 0x02, 0x03, 0x04, 0x05,
	0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0xff, 0x0c,
	0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14,
	0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c,
	0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
	0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c,
	0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34,
	0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
	0xff, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43,
	0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b,
	0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
	0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0xff
};

unsigned int
encline_7( str, ptr, len )
unsigned char	*str, *ptr;
unsigned int	len;
{
	unsigned int	i;
	static unsigned char	sftmap[]= { 0, 5, 2, 7, 4, 1, 6, 3 };
	len+= (int)ptr;
	*str++= encode_7[   *ptr                    & 0x3f];
	*str++= encode_7[ ((*ptr  >>6)|(ptr[1]<<2)) & 0x3f];
	*str++= encode_7[ ((ptr[1]>>4)|(ptr[2]<<4)) & 0x3f];
	*str++= encode_7[  (ptr[2]>>2)              & 0x3f];
	for( i= 0, ptr+= 2 ; (int)ptr < len ; i++ ){
		unsigned int	code, bit;
		if( !(bit= sftmap[i&7]) )
			ptr++;
		code =  *ptr++ >> bit;
		code |= *ptr   << (8-bit);
		if( bit > 3 )
			code |= *++ptr << (16-bit);
		code &= 0x1fff;
		*str++= encode_7[(code/91)&0x7f];
		*str++= encode_7[(code%91)&0x7f];
	}
	*str= '\0';
}

unsigned int
decline_7( buf, ptr, len )
unsigned char	*buf, *ptr;
unsigned int	len;
{
	unsigned int	i, c0, c1, c2, c3;
	unsigned char	*str= buf;
	static unsigned char	sftmap[]= { 0, 3, 6, 1, 4, 7, 2, 5 };

	if( len< 4 ||
		(c0= fstchar_7[*ptr++]) == 0xff ||
		(c1= fstchar_7[*ptr++]) == 0xff ||
		(c2= fstchar_7[*ptr++]) == 0xff ||
		(c3= fstchar_7[*ptr++]) == 0xff )
		return	0;
	*str++= (c1<<6)| c0;
	*str++= (c2<<4)|(c1>>2);
	*str  = (c3<<2)|(c2>>4);

	for( i= 0, len= (len-4)/2 ; i< len ; i++ ){
		unsigned int	code;
		if( (c0= fstchar_7[*ptr++]) != 0xff &&
			(c1= fstchar_7[*ptr++]) != 0xff &&
				(code= c0*91+c1) < 0x4000 ){
			unsigned int	bit;
			if( bit= sftmap[i&7] )
				*str |= code << (8-bit);
			*++str= code >> bit;
			if( bit < 5 )
				*++str= code >> (8+bit);
		}else
			return	0;
	}
	return	str-buf;
}
