// ---------------------------------------------------------------------------
// - Rsparse.hpp                                                             -
// - afnix:mth module - real sparse object definitions                       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_RSPARSE_HPP
#define  AFNIX_RSPARSE_HPP

#ifndef  AFNIX_RSI_HPP
#include "Rsi.hpp"
#endif
 
namespace afnix {

  /// This Rsparse class is the default implementation of the real sparse
  /// interface. The sparsity implementation is defined by an array of 
  /// indexes and an array of values. If the array of indexes is nil, the
  /// array of values spans the entire sparse size.
  /// @author amaury darsch

  class Rsparse : public Rsi {
  private:
    /// the sparsity length
    t_long  d_slen;
    /// the sparse indexes
    t_long* p_sidx;
    /// the sparse values
    t_real* p_sval;

  public:
    /// create a null sparse object
    Rsparse (void);

    /// create a sparse object by size
    /// @param size the sparse size
    Rsparse (const t_long size);

    /// create a sparse object by size
    /// @param size the sparse size
    /// @param fflg the full sparse flag 
    Rsparse (const t_long size, const bool fflg);

    /// copy construct this sparse object
    /// @param that the object to copy
    Rsparse (const Rsparse& that);

    /// destroy this sparse object
    ~Rsparse (void);

    /// @return the class name
    String repr (void) const;

    /// @return a clone of this object
    Object* clone (void) const;

    /// assign a sparse object to this one
    /// @param that the object to assign
    Rsparse& operator = (const Rsparse& that);

    /// @return the sparse object length
    t_long length (void) const;

    /// get a sparse index by position
    /// @param pos the position index
    t_long getidx (const t_long pos) const;

    /// get a sparse value by position
    /// @param pos the position index
    t_real getval (const t_long pos) const;

    /// set a sparse object by index and value
    /// @param sidx the sparse index to set
    /// @param sval the sparse value to set
    /// @return the sparse position
    t_long set (const t_long sidx, const t_real sval);

  public:
    /// create a new object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);
  };
}

#endif
