# ---------------------------------------------------------------------------
# - apx-utils                                                               -
# - afnix:apx utilities module                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# ---------------------------------------------------------------------------
# - private section                                                         -
# ---------------------------------------------------------------------------

# the xml table definition
const AFNIX:APX:XML-TBLK-NAME "table"
const AFNIX:APX:XML-TROW-NAME "tr"
const AFNIX:APX:XML-TDHD-NAME "th"
const AFNIX:APX:XML-TCOL-NAME "td"

# ---------------------------------------------------------------------------
# - select section                                                          -
# ---------------------------------------------------------------------------

# select the child node by name
# @param node the roo node to use
# @param name the tag name selector

const afnix:apx:select-children-by-name (node name) {
  # create a xne condition by name
  const xcnd (afnix:xml:XneCond)
  # add a condition by name
  xcnd:add afnix:xml:Xne:NAME name
  # create a tree with the node
  const tree (afnix:xml:XneTree node)
  # select the children nodes that matches the name
  tree:select xcnd false
}

# ---------------------------------------------------------------------------
# - format section                                                          -
# ---------------------------------------------------------------------------

# convert a print table into a xml table
# @param ptbl the print table to convert
# @param ns   the target namespace

const afnix:apx:print-table-to-xml (ptbl ns) {
  # make sure we have a print table
  assert true (afnix:print-table-p ptbl)
  # create a table tag
  const tbl (afnix:xml:XmlTag AFNIX:APX:XML-TBLK-NAME)
  # get the number of row and columns
  const rows (ptbl:get-rows)
  const cols (ptbl:get-columns)
  # add eventually the header
  if (ptbl:head-p) {
    # create a row element
    trans tr (afnix:xml:XmlTag AFNIX:APX:XML-TROW-NAME)
    # loop in the head
    loop (trans cn 0) (< cn cols) (cn:++) {
      # get the head element
      trans xval (ptbl:get-head cn)
      # create a new head element
      trans td (afnix:xml:XmlTag AFNIX:APX:XML-TDHD-NAME)
      td:parse xval
      # add the data in the row
      tr:add-child td
    }
    # add the row in the table
    tbl:add-child tr
  }
  # loop in the table
  loop (trans rn 0) (< rn rows) (rn:++) {
    # create a row element
    trans tr (afnix:xml:XmlTag AFNIX:APX:XML-TROW-NAME)
    # loop in the row
    loop (trans cn 0) (< cn cols) (cn:++) {
      # get the table element
      trans xval (ptbl:get rn cn)
      # create a new data element
      trans td (afnix:xml:XmlTag AFNIX:APX:XML-TCOL-NAME)
      td:parse xval
      # add the data in the row
      tr:add-child td
    }
    # add the row in the table
    tbl:add-child tr
  }
  # here is the table
  eval tbl
}
