/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-24 15:03:58 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _PDBCONFIGURATIONBUILDER_H_
#define _PDBCONFIGURATIONBUILDER_H_

#include <Foundation/Foundation.h>
#include <AdunKernel/AdunDataMatrix.h>
#include <MolTalk/MolTalk.h>
#include "ULFramework/ULConfigurationBuilder.h"
#include "ULFramework/ULIOManager.h"


/** 
ULConfigurationBuilder subclass for PDB files
\ingroup classes
*/

@interface PDBConfigurationBuilder: NSObject <ULConfigurationBuilding>
{
	FILE* buildOutput;
	id ioManager;
	id plugin;
	id structure;
	NSMutableString* buildString;
	NSString* pluginName;
	NSString* moleculePath;
	NSDictionary* nameMap; 	  //!< dictionary mapping old pdb names to new
	NSMutableArray* availablePlugins;
}
/**
Returns an instance initialised with the molecule at path.
Return nil if file not found or invalid. If path
is nil returns a default configuration builder instance
*/
- (id) initWithMoleculeAtPath: (NSString*) path;
@end

@interface PDBConfigurationBuilder (PluginExtensions) <ULConfigurationPreprocessing>
@end

#endif // _PDBCONFIGURATIONBUILDER_H_

