/*
 * This Source Code is subject to the terms of the Mozilla Public License
 * version 2.0 (the "License"). You can obtain a copy of the License at
 * http://mozilla.org/MPL/2.0/.
 */

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cr = Components.results;
const Cu = Components.utils;

Cu.import("resource://gre/modules/Services.jsm");

let addonData = null;

function install(params, reason) {}
function uninstall(params, reason) {}

function startup(params, reason)
{
	addonData = params;
	if (Services.vc.compare(Services.appinfo.platformVersion, "10.0") < 0)
	{
		Components.manager.addBootstrappedManifestLocation(params.installPath);
		onShutdown.add(function() Components.manager.removeBootstrappedManifestLocation(params.installPath));
	}
	Services.obs.addObserver(RequireObserver, "elemhidehelper-require", true);
	onShutdown.add(function() Services.obs.removeObserver(RequireObserver, "elemhidehelper-require"));

	require("main");
}

function shutdown(params, reason)
{
	let windowNames = ["ehh:about", "ehh:composer"];
	for (let i = 0; i < windowNames.length; i++)
	{
		let enumerator = Services.wm.getEnumerator(windowNames[i]);
		while (enumerator.hasMoreElements())
		{
			let window = enumerator.getNext().QueryInterface(Ci.nsIDOMWindow);
			window.setTimeout("window.close()", 0); // Closing immediately might not work due to modal windows
			try
			{
				window.close();
			} catch(e) {}
		}
	}
	onShutdown.done = true;
	for (let i = shutdownHandlers.length - 1; i >= 0; i --)
	{
		try
		{
			shutdownHandlers[i]();
		}
		catch (e)
		{
			Cu.reportError(e);
		}
	}
}
let shutdownHandlers = [];
let onShutdown =
{
	done: false,
	add: function(handler)
	{
		if (shutdownHandlers.indexOf(handler) < 0)
			shutdownHandlers.push(handler);
	},
	remove: function(handler)
	{
		let index = shutdownHandlers.indexOf(handler);
		if (index >= 0)
			shutdownHandlers.splice(index, 1);
	}
};

function require(module)
{
	let scopes = require.scopes;
	if (!(module in scopes))
	{
		if (module == "info")
		{
			scopes[module] = {};
			scopes[module].exports =
			{
				addonID: addonData.id,
				addonVersion: addonData.version,
				addonRoot: addonData.resourceURI.spec,
				addonName: "elemhidehelper",
			};
		}
		else
		{
			scopes[module] = {
				Cc: Cc,
				Ci: Ci,
				Cr: Cr,
				Cu: Cu,
				require: require,
				
				onShutdown: onShutdown,
				
				exports: {}};
			Services.scriptloader.loadSubScript(addonData.resourceURI.spec + module + ".js", scopes[module]);
		}
	}
	return scopes[module].exports;
}
require.scopes = {__proto__: null};
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

let RequireObserver =
{
	observe: function(subject, topic, data)
	{
		if (topic == "elemhidehelper-require")
		{
			subject.wrappedJSObject.exports = require(data);
		}
	},

	QueryInterface: XPCOMUtils.generateQI([Ci.nsISupportsWeakReference, Ci.nsIObserver])
};