/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.acgvision.agent.action;

import com.acgvision.agent.run.Main;
import com.acgvision.core.ws.Command;
import com.acgvision.core.ws.Cpu;
import com.acgvision.core.ws.FileSystem;
import com.acgvision.core.ws.Job;
import com.acgvision.core.ws.Memory;
import com.acgvision.core.ws.Monitor;
import com.acgvision.core.ws.Script;
import com.acgvision.core.ws.Control;
import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class CheckTest {
    int NULLINPUT = -1;
    private static  String configFileName = "test/property.acg.ini";
    private static HierarchicalINIConfiguration configFile;

    public CheckTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        configFile = new HierarchicalINIConfiguration(configFileName);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    /**
     * Test of check method, of class Check.
     */
    @Test
    public void testCheck_Cpu() {
        System.out.println("check cpu");
        Cpu cpu = new Cpu();
        int result = Check.get(cpu,configFile).getCode();
       assertTrue(result>=0);
    }



    /**
     * Test of check method, of class Check.
     */
    @Test
    public void testCheck_Memory() {
        System.out.println("check memory");
        Memory mem = new Memory();
        int result = Check.get(mem,configFile).getCode();
        assertTrue(result>=0);
    }

    /**
     * Test of check method, of class Check.
     */
    @Test
    public void testCheck_FileSystem() {
        System.out.println("check fsys");
        FileSystem fsys = new FileSystem();
        fsys.setFileSystem("/");
        int result = Check.get(fsys,configFile).getCode();
        assertTrue(result>=0);
    }

    /**
     * Test of check method, of class Check.
     */
    @Test
    public void testCheck_Script() {
        System.out.println("check script");
        Script sc = new Script();
        Command cmd = new Command();
        cmd.setCommand("du");
        cmd.setDirectory("/etc");
        sc.setCommand(cmd);
        int result = Check.get(sc).getCode();
        assertTrue(result>=0);
    }

    /**
     * Test of check method, of class Check.
     */
    @Test(expected = UnsupportedOperationException.class)
    public void testCheck_Job() {
        System.out.println("check");
        Job job = null;
        Check.check(job);
        fail("The test case should have thrown an exception.");
    }

    /**
     * Test of sendMeasure method, of class Check.
     */
    @Test
    public void testSendMeasure() {
        System.out.println("sendMeasure");
        int value = 0;
        Monitor monitor = null;
       
    }

      /**
     * Test of check method, of class Check.
     */
    @Test
    public void testCheckNull_Cpu() {
        System.out.println("check cpu");
        Cpu cpu =null;
        int result = Check.get(cpu,configFile).getCode();
       assertTrue(result<0);
    }



    /**
     * Test of check method, of class Check.
     */
    @Test
    public void testCheckNull_Memory() {
        System.out.println("check memory null");
        Memory mem =null;
        int result = Check.get(mem,configFile).getCode();
        assertEquals(result,NULLINPUT);
    }

    /**
     * Test of check method, of class Check.
     */
    @Test
    public void testCheckNull_FileSystem() {
        System.out.println("check fsys null");
        FileSystem fsys = null;
        int result = Check.get(fsys,configFile).getCode();
       assertEquals(result,NULLINPUT);
    }
        /**
     * Test of check method, of class Check.
     */
    @Test
    public void testCheckNullFsys_FileSystem() {
        System.out.println("check fsys null partition");
        FileSystem fsys = null;
     
        int result = Check.get(fsys,configFile).getCode();
       assertEquals(result,NULLINPUT);

        fsys = new FileSystem();
        fsys.setFileSystem("");
        result = Check.get(fsys,configFile).getCode();
        assertTrue(result<0);
        fsys.setFileSystem("/doesnotexists");
        result = Check.get(fsys,configFile).getCode();
        System.out.println("result ="+result);
       // assertTrue(result==0);
    }

    /**
     * Test of check method, of class Check.
     */
    @Test
    public void testCheckError_Script() {
        System.out.println("check script");
        Script sc = new Script();
        Command cmd = new Command();
        cmd.setCommand("");
        cmd.setDirectory("/etc");
        sc.setCommand(cmd);
        int result = Check.get(sc).getCode();
        assertTrue(result<0);   

        System.out.println("check script");
        sc = new Script();
        cmd = new Command();
        cmd.setCommand("du");
        cmd.setDirectory("");
        sc.setCommand(cmd);
        result = Check.get(sc).getCode();
        assertTrue(result<0);

        System.out.println("check script");
        sc = new Script();
        sc.setCommand(null);
        result = Check.get(sc).getCode();
        assertTrue(result<0);
        System.out.println("check script");
        
        sc = null;
        result = Check.get(sc).getCode();
        assertEquals(result,NULLINPUT);

    }

    @Test
    public void testEncoding(){
        Command c =new Command();
        c.setCommand("echo testvalue");
        c.setDirectory(".");
        Script sc = new Script();
        sc.setCommand(c);
        ExecResult result= Check.get(sc);
        System.out.println(result.getText());
        assertTrue(!result.getText().equals(""));
        c.setCommand("echo second test");
        result= Check.get(sc);
        assertTrue(!result.getText().equals(""));
    }


    @Test
    public void testState(){
            Monitor m = new Monitor();
            Control c = new Control();
             Control c1 = new Control();
        try {
            File f = new File("/tmp/acgvision.test.testState.ini");
            if(f.exists())f.delete();
            f.createNewFile();
            Main.setConfigFile( new HierarchicalINIConfiguration(f.getAbsoluteFile()));
            Main.getConfigFile().clear();
            Main.getConfigFile().save();

            assertFalse(Check.getState(null, null));
            assertFalse(Check.getState(null, c));
            assertFalse(Check.getState(m, null));
            m.setId(123L);
            c.setId(124L);
            c1.setId(125L);
            assertFalse(Check.getState(m, c));
            Check.setState(m, c, false);
            assertFalse(Check.getState(m, c));
            Check.setState(m, c, true);
            assertTrue(Check.getState(m, c));
            assertFalse(Check.getState(m, c1));
            //With a second one
            Check.setState(m, c1, true);
            assertTrue(Check.getState(m, c));
            assertTrue(Check.getState(m, c1));
            f.delete();
  } catch (IOException ex) {
            System.out.println(ex);
           fail(ex.getMessage());
        } catch (ConfigurationException ex) {
            System.out.println(ex);
           fail(ex.getMessage());
        }
    }
}
