/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.acgvision.agent.run;

import com.acgvision.agent.action.HostActions;
import com.acgvision.agent.action.MeasureSpooler;
import com.acgvision.agent.action.Send;


import com.acgvision.core.ws.Host;
import com.acgvision.core.ws.User;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;


import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration.Node;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class Main {
    private static String VERSION = "5.1.4";
    /**
     * TreeSet of jobs to run. The TreeSet is an ordered method so
     */

   // private static Manager manager;
    private static final Logger logger = Logger.getLogger(Main.class);
    public static Host host;
    private static String configFileName;
    private static HierarchicalINIConfiguration configFile;
    private final static String HOSTSECTIONNAME = "Host";
    private final static String HOSTKEYIDNAME = "Id";
    public static Send sender = new Send();
    public static MeasureSpooler measuresSpooler = null;



    private static boolean RegisterNewHost(User user) {
        //on enregistre le nouvel hôte
        host = new Host();
        host.setOwner(user);
        host.setOperatingSystem(HostActions.getOsName());
        try {

            host.setHostName(HostActions.getHostname());
        } catch (UnknownHostException ex) {
            logger.fatal("Error occured while getting hostname and IP.",ex);
            host.setHostName("hostnameerror");
        }
        try {

            host.setIp(HostActions.getFirstIp());
        } catch (SocketException ex) {
            logger.fatal("Error occured while getting hostname and IP.",ex);
            host.setIp("iperror");
        }


        host = sender.registerHost(host);
        if (host.getId() != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Sauvegarde de l'id :" + host.getId());
            }
            List<Node> nodes = new ArrayList<Node>();
            nodes.add(new Node(HOSTSECTIONNAME));
            getConfigFile().addNodes(HOSTSECTIONNAME, nodes);//on ajoute la section
            if (getConfigFile().getSection(HOSTSECTIONNAME).getLong(HOSTKEYIDNAME, -1) != -1) {
                getConfigFile().getSection(HOSTSECTIONNAME).setProperty(HOSTKEYIDNAME, host.getId());//on modifie la propriété
            } else {
                getConfigFile().getSection(HOSTSECTIONNAME).addProperty(HOSTKEYIDNAME, host.getId());//on ajoute la propriété
            }
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("Enregistrement du fichier de config.");
                }
                getConfigFile().save();
            } catch (ConfigurationException ex) {
                logger.error(ex);
            }
            host.setId(getConfigFile().getSection(HOSTSECTIONNAME).getLong(HOSTKEYIDNAME, null));
        }

        if (host.getId() == null) {
            logger.fatal("Erreur lors de la récupération de l'id de l'hôte.");
            return false;
        }
        return true;
    }

    /**
     * Logs user and registers a server.
     * @return true on success
     */
    private static boolean init() {
        final String SERVERSECTIONNAME = "Server";
        final String SERVERKEYIDNAME = "address";
        final String SERVERKEYPROTOCOLENAME = "protocole";
        final String SERVERKEYPORTNAME = "port";
        final String HOSTMEASURETIMEBUFFER = "measurebuffer";
        final String SERVERKEYPROXYHOST = "proxyhost";
        final String SERVERKEYPROXYPORT = "proxyport";
        final String SERVERKEYPROXYUSER = "proxyuser";
        final String SERVERKEYPROXYPASSWORD = "proxypassword";

        String server =getConfigFile().getSection(SERVERSECTIONNAME).getString(SERVERKEYIDNAME,"localhost");
        if(server.isEmpty()){
            logger.info("Web service Server invalid");
            return false;
        }
        String port =getConfigFile().getSection(SERVERSECTIONNAME).getString(SERVERKEYPORTNAME,"8080");
        if(port.isEmpty()){
            logger.info("Web service port invalid");
            return false;
        }
        String protocole =getConfigFile().getSection(SERVERSECTIONNAME).getString(SERVERKEYPROTOCOLENAME,"http");
        if(protocole.isEmpty()){
            logger.info("Web service protocole invalid");
            return false;
        }
        
        //******************** PROXY

        String proxyhost =getConfigFile().getSection(SERVERSECTIONNAME).getString(SERVERKEYPROXYHOST,"");
        if(!protocole.isEmpty()){
            String proxyport =getConfigFile().getSection(SERVERSECTIONNAME).getString(SERVERKEYPROXYPORT,"3128");
            String proxyuser =getConfigFile().getSection(SERVERSECTIONNAME).getString(SERVERKEYPROXYUSER,"");
            String proxypassword =getConfigFile().getSection(SERVERSECTIONNAME).getString(SERVERKEYPROXYPASSWORD,"");
            if(logger.isInfoEnabled()){
                logger.info("Using proxy with values :"+
                        "\n host: "+proxyhost+
                        "\n port: "+proxyport +
                        "\n proxyuser: "+proxyuser +
                        "\n proxyport: "+proxypassword);
            }
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", proxyhost);
            System.setProperty("http.proxyPort",proxyport);
            if(!proxyuser.isEmpty()){
            System.setProperty("http.proxyUser",proxyuser);
            System.setProperty("http.proxyPassword", proxypassword);
            }
        }
        sender.init(protocole +"://"+server+":"+port+"/corews/AgentService?wsdl");
        String useremail = getConfigFile().getSection("User").getString("email", null);
        if (useremail == null) {
            logger.fatal("Please Initialize User email in configuration file.");
            return false;
        }
       if(logger.isInfoEnabled()) logger.info("Read email: " + useremail);
        User user = new User();
        user.setEmail(useremail);
        user = sender.log(user);
        if (user == null){
            return false;
        }
        host = new Host();
        host.setId(getConfigFile().getSection(HOSTSECTIONNAME).getLong(HOSTKEYIDNAME,-1));

        if (host.getId() == -1) {
            logger.warn("Registering new host");
            RegisterNewHost(user);
        } else {
           if(logger.isInfoEnabled()) logger.info("Getting host" + host.getId() +" informations");
            host = sender.getHost(host.getId());
            if (host == null) {
                logger.info("Host id is not valid, trying to get new one.");
                RegisterNewHost(user);
            }
        }
        if (host == null) {
            logger.fatal("Error while getting host.");
            return false;
        }
        Main.measuresSpooler = new MeasureSpooler (sender);
        Main.measuresSpooler.setSendingFrequence(getConfigFile().getSection(HOSTSECTIONNAME).getLong(HOSTMEASURETIMEBUFFER,60000L));
        if (logger.isInfoEnabled()){
            logger.info("Send measures every " + Main.measuresSpooler.getSendingFrequence()/1000 + " seconds.");
        }
        Main.measuresSpooler.generateNextTimeToSend();
        return true;
    }



    /**
     * Generates command line options.
     * @return Options
     */
    private static Options generateOptions() {
        // create Options object
        Options options = new Options();
        Option help = new Option("help", "print this message");
        Option version = new Option("version", "print the version information and exit");
        Option configurationfile = new Option("configurationfile", "Path to the coniguration file");

        configurationfile.setArgs(1);
        configurationfile.setOptionalArg(true);

        options.addOption(help);
        options.addOption(version);
        options.addOption(configurationfile);
        return options;
    }

    /**
     * Print help
     * @param options
     */
    private static void printHelp(Options options) {
        if (options != null) {
            HelpFormatter formatter = new HelpFormatter();
            String example = "java -jar agent.jar [OPTIONs]\n" +
                    "ex:  java -jar agent.jar -configurationfile /tmp/property.acg.ini";
            formatter.printHelp(example, "Where OPTIONs are:", options, "");
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        //configuration du logger
        if(System.getProperty("log4j.configuration")!=null){
            PropertyConfigurator.configure(System.getProperty("log4j.configuration"));
            logger.debug("Using custom log4j");
        }
       // System.setProperty("javax.net.ssl.trustStore", "/home/remi/NetBeansProjects/test/jssecacerts");
       // System.setProperty("javax.net.ssl.trustStorePassword", "changeit");

        logger.warn("Démarrage de l'agent");
        logger.info("Lecture des arguments");
        //An  Options  object must be created and the Option must be added to it.
        Options options = null;
        try {
            options = generateOptions();
            // add t option
            CommandLineParser parser = new GnuParser();
            CommandLine cmd = parser.parse(options, args);
            //The parse methods of CommandLineParser are used to parse the command
            //line arguments. The PosixPaser is great when you need to handle options
            //that are one character long, like the t option in this example.
            if (cmd.hasOption("version")) {
                
                System.out.println("ACGVision agent service");
                System.out.println("version: "+ VERSION);
            } else if (cmd.hasOption("help")) {
                printHelp(options);
            } else if (!cmd.hasOption("configurationfile")) {
                logger.fatal("Missing required option: configurationfile");
            } else {
                configFileName = cmd.getOptionValue("configurationfile");
              if(logger.isInfoEnabled())  logger.info("Configuration File Name : " + configFileName);
                setConfigFile(new HierarchicalINIConfiguration(configFileName));

                if (init()) {
                    monitor();
                }
            }
        } catch (ConfigurationException ex) {
            logger.fatal(ex);
            printHelp(options);
        } catch (ParseException ex) {
            logger.fatal("Erreur de lecture des arguments");
            logger.fatal(ex);
            printHelp(options);
        }
    }

    public static void monitor() {
        logger.warn("Démarrage du superviseur");        
        Manager manager = new Manager();
        manager.setName("Acgvision Manager");
        manager.start();
    }

    /**
     * @return the configFile
     */
    public static HierarchicalINIConfiguration getConfigFile() {
               return configFile;      
    }

  /**
   * @param aConfigFile the configFile to set
   */
    public static void setConfigFile(HierarchicalINIConfiguration aConfigFile) {
        configFile = aConfigFile;
    }

}
