// -*- C++ -*-
// $Id: LNE_Test_Receiver_exec.cpp 92902 2010-12-17 15:09:42Z mcorino $

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "LNE_Test_Receiver_exec.h"

namespace CIAO_LNE_Test_Receiver_Impl
{

  /**
   * Facet Executor Implementation Class: info_listen_data_listener_exec_i
   */

  info_listen_data_listener_exec_i::info_listen_data_listener_exec_i (
        ::LNE_Test::CCM_Receiver_Context_ptr ctx,
        Atomic_ULong &received_one_by_one,
        Atomic_ULong &received_many_by_many)
    : ciao_context_ (
        ::LNE_Test::CCM_Receiver_Context::_duplicate (ctx))
      , received_one_by_one_ (received_one_by_one)
      , received_many_by_many_ (received_many_by_many)
  {
  }

  info_listen_data_listener_exec_i::~info_listen_data_listener_exec_i (void)
  {
  }

  // Operations from ::LNE_Test::ListenNotEnabledTestConnector::Listener

  void
  info_listen_data_listener_exec_i::on_one_data (const ::ListenNotEnabledTest & /* datum */,
  const ::CCM_DDS::ReadInfo & /* info */)
  {
    // Just count; this value is checked on ccm_remove.
    ++this->received_one_by_one_;
  }

  void
  info_listen_data_listener_exec_i::on_many_data (const ::ListenNotEnabledTestSeq & /* data */,
  const ::CCM_DDS::ReadInfoSeq & /* infos */)
  {
    // Just count; this value is checked on ccm_remove.
    ++this->received_many_by_many_;
  }

  /**
   * Facet Executor Implementation Class: info_listen_status_exec_i
   */

  info_listen_status_exec_i::info_listen_status_exec_i (
        ::LNE_Test::CCM_Receiver_Context_ptr ctx)
    : ciao_context_ (
        ::LNE_Test::CCM_Receiver_Context::_duplicate (ctx))
  {
  }

  info_listen_status_exec_i::~info_listen_status_exec_i (void)
  {
  }

  // Operations from ::CCM_DDS::PortStatusListener

  void
  info_listen_status_exec_i::on_requested_deadline_missed (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::RequestedDeadlineMissedStatus & /* status */)
  {
    /* Your code here. */
  }

  void
  info_listen_status_exec_i::on_sample_lost (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::SampleLostStatus & /* status */)
  {
    /* Your code here. */
  }

  /**
   * Component Executor Implementation Class: Receiver_exec_i
   */

  Receiver_exec_i::Receiver_exec_i (void)
    : received_one_by_one_ (0)
      , received_many_by_many_ (0)
  {
  }

  Receiver_exec_i::~Receiver_exec_i (void)
  {
  }

  // Supported operations and attributes.

  // Component attributes and port operations.

  ::LNE_Test::ListenNotEnabledTestConnector::CCM_Listener_ptr
  Receiver_exec_i::get_info_listen_data_listener (void)
  {
    if ( ::CORBA::is_nil (this->ciao_info_listen_data_listener_.in ()))
      {
        info_listen_data_listener_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          info_listen_data_listener_exec_i (
            this->ciao_context_.in (),
            this->received_one_by_one_,
            this->received_many_by_many_),
            ::LNE_Test::ListenNotEnabledTestConnector::CCM_Listener::_nil ());

          this->ciao_info_listen_data_listener_ = tmp;
      }

    return
      ::LNE_Test::ListenNotEnabledTestConnector::CCM_Listener::_duplicate (
        this->ciao_info_listen_data_listener_.in ());
  }

  ::CCM_DDS::CCM_PortStatusListener_ptr
  Receiver_exec_i::get_info_listen_status (void)
  {
    if ( ::CORBA::is_nil (this->ciao_info_listen_status_.in ()))
      {
        info_listen_status_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          info_listen_status_exec_i (
            this->ciao_context_.in ()),
            ::CCM_DDS::CCM_PortStatusListener::_nil ());

          this->ciao_info_listen_status_ = tmp;
      }

    return
      ::CCM_DDS::CCM_PortStatusListener::_duplicate (
        this->ciao_info_listen_status_.in ());
  }

  // Operations from Components::SessionComponent.

  void
  Receiver_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::LNE_Test::CCM_Receiver_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Receiver_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_activate (void)
  {
    ::CCM_DDS::DataListenerControl_var dlc =
        this->ciao_context_->get_connection_info_listen_data_control ();
    dlc->mode (::CCM_DDS::NOT_ENABLED);
  }

  void
  Receiver_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_remove (void)
  {
    if (this->received_one_by_one_.value () > 0)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: NOT ENABLED: "
                               "Received samples on one_by_one "
                               "callback while mode is NOT_ENABLED "
                               "expected <0> - received <%u>\n",
                               this->received_one_by_one_.value ()));
      }
    if (this->received_many_by_many_.value () > 0)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: NOT ENABLED: "
                               "Received samples on many_by_many "
                               "callback while mode is NOT_ENABLED "
                               "expected <0> - received <%u>\n",
                               this->received_many_by_many_.value ()));
      }
    if (this->received_one_by_one_.value () == 0   &&
        this->received_many_by_many_.value () == 0)
      {
        ACE_DEBUG ((LM_DEBUG, "NOT ENABLED: "
                               "Received no data at all."
                               "Test passed!\n"));
      }
  }

  extern "C" RECEIVER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_LNE_Test_Receiver_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Receiver_exec_i);

    return retval;
  }
}
