/*
   Copyright (C) 1997-2001 Id Software, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

#include "tvm_local.h"

#include "tvm_cmds.h"

#include "tvm_client.h"
#include "tvm_chase.h"

//==================
//TVM_Cmd_Ignore_f
//==================
static void TVM_Cmd_Ignore_f( edict_t *ent )
{
}

typedef struct
{
	char name[MAX_QPATH];
	void ( *func )( edict_t *ent );
} g_gamecommands_t;

g_gamecommands_t g_Commands[MAX_GAMECOMMANDS];

//=================
//TVM_ClientCommand
//=================
qboolean TVM_ClientCommand( tvm_relay_t *relay, edict_t *ent )
{
	char *cmd;
	int i;

	assert( ent && ent->local && ent->r.client );

	cmd = trap_Cmd_Argv( 0 );

	for( i = 0; i < MAX_GAMECOMMANDS; i++ )
	{
		if( g_Commands[i].name[0] == '\0' )
			continue;
		if( !Q_stricmp( g_Commands[i].name, cmd ) )
		{
			if( g_Commands[i].func )
				g_Commands[i].func( ent );
			return qtrue;
		}
	}

	// unknown command
	return qfalse;
}

//==================
//TVM_AddGameCommand
//==================
static void TVM_AddGameCommand( tvm_relay_t *relay, const char *name, void *callback )
{
	int i;

#ifndef NDEBUG
	// check for double add
	for( i = 0; i < MAX_GAMECOMMANDS; i++ )
	{
		if( g_Commands[i].name[0] == '\0' )
			continue;
		if( !Q_stricmp( g_Commands[i].name, name ) )
			assert( qfalse );
	}
#endif

	// find a free one and add it
	for( i = 0; i < MAX_GAMECOMMANDS; i++ )
	{
		if( g_Commands[i].name[0] == '\0' )
		{
			g_Commands[i].func = callback;
			Q_strncpyz( g_Commands[i].name, name, sizeof( g_Commands[i].name ) );
			trap_ConfigString( relay, CS_GAMECOMMANDS + i, name );
			return;
		}
	}

	TVM_RelayError( relay, "G_AddCommand: Couldn't find a free g_Commands spot for the new command\n" );
}

//==================
//TVM_RemoveGameCommands
//==================
void TVM_RemoveGameCommands( tvm_relay_t *relay )
{
	int i;

	for( i = 0; i < MAX_GAMECOMMANDS; i++ )
	{
		if( g_Commands[i].name[0] != '\0' )
		{
			g_Commands[i].func = NULL;
			g_Commands[i].name[0] = 0;
			trap_ConfigString( relay, CS_GAMECOMMANDS + i, "" );
		}
	}
}

//=================
// List of commands
//=================
typedef struct
{
	char *name;
	void ( *func )( edict_t *ent );
} gamecmd_t;

static gamecmd_t gamecmdlist[] =
{
	// chase
	{ "chaseprev", TVM_Cmd_ChasePrev },
	{ "chasenext", TVM_Cmd_ChaseNext },
	{ "chase", TVM_Cmd_ChaseCam },
	{ "camswitch", TVM_Cmd_SwitchChaseCamMode },
	{ "spec", TVM_Cmd_Ignore_f },
	{ "say", NULL },

	{ NULL, NULL }
};

//==================
//TVM_AddGameCommands
//==================
void TVM_AddGameCommands( tvm_relay_t *relay )
{
	gamecmd_t *cmd;

	for( cmd = gamecmdlist; cmd->name; cmd++ )
	{
		TVM_AddGameCommand( relay, cmd->name, cmd->func );
	}
}
