package tijmp;

import java.util.List;
import java.util.Map;
import tijmp.HeapWalkEntry;

/** An ui handler. 
 */
public interface UIHandler {

    /** Init the ui. */
    void init (ProfilerHandler ph);
    
    /** Show the heap walk result to the user. */
    void showHeapWalkResult (List<HeapWalkEntry> ls);
    
    /** GC has just finished. */
    void gcFinished ();
    
    /** Report a set of object instances. */
    void instances (Class<?> clz, Object[] objects, long[] sizes, int[] lengths);

    /** Report a set of Strings. */
    void strings (Object[] objects);
    
    /** Report a set of child objects. */
    void childObjects (Object[] childs);
    
    /** Show a set of owner objects. */
    void owners (Map<Long, OwnerInfoHeader> owners, long[] startObjects);

    /** Show some simple status. */
    void showStatus (String status);
}
