package tijmp;

/** A class to hold on to a heap walk entry.
 */
public class HeapWalkEntry {
    private Class<?> cls;
    private long count;
    private long countChange;
    private long size;
    private long sizeChange;
    
    public HeapWalkEntry (Class<?> cls, 
			  long count, long countChange, 
			  long size, long sizeChange) {
	this.cls = cls;
	this.count = count;
	this.countChange = countChange;
	this.size = size;
	this.sizeChange = sizeChange;
    }

    /** Get the class that this entry has information about. */
    public Class<?> getEntryClass () {
	return cls;
    }

    /** Get the total number of instances of the class. */
    public long getInstanceCount () {
	return count;
    }
    
    public long getInstanceChange () {
	return countChange;
    }
    
    /** Get the number of bytes the instances use. */
    public long getTotalSize () {
	return size;
    }
    
    public long getSizeChange () {
	return sizeChange;
    }
}
