/* GCC-StarPU
   Copyright (C) 2011 Institut National de Recherche en Informatique et Automatique

   GCC-StarPU is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GCC-StarPU is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC-StarPU.  If not, see <http://www.gnu.org/licenses/>.  */

#undef NDEBUG

#include <mocks.h>


/* The tasks under test.  */

static void my_pointer_task (const int *x, long long *y) __attribute__ ((task));

static void my_pointer_task_cpu (const int *, long long *)
  __attribute__ ((task_implementation ("cpu", my_pointer_task)));
static void my_pointer_task_opencl (const int *, long long *)
  __attribute__ ((task_implementation ("opencl", my_pointer_task)));

static void
my_pointer_task_cpu (const int *x, long long *y)
{
  printf ("%s: x = %p, y = %p\n", __func__, x, y);
}

static void
my_pointer_task_opencl (const int *x, long long *y)
{
  printf ("%s: x = %p, y = %p\n", __func__, x, y);
}



static void my_mixed_task (int *x, char z, const long long *y)
  __attribute__ ((task));
static void my_mixed_task_cpu (int *, char, const long long *)
  __attribute__ ((task_implementation ("cpu", my_mixed_task)));
static void my_mixed_task_opencl (int *, char, const long long *)
  __attribute__ ((task_implementation ("opencl", my_mixed_task)));

static void
my_mixed_task_cpu (int *x, char z, const long long *y)
{
  printf ("%s: x = %p, y = %p, z = %i\n", __func__, x, y, (int) z);
}

static void
my_mixed_task_opencl (int *x, char z, const long long *y)
{
  printf ("%s: x = %p, y = %p, z = %i\n", __func__, x, y, (int) z);
}



int
main (int argc, char *argv[])
{
#pragma starpu initialize

  static const char z = 0x77;
  int x[] = { 42 };
  long long *y;

  y = malloc (sizeof *y);
  *y = 77;

  struct insert_task_argument expected_pointer_task[] =
    {
      { STARPU_R,  x },
      { STARPU_RW, y },
      { 0, 0, 0 }
    };

  expected_insert_task_arguments = expected_pointer_task;

  /* Invoke the task, which should make sure it gets called with
     EXPECTED.  */
  my_pointer_task (x, y);

  assert (tasks_submitted == 1);


  /* Likewise with `my_mixed_task'.  */

  struct insert_task_argument expected_mixed_task[] =
    {
      { STARPU_RW, x },
      { STARPU_VALUE, &z, sizeof z },
      { STARPU_R,  y },
      { 0, 0, 0 }
    };

  expected_insert_task_arguments = expected_mixed_task;

  my_mixed_task (x, 0x77, y);

  assert (tasks_submitted == 2);

  free (y);

  return EXIT_SUCCESS;
}
