/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.util;

/**
 * A collection of standard params used by Update handlers
 *
 * @author ryan
 * @version $Id: UpdateParams.java 533411 2007-04-28 18:49:20Z ryan $
 * @since solr 1.2
 */
public interface UpdateParams 
{
  /** wait till the command has flushed */
  public static String WAIT_FLUSH = "waitFlush";
  
  /** wait for the search to warm up */
  public static String WAIT_SEARCHER = "waitSearcher";
  
  /** overwrite indexing fields */
  public static String OVERWRITE = "overwrite";
  
  /** Commit everything after the command completes */
  public static String COMMIT = "commit";
  
  /** Commit everything after the command completes */
  public static String OPTIMIZE = "optimize";
}
