# -*- coding: utf-8 -*-

# Copyright (c) 2008 - 2010 Lukas Hetzenecker <LuHe@gmx.at>

import sys
sys.path.append('e:\python\libs')
sys.path.append('c:\python\libs')

import sysinfo
import e32
import inbox
import socket
import contacts
import telephone
import messaging
import sysinfo
import md5
import math
from appuifw import *
from status_numbers import *

VERSION = 0.4
PORT = 18

# For hash functions
CONTACT_SEP = chr(0x1F) # Unit Separator
FIELD_SEP = chr(0x1E) # Record Separator
INFO_SEP = chr(0x1D) # Group Separator

class Mobile(object):
    def __init__(self):
        self.connected = False
        self.service = False
        self.useCanvas = False
        self.client = None

        self.inbox = inbox.Inbox(inbox.EInbox)
        self.sent = inbox.Inbox(inbox.ESent)
        self.contactDb = contacts.open()
        self.currentMessage = None
        self.__partialMessage = ""

        #FIXME: I shouldn't need this
        e32.ao_sleep(1)
        self.inbox.bind(self.newMessage)
        #telephone.call_state(self.handleCall)

        self.initUi()
        self.startService()

    def initUi(self):        
        app.title = u"Series 60 - Remote"

        if self.useCanvas:
            self.canvas = Canvas(redraw_callback=self.statusUpdate)
            app.body = self.canvas

        self.lock = e32.Ao_lock()
        app.exit_key_handler = self.exitHandler

    def statusUpdate(self, rect=None):
        if not self.useCanvas:
            return

        self.canvas.clear((255,255,255))
        if self.service:
            self.canvas.text((1,14),u"Service started",0xff0000)
        else:
            self.canvas.text((1,14),u"Service stopped",0xff0000)

        if self.connected:
            self.canvas.text((1,34), u"Connected to: " + self.client[1], 0x0000ff)
        else:
            self.canvas.text((1,34), u"No active connection", 0x0000ff)

    def startService(self):
        self.service = True
        self.statusUpdate()

        self.sock = socket.socket(socket.AF_BT, socket.SOCK_STREAM)
        self.sock.bind(('', PORT))
        self.sock.listen(1)
        
        socket.set_security(self.sock,  socket.AUTH | socket.AUTHOR)
        socket.bt_advertise_service(u"pys60_remote", self.sock, True, socket.RFCOMM)

        self.listen()

    def listen(self):
        while self.service:
            self.client = self.sock.accept()

            self.connected = True
            self.statusUpdate()

            self.fos = self.client[0].makefile("w")
            self.fis = self.client[0].makefile("r")

            self.send(NUM_CONNECTED,  PROTOCOL_VERSION)

            self.wait()
            self.quit()
            self.startService()

    def send(self, header,  *message):
        new_message = ""

        if len(message) == 1:
            new_message = unicode(message[0])
        else:
            for part in message:
                new_message += unicode(part) + str(NUM_SEPERATOR)

        length = 1000
        if len(new_message) > length:
            parts = int(math.ceil(len(new_message) / float(length)))
            sentParts = 0
            for i in range(parts):
                part = new_message[sentParts*length:sentParts*length+length]
                if sentParts == parts-1:
                    self.send(header,  part)
                else:
                    self.send(NUM_PARTIAL_MESSAGE,  part)
                sentParts += 1
            return

        try:
            self.fos.write(unicode(str(header) + str(NUM_END_HEADER) + new_message + str(NUM_END_TEXT)).encode("utf8") )
            self.fos.flush()
        except:
            try:
                self.quit()
            except:
                pass
            self.startService()

    def wait(self):
        while(True):
            try:
                print "reading..."
                data = self.fis.readline()
                print "read:",  repr(data)
                print "len:",  len(data)
            except:
                print "quit..."
                self.quit()
                self.startService()

            header = int(data.split(NUM_END_HEADER)[0])
            message = unicode(data.split(NUM_END_HEADER)[1],  "utf8")

            if (header != NUM_PARTIAL_MESSAGE and self.__partialMessage):
                message = self.__partialMessage + message
                self.__partialMessage = ""

            if (header == NUM_PARTIAL_MESSAGE):
                self.__partialMessage += message

            elif (header == NUM_HELLO_REQUEST):
                    self.send(NUM_HELLO_REPLY)

            elif (header == NUM_SYSINFO_REQUEST):
                full = bool(int(message.split(NUM_SEPERATOR)[0]))
                self.sendSysinfo(full)

            elif (header == NUM_CONTACTS_REQUEST_HASH_ALL):
                self.sendContactHash()

            elif (header == NUM_CONTACTS_REQUEST_HASH_SINGLE):
                self.sendContactHashSingle()

            elif (header == NUM_CONTACTS_REQUEST_CONTACT):
                key = int(message.split(NUM_SEPERATOR)[0])
                contact = self.contactDb[key]
                self.sendContact(contact)

            elif (header == NUM_CONTACTS_REQUEST_CONTACTS_ALL):
                self.sendAllContacts()

            elif (header == NUM_CONTACTS_ADD):
                contact = self.contactDb.add_contact()
                contact.commit()
                self.send(NUM_CONTACTS_ADD_REPLY_ID,  contact.id)
            
            elif (header == NUM_CONTACTS_DELETE):
                id = int(message)
                if id in self.contactDb.keys():
                    del self.contactDb[id]

            elif (header == NUM_CONTACTS_CHANGE_ADDFIELD):
                id = int(message.split(NUM_SEPERATOR)[0])
                type = unicode(message.split(NUM_SEPERATOR)[1])
                location = unicode(message.split(NUM_SEPERATOR)[2])
                value = unicode(message.split(NUM_SEPERATOR)[3])
                self.modifyContact("add",  id,  type,  location,  value)

            elif (header == NUM_CONTACTS_CHANGE_REMOVEFIELD):
                id = int(message.split(NUM_SEPERATOR)[0])
                type = unicode(message.split(NUM_SEPERATOR)[1])
                location = unicode(message.split(NUM_SEPERATOR)[2])
                value = unicode(message.split(NUM_SEPERATOR)[3])
                self.modifyContact("remove",  id,  type,  location,  value)

            elif (header == NUM_MESSAGE_REQUEST):
                lastId = int(message.split(NUM_SEPERATOR)[0])
                self.sendAllMessages(lastId)

            elif (header == NUM_MESSAGE_REQUEST_UNREAD):
                self.sendUnreadMessages()

            elif (header == NUM_MESSAGE_SEND_REQUEST):
                name = unicode(message.split(NUM_SEPERATOR)[0])
                phone = unicode(message.split(NUM_SEPERATOR)[1])
                msg = unicode(message.split(NUM_SEPERATOR)[2])
                self.sendMessage(name, phone, msg)

            elif (header == NUM_SET_READ):
                id = int(message.split(NUM_SEPERATOR)[0])
                state = bool(message.split(NUM_SEPERATOR)[1])
                self.setRead(id, state)

            elif (header == NUM_QUIT):
                self.send(NUM_QUIT)
                self.quit()
                self.startService()

    def sendSysinfo(self,  full):
        self.send(NUM_SYSINFO_REPLY_START)
        self.send(NUM_SYSINFO_REPLY_LINE, "program_version", VERSION)
        self.send(NUM_SYSINFO_REPLY_LINE, "battery", sysinfo.battery())
        self.send(NUM_SYSINFO_REPLY_LINE, "active_profile", sysinfo.active_profile())
        self.send(NUM_SYSINFO_REPLY_LINE, "free_ram", sysinfo.free_ram())
        self.send(NUM_SYSINFO_REPLY_LINE, "pys60_version", e32.pys60_version)

        if sysinfo.active_profile() == u"offline":
            # Return an error code if the phone is in offline mode
            self.send(NUM_SYSINFO_REPLY_LINE, "signal_dbm", -1)
            self.send(NUM_SYSINFO_REPLY_LINE, "signal_bars", -1)
        else:
            self.send(NUM_SYSINFO_REPLY_LINE, "signal_dbm", sysinfo.signal_dbm())
            self.send(NUM_SYSINFO_REPLY_LINE, "signal_bars", sysinfo.signal_bars())

        for drive,  free in sysinfo.free_drivespace().iteritems():
            self.send(NUM_SYSINFO_REPLY_LINE, "free_drivespace", str(drive) + str(free))

        if full:
            self.send(NUM_SYSINFO_REPLY_LINE, "display", str(sysinfo.display_pixels()[0]) + "x" + str(sysinfo.display_pixels()[1]))
            self.send(NUM_SYSINFO_REPLY_LINE, "imei", sysinfo.imei())
            self.send(NUM_SYSINFO_REPLY_LINE, "model", sysinfo.sw_version())
            self.send(NUM_SYSINFO_REPLY_LINE, "s60_version", e32.s60_version_info[0],  e32.s60_version_info[1] )
            self.send(NUM_SYSINFO_REPLY_LINE, "total_ram", sysinfo.total_ram())
            self.send(NUM_SYSINFO_REPLY_LINE, "total_rom", sysinfo.total_rom())

        self.send(NUM_SYSINFO_REPLY_END)

    def contactDict(self):
        keys = self.contactDb.keys()

        contactDict = dict()
        for key in keys:
            contact = self.contactDb[key]
            
            # Check for empty title (please look in the comment for sendContact)
            try:
                contact.title
            except TypeError:
                continue

            contactDict[contact.id] = list()
            for field in contact:
                _type = field.type
                value = field.value
                value = unicode(value)
                value = value.replace(u'\u2029',  u'\n') # PARAGRAPH SEPARATOR (\u2029) replaced by LINE FEED (\u000a)
                location = field.location
                
                if _type == "unknown":
                    continue
                elif _type == "thumbnail_image":
                    value = self.getContactThumbnail(contact)
                    if not value:
                        continue
                elif _type == "date":
                    value = self.getContactBirthday(contact)

                if isinstance(value, type(None)):
                   # Ignore this field
                   continue

                contactDict[contact.id].append((_type,  location,  value))
            contactDict[contact.id].sort()

        return contactDict

    def sendContactHash(self):
        contacts = self.contactDict()
        keys = contacts.keys()
        keys.sort()
        
        hash = unicode()
        
        for key in keys:
            hash += str(key)
            hash += FIELD_SEP 
            for _type,  location, value in contacts[key]:
                hash += _type + INFO_SEP + location + INFO_SEP + value
                hash += FIELD_SEP
            hash += CONTACT_SEP
        
        hash = hash.encode("utf8")
        hash = md5.md5(hash).hexdigest()
        self.send(NUM_CONTACTS_REPLY_HASH_ALL, hash)        

    def sendContactHashSingle(self):
        self.send(NUM_CONTACTS_REPLY_HASH_SINGLE_START)

        contacts = self.contactDict()
        keys = contacts.keys()
        keys.sort()
        
        for key in keys:
            hash = unicode()
            for _type,  location, value in contacts[key]:
                hash += _type + INFO_SEP + location + INFO_SEP + value
                hash += FIELD_SEP
            
            hash = hash.encode("utf8")
            hash = md5.md5(hash).hexdigest()
            self.send(NUM_CONTACTS_REPLY_HASH_SINGLE_LINE, key,  hash)
        
        self.send(NUM_CONTACTS_REPLY_HASH_SINGLE_END)

    def sendAllContacts(self):
        keys = self.contactDb.keys()

        for key in keys:
            contact = self.contactDb[key]
            self.sendContact(contact)
        self.send(NUM_CONTACTS_REPLY_CONTACTS_ALL_END)

    def sendContact(self,  contact):
        # There could be an empty entry in the contact database
        # In this case contact.title would report the following error:
        # File "c:\resource\contacts.py", line 293, in _get_title
        #   title_str += self._contact.get_field(index)['value'] + u" "
        # TypeError: unsupported operand types for +: 'NoneType' and 'unicode'
        #
        # I think the best way is to ignore such errors...
        try:
            self.send(NUM_CONTACTS_REPLY_CONTACT_START,  contact.id,  contact.title)
        except TypeError:
            return

        for field in contact:
            _type = field.type
            value = field.value
            value = unicode(value)
            value = value.replace(u'\u2029',  u'\n') # PARAGRAPH SEPARATOR (\u2029) replaced by LINE FEED (\u000a)
            location = field.location

            if _type == "unknown":
                continue
            elif _type == "thumbnail_image":
                value = self.getContactThumbnail(contact)
                if not value:
                    continue
            elif _type == "date":
                value = self.getContactBirthday(contact)

            if isinstance(value, type(None)):
               continue

            self.send(NUM_CONTACTS_REPLY_CONTACT_LINE,  contact.id,  _type,  location,  value)
        self.send(NUM_CONTACTS_REPLY_CONTACT_END,  contact.id)

    def modifyContact(self,  modification,  id,  type,  location,  value):
        try:
            contact = self.contactDb[id]
        except:
            return
        
        if type == u"thumbnail_image":
            if modification == "remove":
                self.setContactThumbnail(contact)
            else:
                self.setContactThumbnail(contact,  value)
            return
        elif type == u"date":
            if modification == "remove":
                self.setContactBirthday(contact)
            else:
                self.setContactBirthday(contact,  value)
            return
        
        contact.begin()
        
        if modification == "add":
            contact.add_field(type,  value,  location=location)
        elif modification == "remove":
            index = -1
            for field in contact.find(type,  location):
                if field.value == value:
                    index = field.index
                    break
            
            if index != -1:
                del contact[index]
        
        contact.commit()
    
    def getDetailFromVcard(self,  contact,  detail,  delimiter='\r\n'):
        # This is an ugly hack, needed for some fields that cannot be handled using the contact object
        try:
            value = unicode(contact.as_vcard(), 'utf8')
            value  = value.split(detail + ":")[1].split(delimiter)[0]
            return value
        except:
            return
    
    def setDetailFromVcard(self,  contact,  detail,  value,  delimiter='\r\n'):
        # This is an ugly hack, needed for some fields that cannot be handled using the contact object
        card = contact.as_vcard()
        
        new = u""
        for line in card.split("\r\n"):
            if line.startswith("BEGIN:") or line.startswith("VERSION:") or line.startswith("REV:") or line.startswith("UID:"):
                new += line + "\r\n"
        
        # Format value: New line (\r\n) after 64 chars, followed by 4 spaces
        if len(value) > 64:
            fmtvalue = "\r\n"
            for i in range(len(value)/64+1):
                fmtvalue += value[i*64:(i+1)*64] + "\r\n" + 4*" "
        else:
            fmtvalue = value

        new += detail + ":" + fmtvalue + delimiter
        new += "END:VCARD"
        
        changed_contact = self.contactDb.import_vcards(new)[0]
        assert changed_contact.id == contact.id
    
    def getContactThumbnail(self,  contact):
        # Ugly workaround!
        # HACK: The value of type "thumbnail_image" is empty, it is only shown when we export the contact to a vCard
        image = self.getDetailFromVcard(contact,  "PHOTO;TYPE=JPEG;ENCODING=BASE64",  "\r\n\r\n")
        if image:
            image = image.split("\r\n\r\n")[0]
            image = image.replace("\r",  "").replace("\n",  "").replace(" ",  "")
            return image
        return
    
    def setContactThumbnail(self,  contact,  image=""):
        # Ugly workaround!
        # HACK: There seems to be new other way to update/add the contact picture        
        self.setDetailFromVcard(contact,  "PHOTO;TYPE=JPEG;ENCODING=BASE64",  image,  "\r\n\r\n")

    def getContactBirthday(self,  contact):
        return self.getDetailFromVcard(contact,  "BDAY")
    
    def setContactBirthday(self,  contact,  date=""):
        # HACK: It isn't possible to set birthdays < year 1970 (before the beginning of the unix epoch)
        self.setDetailFromVcard(contact,  "BDAY",  date)

    def sendAllMessages(self,  lastId):
        messages = list()
        inbox = list()
        sent = list()
        for box in ("inbox",  "sent"):
            #FIXME: I shouldn't need this
            e32.ao_sleep(1)

            if box == "inbox":
                inbox = self.inbox.sms_messages()
            else:
                sent = self.sent.sms_messages()

        messages = inbox + sent
        messages.sort()
        for sms in messages:
            if (int(sms) > int(lastId)):
                id = sms
                time = self.inbox.time(sms)
                address = self.inbox.address(sms)
                content = self.inbox.content(sms)
                content = content.replace(u'\u2029',  u'\n') # PARAGRAPH SEPARATOR (\u2029) replaced by LINE FEED (\u000a)

                if sms in inbox:
                    box = "inbox"
                else:
                    box = "sent"

                self.send(NUM_MESSAGE_REPLY_LINE,  box,  id,  time,  address,  content)

        self.send(NUM_MESSAGE_REPLY_END)

    def sendUnreadMessages(self):
        messages = list()
        inbox = self.inbox.sms_messages()
        for sms in inbox:
            if self.inbox.unread(sms):
                messages.append(sms)
        self.send(NUM_MESSAGE_REPLY_UNREAD,  *messages)

    def sendMessage(self, name, phone, msg):
        try:
            messaging.sms_send(phone, msg,  "7bit",  self.sentMessage,  name)
        except RuntimeError,  detail:
            if str(detail) == "Already sending":
                # Workaround for the "Already sending" bug:
                # http://discussion.forum.nokia.com/forum/showthread.php?t=141083
                messaging._sending = False
                self.send(NUM_MESSAGE_SEND_REPLY_RETRY,  str(detail) + "; tried workaround")
            else:
                self.send(NUM_MESSAGE_SEND_REPLY_RETRY,  detail)

    def sentMessage(self,  status):
        if status == messaging.ECreated:
            self.send(NUM_MESSAGE_SEND_REPLY_STATUS,  "Message created.")
        elif status == messaging.EMovedToOutBox:
            self.send(NUM_MESSAGE_SEND_REPLY_STATUS,  "Moved to outbox.")
        elif status == messaging.EScheduledForSend:
            self.send(NUM_MESSAGE_SEND_REPLY_STATUS,  "Scheduled for send.")
        if status == messaging.ESent:
            self.send(NUM_MESSAGE_SEND_REPLY_STATUS,  "Message sent.")
        elif status == messaging.EDeleted:
            self.send(NUM_MESSAGE_SEND_REPLY_OK,  "The SMS message has been deleted from device's outbox queue.")
        elif status == messaging.EScheduleFailed:
            self.send(NUM_MESSAGE_SEND_REPLY_FAILURE,  "Schedule failed.")
        elif status == messaging.ESendFailed:
            self.send(NUM_MESSAGE_SEND_REPLY_FAILURE,  "The SMS subsystem has tried to send the message several times in vain.")
        elif status == messaging.ENoServiceCentre:
            self.send(NUM_MESSAGE_SEND_REPLY_FAILURE,  "No service centre.")
        elif status == messaging.EFatalServerError:
            self.send(NUM_MESSAGE_SEND_REPLY_FAILURE,  "SMS send failed! If the device is in offline-mode or with no network connection the message is added to the device's outgoing message queue.")

    def newMessage(self, sms):
        if not self.connected:
            return

        #FIXME: I shouldn't need this
        e32.ao_sleep(1)

        id = sms
        time = self.inbox.time(sms)
        address = self.inbox.address(sms)
        content = self.inbox.content(sms)

        self.send(NUM_MESSAGE_NEW, id,  time,  address,  content)

    def handleCall(self,  handle):
        state = handle[0]
        number = handle[1]
        call_state = { telephone.EStatusUnknown: "unknown",
        telephone.EStatusIdle: "idle",
        telephone.EStatusDialling: "dialing",
        telephone.EStatusRinging: "ringing",
        telephone.EStatusAnswering: "answering",
        telephone.EStatusConnecting: "connecting",
        telephone.EStatusConnected: "connected",
        telephone.EStatusReconnectPending: "reconnect pending",
        telephone.EStatusDisconnecting: "disconnecting",
        telephone.EStatusHold: "hold",
        telephone.EStatusTransferring: "transferring",
        telephone.EStatusTransferAlerting: "transfer alerting" }
        
        self.send(NUM_INCOMING_CALL, number,  call_state[state])

    def setRead(self,  id,  state):
        state = int(not state)

        #FIXME: I shouldn't need this
        e32.ao_sleep(1)

        self.inbox.set_unread(id,  state)

    def quit(self):
        print "in quit function"
        if (self.service):
            self.service = False

            self.sock.close()
            self.sock = None

        if(self.connected):
            self.connected = False

            self.fos.close()
            self.fis.close()

            self.client[0].close()
            self.client = None

            self.statusUpdate()

    def exitHandler(self):
        self.quit()

        app.exit_key_handler = None
        self.lock.signal()
        if self.useCanvas:
            self.canvas = None
        if app.full_name()[-10:] != "Python.app":
           app.set_exit()

# Debug of SIS applications
try:
   mobile = Mobile()
except Exception, e:
    # Oops, something wrong. Report problems to user
    # and ask him/her to send them to you.
    import traceback

    new_line = u"\u2029"
 
    # Collecting call stack info
    info = sys.exc_info()
    
    # Show the last 4 lines of the call stack
    call_stack = u""
    for file, lineno, function, text in traceback.extract_tb(info[2])[:4]:
        call_stack += file + u": " + str(lineno) + u" - " + function + new_line
        call_stack += u" " + repr(text) + new_line
    call_stack +=  u"%s: %s" % info[:2]
 
    # Creating a friendly user message with exception details
    err_msg = u"This programs was unexpectedly closed due to the following error: "
    err_msg += unicode(repr(e)) + new_line
    err_msg += u"Please, copy and paste the text presented here and "
    err_msg += u"send it to series60-remote-devel@lists.sourceforge.net. "
    err_msg += u"Thanks in advance and sorry for this inconvenience." + new_line*2
    err_msg += u"Call stack:" + new_line + call_stack
 
    # Small PyS60 application
    lock = e32.Ao_lock()
    app.body = Text(err_msg)
    app.body.set_pos(0)
    app.menu = [(u"Exit", lambda: lock.signal())]
    lock.wait()
