#include "rpggame.h"

#ifdef NEWGUI
//extern bool UI::activegui(const char *name);
//extern int UI::numui();
#else
extern bool activegui(const char *name);
extern int numgui();
#endif

using namespace rpgscript;
using namespace game;

namespace rpggui
{
	#ifdef NEWGUI

	bool open()
	{
		return false;
	}

	void forcegui()
	{
		if(!mapdata) return;


	}

	void refreshgui()
	{
		//reopen GUI
	}

	#else

	bool open() //forces pause when GUIs are open
	{
		return !editmode && mapdata && curmap && curmap->loaded && numgui();
	}

	void forcegui() //basically forces chat GUI
	{
		if(editmode || !mapdata || !chatscript) return;

		if(!numgui()) showgui("chat");
		else if (!activegui("chat"))
		{
			while(numgui())
			{
				cleargui(1);
				if(activegui("chat"))
					break;
			}
			if(!numgui())
				showgui("chat");
		}

	}

	void refreshgui() {}


	#endif

	ICOMMAND(r_get_dialogue, "", (),
		if(!chatscript) return;
		if(chatscript->dialogue.inrange(chatscript->pos)) result(chatscript->dialogue[chatscript->pos]->talk);
	)

	ICOMMAND(r_num_response, "", (),
		if(!chatscript) { intret(0); return; }
		if(chatscript->dialogue.inrange(chatscript->pos)) intret(chatscript->dialogue[chatscript->pos]->dests.length());
	)

	ICOMMAND(r_get_response, "i", (int *n),
		if(!chatscript) return;
		if(chatscript->dialogue.inrange(chatscript->pos) && chatscript->dialogue[chatscript->pos]->dests.inrange(*n))
			result(chatscript->dialogue[chatscript->pos]->dests[*n]->talk);
	)

	void chattrigger(int n)
	{
		if(!chatscript) return;
		if(chatscript->dialogue.inrange(chatscript->pos) && chatscript->dialogue[chatscript->pos]->dests.inrange(n))
		{
			rpgchat *chat = chatscript->dialogue[chatscript->pos];
			if(chat->dests[n]->script) execute(chat->dests[n]->script);
			chatscript->pos = clamp(chatscript->dialogue.length(), -2, chat->dests[n]->dest);

			if(chatscript->pos == -2)
			{
				chatscript->pos = -1; //FIXME - disable -2 menu for now
				conoutf("Trade GUI not implemented; exiting dialogue");
			}

			chat->close();
			if(chatscript->pos >= 0)
			{
				chatscript->dialogue[chatscript->pos]->open();
			}
			if(chatscript->pos == -1)
			{
				cleargui(1);
				chatscript = NULL;
			}
		}
	}

	ICOMMAND(r_trigger_response, "i", (int *n),
		chattrigger(*n);
	)

	ICOMMAND(r_inv_numitems, "", (),
		int num = 0;
		loopv(player1->inventory)
			if(player1->inventory[i]->quantity) num++;

		intret(num);
	)

	ICOMMAND(r_inv_getbase, "i", (int *n),
		loopv(player1->inventory)
		{
			if(player1->inventory[i]->quantity)
			{
				if(!*n)
				{
					intret(player1->inventory[i]->base);
					return;
				}
				*n = *n - 1;
			}

		}
		intret(-1);
	)

	ICOMMAND(r_inv_getequips, "", (),
		intret(player1->equipped.length());
	)

	ICOMMAND(r_inv_getequipbase, "i", (int *i),
		if(player1->equipped.inrange(*i))
			intret(player1->equipped[*i].base);
		else
			intret(-1);
	)

	ICOMMAND(r_inv_getequipuse, "i", (int *i),
		if(player1->equipped.inrange(*i))
			intret(player1->equipped[*i].use);
		else
			intret(-1);
	)

	/**

		The following commands are more like generic queries.
		They accept indices; the base and the use if applicable

	*/

	ICOMMAND(r_inv_getamnt, "i", (int *n),
		loopv(player1->inventory)
		{
			if(player1->inventory[i]->base == *n)
			{
				intret(player1->inventory[i]->quantity);
				return;
			}
		}
		intret(0);
	)

	ICOMMAND(r_inv_getweight, "i", (int *i),
		if(items.inrange(*i))
			floatret(items[*i]->weight);
		else floatret(0);
	)

	ICOMMAND(r_inv_getworth, "i", (int *i),
		if(items.inrange(*i))
			floatret(items[*i]->worth);
		else floatret(0);
	)

	ICOMMAND(r_inv_numuses, "i", (int *i),
		if(items.inrange(*i))
			intret(items[*i]->uses.length());
	)

	ICOMMAND(r_inv_getusetype, "ii", (int *i, int *u),
		if(items.inrange(*i) && items[*i]->uses.inrange(*u))
			intret(items[*i]->uses[*u]->type);
		else
			intret(-1);
	)

	ICOMMAND(r_inv_getitemname, "i", (int *i),
		if(items.inrange(*i) && items[*i]->name)
			result(items[*i]->name);
		else
			result("Tough Cookie");
	)

	ICOMMAND(r_inv_geticon, "i", (int *i),
		if(items.inrange(*i) && items[*i]->icon)
			result(items[*i]->icon);
		else
			result(DEFAULTICON);
	)

	ICOMMAND(r_inv_getdesc, "i", (int *i),
		if(items.inrange(*i) && items[*i]->description)
			result(items[*i]->description);
		else
			result("This item has no features of note.");
	)

	/*
	ICOMMAND(r_itemhotkey, "ii"
	*/

	void hotkey(int n)
	{
		if(chatscript)
			chattrigger(n);
		// else
		// 	hotkey item
		//
	}
}