#include "rpggame.h"

namespace entities
{
	vector<extentity *> ents;
	vector<extentity *> &getents() { return ents; }

	vector<int> intents;

	bool mayattach(extentity &e) { return false; }
	bool attachent(extentity &e, extentity &a) { return false; }
	int extraentinfosize() {return 0;}

	void animatemapmodel(const extentity &e, int &anim, int &basetime)
	{
		anim = ANIM_MAPMODEL|ANIM_LOOP;
	}

	extentity *newentity() { return new rpgentity(); }
	void deleteentity(extentity *e) { intents.setsize(0); delete (rpgentity *)e; }

	void genentlist() //filters all interactive ents
	{
		loopv(ents)
		{
			const int t = ents[i]->type;
			if(t == JUMPPAD)
				intents.add(i);
		}
	}

	void touchents(rpgent *d)
	{
		loopv(intents)
		{
			extentity &e = *ents[intents[i]];

			switch(e.type)
			{
				case JUMPPAD:
					if(lastmillis - d->lasttouch < 500 || d->o.dist(e.o) > (e.attr[3] ? e.attr[3] : 12)) break;

					d->falling = vec(0, 0, 0);
					d->vel.add(vec(e.attr[2], e.attr[1], e.attr[0]).mul(10));

					d->lasttouch = lastmillis;
					break;
			}
		}
	}

	void clearents()
	{
		ents.deletecontents();
		intents.setsize(0);
		//loopvrev(ents) { delete (rpgentity *) ents[i];}
		//ents.shrink(0);
	}

	const char *entmodel(const entity &e)
	{
		return NULL;
	}

	void spawn(extentity &e, int ind, int type, int qty)
	{
		rpgent *ent = NULL;
		switch(type)
		{
			case ENT_CHAR:
			{
				if(DEBUG_ENT)
					conoutf(CON_DEBUG, "DEBUG: Creating creature and instancing to type %i", ind);

				rpgchar *d = new rpgchar();
				ent = d;

				if(game::chars.inrange(ind))
					game::chars[ind]->transfer(*d);
				else
					conoutf(CON_ERROR, "ERROR: creature type %i does not exist", ind);

				break;
			}
			case ENT_ITEM:
			{
				if(DEBUG_ENT)
					conoutf(CON_DEBUG, "DEBUG: Creating item and instancing to type %i", ind);

				rpgitem *d = new rpgitem();
				ent = d;

				if(game::items.inrange(ind))
				{
					d->base = ind;
					d->quantity = qty;
				}
				else
					conoutf(CON_ERROR, "ERROR: item type %i does not exist", ind);

				break;
			}
			case ENT_OBJECT:
			{
				if(DEBUG_ENT)
					conoutf(CON_DEBUG, "DEBUG: Creating object and instancing to type %i", ind);

				rpgobject *d = new rpgobject();
				ent = d;

				if(game::objects.inrange(ind))
					game::objects[ind]->transfer(*d);
				else
					conoutf(CON_ERROR, "ERROR: object type %i does not exist", ind);

				break;
			}
		}

		ent->resetmdl();
		ent->o = e.o;

		if(e.attr[1])
		{
			ent->o.add(vec(rnd(360) * RAD, 0).mul(e.attr[1]));
			entinmap(ent);
		}
		else
		{
			ent->o.z += ent->eyeheight;
			ent->resetinterp();
		}

		ent->yaw = e.attr[0];

		game::curmap->objs.add(ent);
		rpgscript::doentscript(ent, ent, SCR_SPAWN);
	}

	void teleport(rpgent *d, int dest)
	{
		loopv(ents)
		{
			if(ents[i]->type == TELEDEST && ents[i]->attr[1] == dest)
			{
				d->yaw = ents[i]->attr[0];
				d->pitch = 0;
				d->o = ents[i]->o; d->o.z += d->eyeheight; d->newpos = d->o;
				updatedynentcache(d);
				return;
			}
		}
		conoutf("ERROR: no teleport destination %i", dest);
	}

	void entradius(extentity &e, bool &color)
	{
		switch(e.type)
		{
			case TELEDEST:
			{
				vec dir(e.attr[0] * RAD, 0);
				renderentarrow(e, dir, 12);

				break;
			}
			case JUMPPAD:
			{
				vec dir(e.attr[2], e.attr[1], e.attr[0]); dir.normalize();
				renderentarrow(e, dir, e.attr[3] ? e.attr[3] : 12);
				renderentsphere(e, e.attr[3] ? e.attr[3] : 12);

				break;
			}
			case CHECKPOINT:
			{
				vec dir(e.attr[0] * RAD, 0);
				renderentarrow(e, dir, 12);
				renderentsphere(e, e.attr[3] ? e.attr[3] : 12);

				break;
			}
			case SPAWN:
			{
				vec dir(e.attr[0] * RAD, 0);
				renderentarrow(e, dir, e.attr[1] ? e.attr[1] : 12);
				renderentring(e, e.attr[1], 0);

				break;
			}
			case CAMERA:
			{
				vec dir(e.attr[1] * RAD, e.attr[2] * RAD);
				renderentarrow(e, dir, 12);

				break;
			}
		}
	}

	bool printent(extentity &e, char *buf)
	{
		return false;
	}

	void fixentity(extentity &e)
	{
		switch(e.type)
		{
			case TELEDEST:
			case CHECKPOINT:
			case SPAWN:
				e.attr.pop();
				e.attr.insert(0, game::player1->yaw);
		}
	}

	void renderhelpertext(extentity &e, int &colour, vec &pos, string &tmp)
	{
		switch(e.type)
		{
			case TELEDEST:
				pos.z += 3.0f;
				formatstring(tmp)("Yaw: %i\nTag: %i",
					e.attr[0],
					e.attr[1]
				);
				break;
			case JUMPPAD:
				pos.z += 6.0f;
				formatstring(tmp)("Z: %i\nY: %i\nX: %i\nRadius: %i",
					e.attr[0],
					e.attr[1],
					e.attr[2],
					e.attr[3]
				);
				break;
			case CHECKPOINT:
				pos.z += 1.5f;
				formatstring(tmp)("Yaw: %i",
					e.attr[0]
				);
				break;
			case SPAWN:
			{
				pos.z += 4.5f;
				formatstring(tmp)("Yaw: %i\nRadius: %i\nTag: %i",
					e.attr[0],
					e.attr[1],
					e.attr[2]
				);
				break;
			}
			case BLIP:
				pos.z += 3.0f;
				formatstring(tmp)("Texture?: %i\nTag: %i",
					e.attr[0],
					e.attr[1]
				);
				break;
			case CAMERA:
				pos.z += 6.0f;
				formatstring(tmp)("Tag: %i\nYaw: %i\nPitch: %i\nRoll: %i",
					e.attr[0],
					e.attr[1],
					e.attr[2],
					e.attr[3]
				);
		}
	}

	const char *entname(int i)
	{
		static const char *entnames[] =
		{
			"none?", "light", "mapmodel", "playerstart", "envmap", "particles", "sound", "spotlight",
			"teledest", "jumppad", "checkpoint", "spawn", "reserved1", "reserved2", "blip", "camera", "platformroute"
		};
		return i>=0 && size_t(i)<sizeof(entnames)/sizeof(entnames[0]) ? entnames[i] : "";
	}

	const int numattrs(int type)
	{
		static const int num[] =
		{
			2, //teledest
			4, //jumppad
			1, //checkpoint
			3, //spawn
			0, //reserved
			0, //reserved
			2, //blip
			4, //camera
			1, //platformroute
		};

		type -= ET_GAMESPECIFIC;
		return type >= 0 && size_t(type) < sizeof(num)/sizeof(num[0]) ? num[type] : 0;
	}

	const char *entnameinfo(entity &e)
	{
		return "";
	}

	bool radiusent(extentity &e)
	{
		switch(e.type)
		{
			case LIGHT:
			case ENVMAP:
			case MAPSOUND:
			case JUMPPAD:
				return true;
				break;
			default:
				return false;
				break;
		}
	}

	bool dirent(extentity &e)
	{
		switch(e.type)
		{
			case MAPMODEL:
			case PLAYERSTART:
			case SPOTLIGHT:
			case TELEDEST:
			case CHECKPOINT:
			case JUMPPAD:
			case SPAWN:
			case CAMERA:
				return true;
				break;
			default:
				return false;
				break;
		}
	}

	int *getmodelattr(extentity &e)
	{
		return NULL;
	}

	bool checkmodelusage(extentity &e, int i)
	{
		return false;
	}

	void rumble(const extentity &e) {}
	void trigger(extentity &e){}
	void editent(int i, bool local) {}
	void writeent(entity &e, char *buf) {}

	void readent(entity &e, char *buf)
	{
		int version = getmapversion();
		if(version <= 30) switch(e.type)
		{
			case TELEDEST:
			case SPAWN:
				e.attr[0] = (int(e.attr[0])+180)%360;
				break;
		}
	}

	float dropheight(entity &e)
	{
		if (e.type==MAPMODEL) return 0.0f;
		return 4.0f;
	}
}