//This file will temporarily house I/O routines, ie load/save
#include "rpggame.h"

typedef hashtable<const char *, ident> identtable;
extern identtable *idents; //contains all aliases

namespace rpgio
{
	bool global = false;
	#define GAMEVERSION 4
	/**
		TODO LIST
		2. allow monsters to travel between maps
		3. allow multiple savegames
		4. save everything inside the temp directory, when savegame is evoked, save state and move temp to a slot
		5. call savestate whenever a map is changed, and loadstate when it's done changing.
		6. clear temp when the player strays away from his game
		7. merge everything into a single file?
			7.1 This does make updating it harder though :(
		8. renumerate all entities before saving; save their idents too
		9. use a loading cache of sorts to assign enemies? aka defer enemy assignation
	*/

	/**
		Current File Format for map states

		Version

		(repeat till EOF)
			saved type
				if(type is ent) ent details here
				else if(type is var) var details here
		EOF

		this is simply so that additional entities can easily be appended when appropriate


		The global file is being considered as follows

		Version
		Player's Entity
		mapname

		repeat until EOF
			load Variables
	*/

	enum
	{
		SAVE_ENT = 0,
		SAVE_VAR = 1
	};

	//these structures are for convenience
	struct save_rpgent
	{
		//dynent only has values we don't need/want

		// physent values
		vec o, vel, falling;
		vec deltapos, newpos;
		float yaw, pitch, roll;
		int timeinair;
		float radius, eyeheight, aboveeye;
		float xradius, yradius, zmargin;

		int inwater;
		bool jumping, flying;

		uchar physstate;
		uchar state;
		uchar type;
		uchar collidetype;
		int lastmove, lastmoveattempt, lastjump;

		//rpgent values
		int id, spawn, etype;
		int numchat;

		void initialise(rpgent *d)
		{
			#define _(x) x = d->x
			_(o);
			_(vel);
			_(falling);
			_(deltapos);
			_(newpos);
			_(yaw);
			_(pitch);
			_(roll);
			_(timeinair);
			_(radius);
			_(eyeheight);
			_(aboveeye);
			_(xradius);
			_(yradius);
			_(zmargin);
			_(inwater);
			_(jumping);
			_(flying);
			_(physstate);
			_(state);
			_(type);
			_(collidetype);
			_(lastmove) - lastmillis;
			_(lastmoveattempt) - lastmillis;
			_(lastjump) - lastmillis;
			_(spawn);
			_(etype);
			#undef _

			id = d->temp.id;
			numchat = d->dialogue.length();
		}

		void transfer(rpgent *d)
		{
			#define _(x) d->x = x
			_(o);
			_(vel);
			_(falling);
			_(deltapos);
			_(newpos);
			_(yaw);
			_(pitch);
			_(roll);
			_(timeinair);
			_(radius);
			_(eyeheight);
			_(aboveeye);
			_(xradius);
			_(yradius);
			_(zmargin);
			_(inwater);
			_(jumping);
			_(flying);
			_(physstate);
			_(state);
			_(type);
			_(collidetype);
			_(lastmove) + lastmillis;
			_(lastmoveattempt) + lastmillis;
			_(lastjump) + lastmillis;
			_(spawn);
			_(etype);
			#undef _

			d->temp.id = id;
		}
	};

	struct save_rpgchar
	{
		stats base, attributes;
		//attributes
		float health, mana;
		int lastpain, lastaction, lastdeath, statpoints;
		int lastmana, lasthealth;
		bool updatestats, firstattack, secondattack;

		int numprojs, numitems, numspells;
		int selectedspell;
		int selected[EQUIP_MAX];

		void initialise(rpgchar *d)
		{
			#define _(x) x = d->x

			_(base);
			_(attributes);
			_(health);
			_(mana);
			_(lastpain) - lastmillis;
			_(lastaction) - lastmillis;
			_(lastdeath) - lastmillis;
			_(statpoints);
			_(lastmana) - lastmillis;
			_(lasthealth) - lastmillis;
			_(updatestats);
			_(firstattack);
			_(secondattack);

			#undef _

			numprojs = d->projs.length();
			numitems = d->inventory.length();
			numspells = d->spellbook.length();
			selectedspell = d->selectedspell ? d->selectedspell->temp.id : -1;

			loopi(EQUIP_MAX)
			{
				selected[i] = d->selected[i] ? d->selected[i]->temp.id : -1;
			}
		}

		void transfer(rpgchar *d)
		{
			#define _(x) d->x = x

			_(base);
			_(attributes);
			_(health);
			_(mana);
			_(lastpain) + lastmillis;
			_(lastaction) + lastmillis;
			_(lastdeath) + lastmillis;
			_(statpoints);
			_(lastmana) + lastmillis;
			_(lasthealth) + lastmillis;
			_(updatestats);
			_(firstattack);
			_(secondattack);

			#undef _
		}

		//transfer part 2
		void equips(rpgchar *d)
		{
			if(selectedspell >= 0)
			{
				loopv(d->spellbook)
				{
					if(d->spellbook[i]->temp.id == selectedspell)
					{
						d->selectedspell = d->spellbook[i];
						break;
					}
				}
			}

			loopi(EQUIP_MAX)
			{
				if(selected[i] >= 0)
				{
					loopvj(d->inventory)
					{
						if(d->inventory[j]->temp.id == selected[i]);
						{
							d->selected[i] = d->inventory[j];
							break;
						}
					}
				}
			}
		}
	};

	struct save_proj
	{
		int weapon;
		vec o, d, lastemit;
		int speed, radius;
		int effect, gravity;

		void initialise(projectile *p)
		{
			weapon = p->weapon->temp.id;
			#define _(x) x = p->x;

			_(o);
			_(d);
			_(lastemit);
			_(speed);
			_(radius);
			_(effect);
			_(gravity);

			#undef _
		}

		bool transfer(rpgchar *c, projectile *p)
		{
			#define _(x) p->x = x;

			_(o);
			_(d);
			_(lastemit);
			_(speed);
			_(radius);
			_(effect);
			_(gravity);

			#undef _
			loopv(c->inventory)
			{
				if(c->inventory[i]->temp.id == weapon)
				{
					p->weapon = c->inventory[i];
					return true;
				}
			}
			loopv(c->spellbook)
			{
				if(c->spellbook[i]->temp.id == weapon)
				{
					p->weapon = c->spellbook[i];
					return true;
				}
			}
			return false;
		}
	};

	//this is presently jsut a copy of rpgitem
	struct save_rpgitem
	{
		stats requirements, equipbonus, invbonus;
		int cooldown, range, type, slots;
		int value, weight;

		void initialise(rpgitem *d)
		{
			#define _(x) x = d->x

			_(requirements);
			_(equipbonus);
			_(invbonus);
			_(cooldown);
			_(range);
			_(type);
			_(slots);
			_(value);
			_(weight);

			#undef _
		}

		void transfer(rpgitem *d)
		{
			#define _(x) d->x = x

			_(requirements);
			_(equipbonus);
			_(invbonus);
			_(cooldown);
			_(range);
			_(type);
			_(slots);
			_(value);
			_(weight);

			#undef _
		}
	};

	struct save_rpgspell
	{
		stats requirements;
		int cooldown, range, type, cost, castdelay, effect, fade, gravity;

		void initialise(rpgspell *d)
		{
			#define _(x) x = d->x

			_(requirements);
			_(cooldown);
			_(range);
			_(type);
			_(cost);
			_(castdelay);
			_(effect);
			_(fade);
			_(gravity);

			#undef _
		}

		void transfer(rpgspell *d)
		{
			#define _(x) d->x = x

			_(requirements);
			_(cooldown);
			_(range);
			_(type);
			_(cost);
			_(castdelay);
			_(effect);
			_(fade);
			_(gravity);

			#undef _
		}
	};


	struct save_rpgobject
	{
		bool active, triggered;
		int lastaction;

		void initialise(rpgobject *d)
		{
			#define _(x) x = d->x

			_(active);
			_(triggered);
			_(lastaction);

			#undef _
		}

		void transfer(rpgobject *d)
		{
			#define _(x) d->x = x

			_(active);
			_(triggered);
			_(lastaction);

			#undef _
		}
	};

	rpgent *loadent(stream *f, rpgent *rpg = NULL)
	{
		rpgent *ent = NULL;
		if(rpg)
		{
			ent = rpg;
			ent->reset();
		}
		else
			ent = new rpgent("rc", -1);

		ent->cleansubtypes();

		save_rpgent d;
		f->read(&d, sizeof(save_rpgent));
		d.transfer(ent);

		#define loadstr(x) \
		{ \
			if(x) {delete[] x; x = NULL;} \
			int length; \
			f->read(&length, sizeof(int)); \
			if(length) \
			{ \
				x = new char[length + 1]; \
				f->read((void *)x, length); \
				((char *) x)[length] = '\0'; \
			} \
		}

		loadstr(ent->model);
		loadstr(ent->name);
		loadstr(ent->description);
		loadstr(ent->icon);

		loadstr(ent->approach);
		loadstr(ent->interact);
		loadstr(ent->death);

		loopj(d.numchat)
		{
			ent->dialogue.add(new rpgchat(NULL, NULL));
			loadstr(ent->dialogue[j]->script);
			loadstr(ent->dialogue[j]->talk);
		}

		int numeffects;
		f->read(&numeffects, sizeof(int));

		loopi(numeffects)
		{
			status s = status(1,1,1,1);
			f->read(&s, sizeof(status));
			s.startmillis += lastmillis;
			ent->effects.add(new status(s));
		}

		#undef loadstr

		switch(ent->etype)
		{
			case ENT_CHAR:
			{
				ent->subtype = new rpgchar();
				rpgchar *c = (rpgchar *) ent->subtype;

				save_rpgchar sv;
				f->read(&sv, sizeof(save_rpgchar));

				sv.transfer(c);

				loopj(sv.numitems)
				{
					c->inventory.add(loadent(f));
				}
				loopj(sv.numspells)
				{
					c->spellbook.add(loadent(f));
				}
				sv.equips(c);

				loopj(sv.numprojs)
				{
					projectile *p = new projectile(NULL);

					save_proj pj;
					f->read(&pj, sizeof(save_proj));

					if(pj.transfer(c, p))
						c->projs.add(p);
					else
						delete p;
				}
				break;
			}
			case ENT_ITEM:
			{
				ent->subtype = new rpgitem();
				rpgitem *i = (rpgitem *) ent->subtype;

				save_rpgitem sv;
				f->read(&sv, sizeof(save_rpgitem));

				sv.transfer(i);
				break;
			}
			case ENT_SPELL:
			{
				ent->subtype = new rpgspell();
				rpgspell *s = (rpgspell *) ent->subtype;

				save_rpgspell sv;
				f->read(&sv, sizeof(save_rpgspell));

				sv.transfer(s);
				break;
			}
			case ENT_OBJECT:
			{
				ent->subtype = new rpgobject();
				rpgobject *o = (rpgobject *) ent->subtype;

				save_rpgobject sv;
				f->read(&sv, sizeof(save_rpgobject));

				sv.transfer(o);
				break;
			}
		}
		return ent;
	}

	void loadvar(stream *f)
	{
		int len[2];
		f->read(&len, 2 * sizeof(int));

		char *tmp[2] = {new char[len[0] + 1], new char[len[1] + 1]};
		f->read(tmp[0], len[0]);
		f->read(tmp[1], len[1]);
		tmp[0][len[0]] = tmp[1][len[1]] = '\0';

		alias(tmp[1], tmp[2]);
		ident *id = getident(tmp[1]);

		if(id->type == ID_ALIAS)
		{
			if(global)
				id->flags |= IDF_GLOBAL;
			else
				id->flags |= IDF_LOCAL;
		}

		delete[] tmp[1];
		delete[] tmp[2];
	}

	bool loadmapstate()
	{
		stream *f = NULL;
		bool clear = false;
		/*
			//the below is for opponents and creatures that travel across a map, if a state file doesn't exist
			if(exists("data/rpg/saves/temp/%s.app"))
				load that
			else
			|
			|
			V
		*/
		{
			defformatstring(file)("data/rpg/saves/temp/%s.sgz", game::getclientmap());
			path(file);

			f = opengzfile(file, "rb");
			clear = true;
		}

		if(!f)
			return false;

		int ver;
		f->read(&ver, sizeof(int));

		if(ver != GAMEVERSION)
			return false;

		if(clear)
		{
			game::rpgobjs.remove(0); //the player
			game::rpgobjs.deletecontentsp();

			game::rpgobjs.add(game::player1);
		}

		while(!f->end())
		{
			int type = f->getchar();
			switch(type)
			{
				case SAVE_ENT:
					game::rpgobjs.add(loadent(f));
					break;
				case SAVE_VAR:
					loadvar(f);
					break;
			}
		}

		delete f;

		rpgobj::renumerate();
		return true;
	}

	void loadgame()
	{
		defformatstring(file)("data/rpg/saves/temp/global.sgz");
		path(file);
		stream *f = opengzfile(file, "rb");
		if(!f)
		{
			return;
		}

		int ver = GAMEVERSION;
		f->read(&ver, sizeof(int));

		if(ver != GAMEVERSION)
			return;

		f->read(&ver, sizeof(int));
		char *map = new char[ver + 1];
		f->getline(map, ver + 1);

		load_world(map);
		delete [] map; map = NULL;

		loadent(f, game::player1);

		//load vars here
		global = true;

		while(!f->end())
		{
			loadvar(f);
		}

		global = false;
		delete f;

		//we need to set an override so load_world doesn't invoke this eventually just for the loading phase
		//we could alternatively use the transfer mechanism
		loadmapstate();
	}

	void saveent(stream *f, rpgent *ent)
	{
		save_rpgent d;
		d.initialise(ent);

		f->write(&d, sizeof(d));
		#define writestring(x) \
		{ \
			int len = 0; \
			if(x) \
			{ \
				len = strlen(x); \
				f->write(&len, sizeof(int)); \
				f->putstring(x); \
			} \
			else \
				f->write(&len, sizeof(int)); \
		}


		writestring(ent->model);
		writestring(ent->name);
		writestring(ent->description);
		writestring(ent->icon);

		writestring(ent->approach);
		writestring(ent->interact);
		writestring(ent->death);

		loopv(ent->dialogue)
		{
			writestring(ent->dialogue[i]->script);
			writestring(ent->dialogue[i]->talk);
		}

		#undef writestring

		int numeffects = ent->effects.length();
		f->write(&numeffects, sizeof(int));
		loopv(ent->effects)
		{
			status s = *ent->effects[i];
			s.startmillis -= lastmillis;
			f->write(&s, sizeof(status));
		}

		switch(ent->etype)
		{
			case ENT_CHAR:
			{
				rpgchar *c = (rpgchar *) ent->subtype;
				save_rpgchar sv;
				sv.initialise(c);

				f->write(&sv, sizeof(save_rpgchar));

				loopvj(c->inventory)
				{
					saveent(f, c->inventory[j]);
				}
				loopvj(c->spellbook)
				{
					saveent(f, c->spellbook[j]);
				}

				loopvj(c->projs)
				{
					save_proj pj;
					pj.initialise(c->projs[j]);

					f->write(&pj, sizeof(save_proj));
				}
				break;
			}
			case ENT_ITEM:
			{
				rpgitem *i = (rpgitem *) ent->subtype;
				save_rpgitem sv;
				sv.initialise(i);

				f->write(&sv, sizeof(save_rpgitem));

				break;
			}
			case ENT_SPELL:
			{
				rpgspell *s = (rpgspell *) ent->subtype;
				save_rpgspell sv;
				sv.initialise(s);

				f->write(&sv, sizeof(save_rpgspell));
				break;
			}
			case ENT_OBJECT:
			{
				rpgobject *o = (rpgobject *) ent->subtype;
				save_rpgobject sv;
				sv.initialise(o);

				f->write(&sv, sizeof(save_rpgobject));
				break;
			}
		}
	}

	void savevar(stream *f, ident *id)
	{
		int len[2] = {strlen(id->name), strlen(id->action)};

		f->write(&len, 2 * sizeof(int));
		f->putstring(id->name);
		f->putstring(id->action);
	}

	void savemapstate()
	{
		defformatstring(file)("data/rpg/saves/temp/%s.sgz", game::getclientmap());
		path(file);

		stream *f = opengzfile(file, "wb");
		if(!f)
		{
			conoutf("error, failed to open file (%s) for writing", file);
			return;
		}

		int ver = GAMEVERSION;

		f->write(&ver, sizeof(int));

		loopv(game::rpgobjs)
		{
			if(!i)
				continue;
			f->putchar(SAVE_ENT);
			saveent(f, game::rpgobjs[i]);
		}

		enumerate(*idents, ident, id,
		{
			if(id.type != ID_ALIAS || !(id.flags&IDF_LOCAL))
				continue;

			f->putchar(SAVE_VAR);

			savevar(f, &id);
		});
		delete f;
	}

	void savegame()
	{
		defformatstring(file)("data/rpg/saves/temp/global.sgz");
		path(file);
		stream *f = opengzfile(file, "wb");
		if(!f)
		{
			conoutf("failed to open file for writing %s", file);
			return;
		}

		int ver = GAMEVERSION;
		f->write(&ver, sizeof(int));

		ver = strlen(game::getclientmap());
		f->write(&ver, sizeof(int));

		f->putstring(game::getclientmap());

		saveent(f, game::player1);

		enumerate(*idents, ident, id,
			  {
				  if(id.type != ID_ALIAS || !(id.flags&IDF_GLOBAL))
					  continue;

				  savevar(f, &id);
			  });
		delete f;

		savemapstate();
	}

	COMMANDN(testgameload, loadgame, "");
	COMMANDN(testgamesave, savegame, "");

	COMMANDN(testmapload, loadmapstate, "");
	COMMANDN(testmapsave, savemapstate, "");

	void dumpprojeffects(char *n)
	{
		stream *f = openfile((n[0] ? n : "effects.cfg"), "a");
		if(!f)
			return;

		conoutf("dumping %i effects on THE END of %s", rpgobj::effects.length(), (n[0] ? n : "effects.cfg"));

		f->printf("//%i effects dumped via sandbox v%s\n\n", rpgobj::effects.length(), version);

		loopv(rpgobj::effects)
		{
			projeffect *fx = rpgobj::effects[i];

			f->printf("r_proj_new // %i\n", i);
			if(fx->mdl)
			{
				f->printf("r_proj_mdl \"%s\"\n", fx->mdl);
			}
			else
			{
				f->printf("r_proj_projpart %i\n", fx->projpart);
				f->printf("r_proj_projcol 0x%.6X\n", fx->projcol);
				f->printf("r_proj_projsize %f\n", fx->projsize);
			}

			f->printf("r_proj_basevel %i\n", fx->basevel);
			f->printf("r_proj_kickback %i\n", fx->kickback);
			f->printf("r_proj_flags %i\n", fx->flags);
			f->printf("r_proj_trailpart %i\n", fx->trailpart);
			f->printf("r_proj_trailcol 0x%.6X\n", fx->trailcol);
			f->printf("r_proj_trailfade %i\n", fx->trailfade);
			f->printf("r_proj_gravity %i\n", fx->gravity);
			f->printf("r_proj_trailsize %f\n", fx->trailsize);
			f->printf("r_proj_lightradius %i\n", fx->lightradius);
			f->printf("r_proj_lightcolour %s0x%.6X\n", (fx->lightcolour < 0) ? "-" : "", abs(fx->lightcolour));
			f->printf("r_proj_deathpart %i\n", fx->deathpart);
			f->printf("r_proj_deathpartcol 0x%.6X\n", fx->deathpartcol);
			f->printf("r_proj_deathfade %i\n", fx->deathfade);
			f->printf("r_proj_deathlightinitcol %s0x%.6X\n", (fx->deathlightinitcol < 0) ? "-" : "", abs(fx->deathlightinitcol));
			f->printf("r_proj_deathlightflags %i\n", fx->deathlightflags);
			f->printf("r_proj_deathdecal %i\n", fx->deathdecal);
			f->printf("r_proj_deathlightfade %i\n", fx->deathlightfade);
			f->printf("r_proj_deathpartsize %f\n\n", fx->deathpartsize);
		}

		delete f;
	}
	COMMAND(dumpprojeffects, "s");
}