/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class Helper {
    static final String NEWLINE = System.getProperty("line.separator");
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss Z");
    private static DateFormat xmlFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private Helper() {
    }

    static SVNUrl toSVNUrl(String string) {
        try {
            return new SVNUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    static SVNRevision.Number toRevNum(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new SVNRevision.Number(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return new SVNRevision.Number(-1L);
        }
    }

    static Date toDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            return df.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    static Date convertXMLDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            return xmlFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    static {
        xmlFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

