/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

/*
 * Created on Aug 13, 2005
 */
 
package org.jboss.test.remoting.transport.multiplex;

import java.net.InetSocketAddress;


/**
 * A MultiplexConstants.

 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 * @version $Revision: 583 $
 * <p>
 * Copyright (c) 2005
 * </p>
 */

public interface MultiplexConstants
{
   int READ 					       = 1;
   int WRITE 					       = 2;
   int SHUTDOWN_INPUT 			       = 3;
   int SHUTDOWN_OUTPUT 			       = 4;
   int SLEEP					       = 5;
   int CLOSE_TEST_SOCKET		       = 6;
   int CLOSE_SCRIPT_SOCKET		       = 7;
   int ACCEPT_SERVER_SOCKET            = 8;
   int CONNECT_TO_CLIENT		       = 10;
   int CONNECT_TO_CLIENT_VSS           = 11;
   int CONNECT_TO_CLIENT_MSS	       = 12;
   int READ_FROM_CLIENT			       = 13;
   int WRITE_TO_CLIENT			       = 14;
   int CLOSE_CLIENT_SOCKET		       = 15;
   int RUN_VIRTUALSERVERSOCKET         = 16;
   int RUN_SERVER_TIMEOUT_TEST         = 17;
   int RUN_VSS_TO_VSS                  = 18;
   int RUN_LONG_MESSAGE_TEST		   = 19;
   int RUN_MULTIPLE_READERS_TEST	   = 20;
   int END_TESTS				       = 21;
   
   String primeScenarioServerHost = "localhost";
   int primeScenarioServerPort = 9999;
   
   String basicBehaviorServerHost = "localhost";
   int basicBehaviorServerPort = 7777;
   InetSocketAddress basicBehaviorServerSocketAddress = new InetSocketAddress(basicBehaviorServerHost, basicBehaviorServerPort);
   
   int masterServerSocketPort = 6666;
   InetSocketAddress masterServerSocketAddress = new InetSocketAddress(basicBehaviorServerHost, masterServerSocketPort);
   
   String clientServerSocketHost = "localhost";
   int clientServerSocketPort = 8765;
   InetSocketAddress clientServerSocketAddress = new InetSocketAddress(clientServerSocketHost, clientServerSocketPort);
   
   int openCloseTestCount = 2;
   int IOTestCount = 100000;
  
}

