/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.remoting.transport.multiplex;

import java.net.ServerSocket;

import org.jboss.jrunit.extensions.ServerTestCase;
import org.jboss.remoting.transport.Connector;

public class LateClientShutdownTestServer extends ServerTestCase
{
   public static String serverLocatorURI = "multiplex://localhost:4455";
   public static int syncSocketPort = 5544;
   
   static class Server extends Thread
   {
      public void run()
      {
         Connector connector = new Connector(serverLocatorURI);
         try
         {
            connector.create();
            connector.start();
            System.out.println("server started");
            ServerSocket ss = new ServerSocket(syncSocketPort);
            ss.accept();
            ss.close();
            Thread.sleep(4000);
            connector.stop();
            System.out.println("server stopped");
         }
         catch (Exception e)
         {
            e.printStackTrace();
         }
      }
   }
   
   public void setUp()
   {
      new Server().start();
      System.out.println("server started");
   }
   
   public static void main(String[] args)
   {
      new Server().start();
   }
}
