/* PostInstall.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.install;

import java.awt.BorderLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

import org.grinvin.gui.icons.SvgIconManager;
import org.grinvin.preferences.GrinvinPreferences;
import org.grinvin.preferences.GrinvinPreferences.Preference;

/**
 * Class that handles postinstall tasks. Currently just preprocesses icons.
 */
public class PostInstall {
    
    public static void main(String[] args) {
        processIcons();
        System.exit(0);
    }
    
    public static void processIcons() {
        List<String> factories = getIconPaths("factories");
        List<String> generators = getIconPaths("generators");
        
        int size = factories.size() + generators.size();
        
        JProgressBar progressBar = new JProgressBar(0, size);
        JLabel label = new JLabel("Processing            ...");
        JDialog dialog = new JDialog();
        dialog.setLayout(new BorderLayout());
        dialog.add(label, BorderLayout.NORTH);
        dialog.add(progressBar, BorderLayout.SOUTH);
        dialog.pack();
        dialog.setVisible(true);
        
        label.setText("Processing factories ...");
        processIconGroup(factories, progressBar, 0);
        label.setText("Processing generators ...");
        processIconGroup(generators, progressBar, factories.size());
    }
    
    public static List<String> getIconPaths(String module) {
        List<String> icons = new ArrayList<String>();
        
        try {
            InputStream stream = PostInstall.class.getResourceAsStream("/org/grinvin/"+module+"/icons/icon-svgs");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line;
            while ((line = reader.readLine()) != null){
                icons.add("/org/grinvin/"+module+"/icons/"+line+".svg");
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        return icons;
    }
    
    public static void processIconGroup(List<String> icons, JProgressBar progressBar, int start) {
        for(String icon : icons) {
            SvgIconManager.getInstance().getIcon(icon, GrinvinPreferences.getInstance().getIntPreference(Preference.GRAPHICON_SIZE));
            start++;
            progressBar.setValue(start);
        }
    }
    
}
