/* ConjectureEntryDelegate.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.conjecture.history;

import org.grinvin.expr.Expression;
import org.grinvin.expr.ExpressionLoader;
import org.grinvin.expr.ExpressionSaver;
import org.grinvin.io.IOFormatException;
import org.grinvin.io.SectionLoader;
import org.grinvin.io.SectionSaver;

import org.jdom.Element;

/**
 *
 */
public class ConjectureEntryDelegate implements ConjectureHistoryEntryDelegate<ConjectureEntry> {
    
    public Element toElement(ConjectureEntry entry) {
        Element element = new Element("entry");
        element.setAttribute("type", entry.getType());
        element.setAttribute("time", Long.toString(entry.getTimeStamp()));
        ExpressionSaver.save(entry.getConjecture(), element);
        return element;
    }
    
    public void saveIntoWorkspace(SectionSaver ssaver, ConjectureEntry entry) {
        // do nothing
    }

    
    public ConjectureEntry fromElement(Element element, SectionLoader sloader) {
        Expression conjecture;
        try {
            conjecture = ExpressionLoader.loadExpression((Element)(element.getChildren().get(0)));
        } catch (IOFormatException ex) {
            conjecture = null;
        }
        ConjectureEntry result = new ConjectureEntry(conjecture);
        result.setTimeStamp(Long.parseLong(element.getAttributeValue("time")));
        return result;
    }

}
