/* liveice.c
 *
 * Copyright (c) 1999 Scott Manley, Barath Raghavan, Jack Moffitt, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License  
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "liveice.h"

extern int errno;

void kill_children(int signo) {
	fprintf(stderr,"Killing children...\n");
	if(killpg(0, SIGTERM) < 0) {
	  fprintf(stderr,"pid=%d pgrp=%d\n",getpid(),getpgrp());
	  perror("killpg");
	}
	exit(0);
}

void alarm_timeout(int signo){
	write_message("alarm timeout signal",1);
	signal (SIGALRM, SIG_IGN);
	signal (SIGPIPE, kill_children);
	g_conf.terminate_now=1;
}


void arm ( unsigned int secs){
	if (secs == 0) {                      /* reset */
		signal (SIGALRM, SIG_IGN);
		alarm (0);
	} else {                              /* set */
		signal (SIGALRM, alarm_timeout);
		alarm (secs);
	} 
} 



/* Fatal error Handler */
void fatal(char *text)
{
	fix_interface();
	close_soundcard();
	/* in theory sleeping will let every process clean up the interface */
	sleep(1);
	fprintf(stderr, "\n%6d:Error: %s\n\n",getpid(),text);
	if(g_conf.frontend == FE_PIPE){
		printf("SHUTDOWN\n");
	}
	exit(1);
}

/* random number generator... */
float random_number(long *irand){
	*irand=( (*irand) * RAND_MULT + RAND_ADD ) % RAND_MOD;
	return (float)(*irand)/(float)(RAND_MOD);
}

/* new system */
/* need to fix everything so the changeover is smooth */

int init_pipe(char *file,char *e_mesg){
	struct stat stats;
	if(mkfifo(file,S_IRUSR | S_IWUSR)) {
		stat(file,&stats);
#ifdef PIPE_PARANOIA
		if(!(stats.st_mode|S_IFIFO)){
			sprintf(e_mesg,"File %s already exists and is not a pipe",file);
			return 1;
		}
#endif
		if( ( stats.st_mode & ( 0600 ) ) != 0600 )  {
			sprintf(e_mesg,"Cannot read/write file %s",file);
			return 2;
		}
	}
	sprintf(e_mesg,"Successfuly set up fifo %s",file);
	return 0;
}

/* setup multiple pipes.... */
void setup_stream_pipes(void){
	int i,err;
	char mesg[4096];
 	struct stat stats;
	/* need to check the directory exists */
	if(mkdir(g_conf.pipe_dir,S_IRWXU)){
		stat(g_conf.pipe_dir,&stats);
		if( ( stats.st_mode & S_IFMT ) != S_IFDIR ) {
			sprintf(mesg,"file %s already exists and is not a directory \nIt might be an idea to fix this ;-)",g_conf.pipe_dir);
			fatal(mesg);
		}
		
		if( ( stats.st_mode & (0700) ) != 0700 ){
			sprintf(mesg,"cannot read/write/execute temporary dir %s\nThis is something you can fix for yourself",g_conf.pipe_dir);
			fatal(mesg);

		}
	}
	
	for(i=0;i<MAX_ENCODER_STREAMS;i++){
		/* move all the pipe filenames into the temp directory */
		sprintf(mesg,"%s/%s",g_conf.pipe_dir,strrchr(g_conf.e_str[i].sound_pipe,'/'));
		sprintf(mesg,"%s/%s",g_conf.pipe_dir,g_conf.e_str[i].sound_pipe);
		free(g_conf.e_str[i].sound_pipe);
		g_conf.e_str[i].sound_pipe=malloc(strlen(mesg)+2);
		strcpy(g_conf.e_str[i].sound_pipe,mesg);
		
		
		sprintf(mesg,"%s/%s",g_conf.pipe_dir,strrchr(g_conf.e_str[i].mpeg_pipe,'/'));
		sprintf(mesg,"%s/%s",g_conf.pipe_dir,g_conf.e_str[i].mpeg_pipe);
		free(g_conf.e_str[i].mpeg_pipe);
		g_conf.e_str[i].mpeg_pipe=malloc(strlen(mesg)+2);
		strcpy(g_conf.e_str[i].mpeg_pipe,mesg);
		
		/* only do the setup if channel is enabled */
		if(g_conf.e_str[i].enabled){
			sprintf(mesg,"Initialising pipes for stream %d",i);
			write_message(mesg,1);
			
			/* initialise sound pipe */
			err=init_pipe(g_conf.e_str[i].sound_pipe,mesg);
			write_message(mesg,1);
			
			/* initialise mpeg pipe */
			err+=init_pipe(g_conf.e_str[i].mpeg_pipe,mesg);
			write_message(mesg,1);
			if(err!=0)
				g_conf.e_str[i].enabled=0;
		}
	}
}


void shutdown_server(void){
  /* this will do something soon */
write_message("shutting Down",0);
wait(NULL);
 if(g_conf.frontend == FE_PIPE){
	 fprintf(stdout,"SHUTDOWN\n");
 }
}


int main(int argc, char *argv[])
{
        int shmid;
        write_message("do_config()...",1);
	/* ok I'm allocating the shared memory immediately*/
	/*
	shmat(shmget(IPC_PRIVATE,4096,IPC_EXCL|IPC_CREAT);
	*/
	do_config(argc, argv);

	if(setpgid(0,0) < 0) {
	  perror("setpgid");
	  exit(1);
	}
	
	/* ok if someone's set frontend=2 then just redirect all our streams*/
	if(g_conf.frontend==FE_NONE){
	  
	  close(0);
	  close(1);
	  close(2);
	  open("/dev/null", O_RDONLY);
	  open("/dev/null", O_WRONLY);
	  open("/dev/null", O_WRONLY);
	  if(fork())  exit(0); 
	  setsid();
	  
	}
	signal (SIGPIPE, kill_children);
	signal (SIGTERM, kill_children);


	write_message("...... done",1);
        write_message("setup_pipes()...",1);

	setup_stream_pipes();

        write_message(".... done.",1);
        write_message("encode()...",1);

	encoding();
	shutdown_server();
	exit(0);
}
