/*
 * Decompiled with CFR 0.152.
 */
package org.antlr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DecisionProbe;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.codegen.CodeGenerator;
import org.antlr.runtime.misc.Stats;
import org.antlr.tool.DOTGenerator;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarReport;
import org.antlr.tool.Rule;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tool {
    public static final String VERSION = "3.0b5";
    public static final String UNINITIALIZED_DIR = "<unset-dir>";
    public static boolean internalOption_PrintGrammarTree = false;
    public static boolean internalOption_PrintDFA = false;
    public static boolean internalOption_ShowNFConfigsInDFA = false;
    public static boolean internalOption_watchNFAConversion = false;
    protected List grammarFileNames;
    protected boolean generate_NFA_dot;
    protected boolean generate_DFA_dot;
    protected String outputDirectory;
    protected String libDirectory;
    protected boolean debug;
    protected boolean trace;
    protected boolean profile;
    protected boolean report;
    protected boolean printGrammar;
    protected boolean forceAllFilesToOutputDir;

    public static void main(String[] args) {
        ErrorManager.info("ANTLR Parser Generator  Version 3.0b5 (November 15, 2006)  1989-2006");
        Tool antlr = new Tool(args);
        antlr.process();
        System.exit(0);
    }

    public void processArgs(String[] args) {
        if (args == null || args.length == 0) {
            Tool.help();
            return;
        }
        int i = 0;
        while (i < args.length) {
            File outDir;
            if (args[i].equals("-o") || args[i].equals("-fo")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing output directory with -fo/-o option; ignoring");
                } else {
                    if (args[i].equals("-fo")) {
                        this.forceAllFilesToOutputDir = true;
                    }
                    this.outputDirectory = args[++i];
                    if (this.outputDirectory.endsWith("/") || this.outputDirectory.endsWith("\\")) {
                        this.outputDirectory = this.outputDirectory.substring(0, this.outputDirectory.length() - 1);
                    }
                    if ((outDir = new File(this.outputDirectory)).exists() && !outDir.isDirectory()) {
                        ErrorManager.error(6, this.outputDirectory);
                        this.libDirectory = ".";
                    }
                }
            } else if (args[i].equals("-lib")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing library directory with -lib option; ignoring");
                } else {
                    this.libDirectory = args[++i];
                    if (this.libDirectory.endsWith("/") || this.libDirectory.endsWith("\\")) {
                        this.libDirectory = this.libDirectory.substring(0, this.libDirectory.length() - 1);
                    }
                    if (!(outDir = new File(this.libDirectory)).exists()) {
                        ErrorManager.error(5, this.libDirectory);
                        this.libDirectory = ".";
                    }
                }
            } else if (args[i].equals("-verbose")) {
                DecisionProbe.verbose = true;
            } else if (args[i].equals("-nfa")) {
                this.generate_NFA_dot = true;
            } else if (args[i].equals("-dfa")) {
                this.generate_DFA_dot = true;
            } else if (args[i].equals("-debug")) {
                this.debug = true;
            } else if (args[i].equals("-trace")) {
                this.trace = true;
            } else if (args[i].equals("-report")) {
                this.report = true;
            } else if (args[i].equals("-profile")) {
                this.profile = true;
            } else if (args[i].equals("-print")) {
                this.printGrammar = true;
            } else if (args[i].equals("-message-format")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing output format with -message-format option; using default");
                } else {
                    ErrorManager.setFormat(args[++i]);
                }
            } else if (args[i].equals("-Xgrtree")) {
                internalOption_PrintGrammarTree = true;
            } else if (args[i].equals("-Xdfa")) {
                internalOption_PrintDFA = true;
            } else if (args[i].equals("-Xnoprune")) {
                DFAOptimizer.PRUNE_EBNF_EXIT_BRANCHES = false;
            } else if (args[i].equals("-Xnocollapse")) {
                DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES = false;
            } else if (args[i].equals("-Xdbgconversion")) {
                NFAToDFAConverter.debug = true;
            } else if (args[i].equals("-Xmultithreaded")) {
                NFAToDFAConverter.SINGLE_THREADED_NFA_CONVERSION = false;
            } else if (args[i].equals("-Xnomergestopstates")) {
                DFAOptimizer.MERGE_STOP_STATES = false;
            } else if (args[i].equals("-Xdfaverbose")) {
                internalOption_ShowNFConfigsInDFA = true;
            } else if (args[i].equals("-Xwatchconversion")) {
                internalOption_watchNFAConversion = true;
            } else if (args[i].equals("-XdbgST")) {
                CodeGenerator.EMIT_TEMPLATE_DELIMITERS = true;
            } else if (args[i].equals("-Xm")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing max recursion with -Xm option; ignoring");
                } else {
                    NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK = Integer.parseInt(args[++i]);
                }
            } else if (args[i].equals("-Xmaxdfaedges")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing max number of edges with -Xmaxdfaedges option; ignoring");
                } else {
                    DFA.MAX_STATE_TRANSITIONS_FOR_TABLE = Integer.parseInt(args[++i]);
                }
            } else if (args[i].equals("-Xconversiontimeout")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing max time in ms -Xconversiontimeout option; ignoring");
                } else {
                    DFA.MAX_TIME_PER_DFA_CREATION = Integer.parseInt(args[++i]);
                }
            } else if (args[i].equals("-X")) {
                Tool.Xhelp();
            } else if (args[i].charAt(0) != '-') {
                this.grammarFileNames.add(args[i]);
            }
            ++i;
        }
    }

    public void process() {
        int numFiles = this.grammarFileNames.size();
        int i = 0;
        while (i < this.grammarFileNames.size()) {
            block12: {
                String grammarFileName = (String)this.grammarFileNames.get(i);
                if (numFiles > 1) {
                    System.out.println(grammarFileName);
                }
                try {
                    GrammarReport report;
                    FileReader fr = null;
                    try {
                        fr = new FileReader(grammarFileName);
                    }
                    catch (IOException ioe) {
                        ErrorManager.error(7, grammarFileName);
                        break block12;
                    }
                    BufferedReader br = new BufferedReader(fr);
                    Grammar grammar = new Grammar(this, grammarFileName, br);
                    grammar.setWatchNFAConversion(internalOption_watchNFAConversion);
                    br.close();
                    fr.close();
                    this.processGrammar(grammar);
                    if (this.printGrammar) {
                        grammar.printGrammar(System.out);
                    }
                    if (this.generate_NFA_dot) {
                        this.generateNFAs(grammar);
                    }
                    if (this.generate_DFA_dot) {
                        this.generateDFAs(grammar);
                    }
                    if (this.report) {
                        report = new GrammarReport(grammar);
                        System.out.println(report.toString());
                        System.out.println(report.getBacktrackingReport());
                        System.out.println(report.getEarlyTerminationReport());
                    }
                    if (this.profile) {
                        report = new GrammarReport(grammar);
                        Stats.writeReport("grammar.stats", report.toNotifyString());
                    }
                    String lexerGrammarStr = grammar.getLexerGrammar();
                    if (grammar.type == 4 && lexerGrammarStr != null) {
                        String lexerGrammarFileName = grammar.name + "__.g";
                        Writer w = this.getOutputFile(grammar, lexerGrammarFileName);
                        w.write(lexerGrammarStr);
                        w.close();
                        StringReader sr = new StringReader(lexerGrammarStr);
                        Grammar lexerGrammar = new Grammar();
                        lexerGrammar.setTool(this);
                        File lexerGrammarFullFile = new File(grammar.getFileDirectory(), lexerGrammarFileName);
                        lexerGrammar.setFileName(lexerGrammarFullFile.toString());
                        lexerGrammar.importTokenVocabulary(grammar);
                        lexerGrammar.setGrammarContent(sr);
                        sr.close();
                        this.processGrammar(lexerGrammar);
                    }
                }
                catch (Exception e) {
                    ErrorManager.error(10, (Object)grammarFileName, e);
                }
            }
            ++i;
        }
    }

    protected void processGrammar(Grammar grammar) {
        String language = (String)grammar.getOption("language");
        if (language != null) {
            CodeGenerator generator = new CodeGenerator(this, grammar, language);
            grammar.setCodeGenerator(generator);
            generator.setDebug(this.debug);
            generator.setProfile(this.profile);
            generator.setTrace(this.trace);
            generator.genRecognizer();
        }
    }

    protected void generateDFAs(Grammar g) {
        int d = 1;
        while (d <= g.getNumberOfDecisions()) {
            DFA dfa = g.getLookaheadDFA(d);
            if (dfa != null) {
                DOTGenerator dotGenerator = new DOTGenerator(g);
                String dot = dotGenerator.getDOT(dfa.startState);
                String dotFileName = g.name + "_dec-" + d;
                try {
                    this.writeDOTFile(g, dotFileName, dot);
                }
                catch (IOException ioe) {
                    ErrorManager.error(14, (Object)dotFileName, ioe);
                }
            }
            ++d;
        }
    }

    protected void generateNFAs(Grammar g) {
        DOTGenerator dotGenerator = new DOTGenerator(g);
        Collection rules = g.getRules();
        Iterator itr = rules.iterator();
        while (itr.hasNext()) {
            Rule r = (Rule)itr.next();
            String ruleName = r.name;
            try {
                this.writeDOTFile(g, ruleName, dotGenerator.getDOT(g.getRuleStartState(ruleName)));
            }
            catch (IOException ioe) {
                ErrorManager.error(1, ioe);
            }
        }
    }

    protected void writeDOTFile(Grammar g, String name, String dot) throws IOException {
        Writer fw = this.getOutputFile(g, name + ".dot");
        fw.write(dot);
        fw.close();
    }

    private static final void help() {
        System.err.println("usage: java org.antlr.Tool [args] file.g [file2.g file3.g ...]");
        System.err.println("  -o outputDir          specify output directory where all output is generated");
        System.err.println("  -fo outputDir         same as -o but force even files with relative paths to dir");
        System.err.println("  -lib dir              specify location of token files");
        System.err.println("  -report               print out a report about the grammar(s) processed");
        System.err.println("  -print                print out the grammar without actions");
        System.err.println("  -debug                generate a parser that emits debugging events");
        System.err.println("  -profile              generate a parser that computes profiling information");
        System.err.println("  -nfa                  generate an NFA for each rule");
        System.err.println("  -dfa                  generate a DFA for each decision point");
        System.err.println("  -message-format name  specify output style for messages");
        System.err.println("  -X                    display extended argument list");
    }

    private static final void Xhelp() {
        System.err.println("  -Xgrtree               print the grammar AST");
        System.err.println("  -Xdfa                  print DFA as text ");
        System.err.println("  -Xnoprune              do not test EBNF block exit branches");
        System.err.println("  -Xnocollapse           collapse incident edges into DFA states");
        System.err.println("  -Xdbgconversion        dump lots of info during NFA conversion");
        System.err.println("  -Xmultithreaded        run the analysis in 2 threads");
        System.err.println("  -Xnomergestopstates    do not merge stop states");
        System.err.println("  -Xdfaverbose           generate DFA states in DOT with NFA configs");
        System.err.println("  -Xwatchconversion      print a message for each NFA before converting");
        System.err.println("  -XdbgST                put tags at start/stop of all templates in output");
        System.err.println("  -Xm m                  max number of rule invocations during conversion");
        System.err.println("  -Xmaxdfaedges m        max \"comfortable\" number of edges for single DFA state");
        System.err.println("  -Xconversiontimeout t  set NFA conversion timeout for each decision");
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public Writer getOutputFile(Grammar g, String fileName) throws IOException {
        if (this.outputDirectory == null) {
            return new StringWriter();
        }
        File outputDir = new File(this.outputDirectory);
        String fileDirectory = g.getFileDirectory();
        if (this.outputDirectory != UNINITIALIZED_DIR) {
            outputDir = fileDirectory != null && (new File(fileDirectory).isAbsolute() || fileDirectory.startsWith("~")) || this.forceAllFilesToOutputDir ? new File(this.outputDirectory) : (fileDirectory != null ? new File(this.outputDirectory, fileDirectory) : new File(this.outputDirectory));
        } else {
            String dir = ".";
            if (fileDirectory != null) {
                dir = fileDirectory;
            }
            outputDir = new File(dir);
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        FileWriter fw = new FileWriter(new File(outputDir, fileName));
        return new BufferedWriter(fw);
    }

    public BufferedReader getLibraryFile(String fileName) throws IOException {
        String fullName = this.libDirectory + File.separator + fileName;
        FileReader fr = new FileReader(fullName);
        BufferedReader br = new BufferedReader(fr);
        return br;
    }

    public String getLibraryDirectory() {
        return this.libDirectory;
    }

    public void panic() {
        throw new Error("ANTLR panic");
    }

    public static String getCurrentTimeStamp() {
        GregorianCalendar calendar = new GregorianCalendar();
        int y = calendar.get(1);
        int m = calendar.get(2) + 1;
        int d = calendar.get(5);
        int h = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        String sy = String.valueOf(y);
        String sm = m < 10 ? "0" + m : String.valueOf(m);
        String sd = d < 10 ? "0" + d : String.valueOf(d);
        String sh = h < 10 ? "0" + h : String.valueOf(h);
        String smin = min < 10 ? "0" + min : String.valueOf(min);
        String ssec = sec < 10 ? "0" + sec : String.valueOf(sec);
        return sy + "-" + sm + "-" + sd + " " + sh + ":" + smin + ":" + ssec;
    }

    private final /* synthetic */ void this() {
        this.grammarFileNames = new ArrayList();
        this.generate_NFA_dot = false;
        this.generate_DFA_dot = false;
        this.outputDirectory = UNINITIALIZED_DIR;
        this.libDirectory = ".";
        this.debug = false;
        this.trace = false;
        this.profile = false;
        this.report = false;
        this.printGrammar = false;
        this.forceAllFilesToOutputDir = false;
    }

    public Tool() {
        this.this();
    }

    public Tool(String[] args) {
        this.this();
        this.processArgs(args);
    }
}

