use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

## If this is being installed with Atoms of with Ifeffit, then
## $ENV{INSTALLING_WITH} will be set by Atoms' topmost Makefile.PL.
my $blib;
SWITCH : {
  $blib = "blib",       last SWITCH if (not $ENV{INSTALLING_WITH});
  $blib = "../blib",    last SWITCH if ($ENV{INSTALLING_WITH} eq 'atoms');
  $blib = "../blib",    last SWITCH if ($ENV{INSTALLING_WITH} eq 'horae');
  $blib = "../../blib", last SWITCH if ($ENV{INSTALLING_WITH} eq 'ifeffit');
};

#print "In CromerMann:  blib=$blib\n";

WriteMakefile(
	      'NAME'	       => 'Xray::Scattering',
	      'DISTNAME'       => 'Scattering',
	      'VERSION_FROM'   => 'Scattering.pm', # finds $VERSION
               dist            => { COMPRESS => 'gzip -f', SUFFIX => 'gz' },
	      'PL_FILES'       => {
				   'cromann.PL'    => 'cromann.db',
				   'waaskirf.PL'   => 'waaskirf.db',
				  },
	      'PM'             => {
				   'Scattering.pm' => "$blib/lib/Xray/Scattering.pm",
				   'None.pm'       => "$blib/lib/Xray/Scattering/None.pm",
				   'CromerMann.pm' => "$blib/lib/Xray/Scattering/CromerMann.pm",
				   'cromann.db'    => "$blib/lib/Xray/Scattering/cromann.db",
				   'WaasKirf.pm'   => "$blib/lib/Xray/Scattering/WaasKirf.pm",
				   'waaskirf.db'   => "$blib/lib/Xray/Scattering/waaskirf.db",
				  },
	     );
