/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: dbgf_ext.c,v $
   $Locker:  $	$Name:  $	$State: Exp $

ob(ject): suppl_log_terminate
su(bsystem): debug
ty(pe): 
sh(ort description): Terminate the application with a message in the logs
he(ader files): 
lo(ng description): Terminates the application logging the passed in
	string and "application terminated by debug system" (both without
	any class), then terminates the application with DBG_EXIT_CODE.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
in(itialized by): 
wa(rning): 
bu(gs): 
fi(le): dbgf_chg.c

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <process.h>
#endif
#include <portable.h>

#include "suppldbg.loc"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: dbgf_ext.c,v 1.1 2006/06/17 03:25:00 blairdude Exp $";
#endif

void suppl_log_terminate(suppl_log_csptr_t loginfo)
{	if(loginfo)
		suppl_log_log(loginfo);
	suppl_log_log("Application terminated by debug system");
	exit(DBG_EXIT_CODE);
}
