package org.inria.bmajwatcher.server.dto;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.inria.biomaj.session.bank.BiomajSQLQuerier;
import org.inria.biomaj.sql.SQLConnection;
import org.inria.biomaj.sql.SQLConnectionFactory;


/**
 * Returns the X last errors and warnings.
 *  
 * @author rsabas
 *
 */
public class ErrorRetriever {
	
	
	/**
	 * Returns the latest x error/warning messages as an xml
	 * string following the smargwt RestDataSource syntax.
	 * 
	 * @param messageMax maximum number of messages to retrieve
	 * @return
	 */
	public static String getMessages(String messageMax) {
		int messageCount;
		try {
			messageCount = Integer.valueOf(messageMax);
		} catch (NumberFormatException ex) {
			messageCount = 20;
		}
		
		int id = 1;
		StringBuilder xmlOutput = new StringBuilder();
		SQLConnection connection = SQLConnectionFactory.getConnection();
		List<Map<String, String>> messages = BiomajSQLQuerier.getLastMessages(messageCount);
		
		
		int actualMessages = 0; // In case of orphan messages
		for (Map<String, String> message : messages) {
			String type = message.get(BiomajSQLQuerier.MESSAGE_TYPE);
			String description = StringEscapeUtils.escapeXml(message.get(BiomajSQLQuerier.MESSAGE));
			String idMessage = message.get(BiomajSQLQuerier.MESSAGE_ID);
			
			
			String query = "SELECT ref_idsession FROM session_has_message WHERE ref_idmessage=" + idMessage;
			Statement stat = connection.getStatement();
			try {
				ResultSet rs = connection.executeQuery(query, stat);
				if (rs.next()) {
					actualMessages++;
					List<String> ls = BiomajSQLQuerier.getSessionBankAndDate(rs.getLong(1));
					xmlOutput.append("<record iderror=\"" + id++ + "\" bank=\"" + ls.get(0) + "\" " +
							"type=\"" + type + "\" source=\"Session\" " + "log=\"" + getLogFromSessionId(rs.getLong(1), connection) + "\" " +
							"message=\"" + description + "\" date=\"" + ls.get(1) + "\" />");
					SQLConnectionFactory.closeConnection(stat);
				} else {
					SQLConnectionFactory.closeConnection(stat);
					query = "SELECT ref_idsessionTask FROM sessionTask_has_message WHERE ref_idmessage=" + idMessage;
					stat = connection.getStatement();
					rs = connection.executeQuery(query, stat);
					if (rs.next()) {
						actualMessages++;
						int taskId = rs.getInt(1);
						List<String> ls = BiomajSQLQuerier.getTaskBankAndDate(taskId);
						
						query = "SELECT taskType FROM sessionTask WHERE idsessionTask=" + taskId;
						rs = connection.executeQuery(query, stat);
						rs.next();
						String taskType = rs.getString(1);
						
						xmlOutput.append("<record iderror=\"" + id++ + "\" bank=\"" + ls.get(0) + "\" " +
								"type=\"" + type + "\" source=\"" + taskType + "\" " + "log=\"" + getLogFromTaskId(taskId, connection) + "\" " +
								"message=\"" + description + "\" date=\"" + ls.get(1) + "\" />");
						
						SQLConnectionFactory.closeConnection(stat);
					} else {
						SQLConnectionFactory.closeConnection(stat);
						query = "SELECT ref_idprocess FROM process_has_message WHERE ref_idmessage=" + idMessage;
						stat = connection.getStatement();
						rs = connection.executeQuery(query, stat);
						if (rs.next()) {
							actualMessages++;
							List<String> ls = BiomajSQLQuerier.getProcessBankAndDate(rs.getInt(1));
							xmlOutput.append("<record iderror=\"" + id++ + "\" bank=\"" + ls.get(0) + "\" " +
									"type=\"" + type + "\" source=\"Process\" " + "log=\"" + getLogFromProcessId(rs.getInt(1), connection) + "\" " +
									"message=\"" + description + "\" date=\"" + ls.get(1) + "\" />");
							SQLConnectionFactory.closeConnection(stat);
						} else {
							SQLConnectionFactory.closeConnection(stat);
							query = "SELECT ref_idmetaprocess FROM metaprocess_has_message WHERE ref_idmessage=" + idMessage;
							stat = connection.getStatement();
							rs = connection.executeQuery(query, stat);
							if (rs.next()) {
								actualMessages++;
								List<String> ls = BiomajSQLQuerier.getMetaprocessBankAndDate(rs.getString(1));
								xmlOutput.append("<record iderror=\"" + id++ + "\" bank=\"" + ls.get(0) + "\" " +
										"type=\"" + type + "\" source=\"Metaprocess\" " + "log=\"" + getLogFromMetaId(rs.getString(1), connection) + "\" " +
										"message=\"" + description + "\" date=\"" + ls.get(1) + "\" />");
							}
							SQLConnectionFactory.closeConnection(stat);
						}
					}
				}
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		
		xmlOutput.append("</data></response>");
		String header =  "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
			+ "<response>" +
			"<status>0</status>" +
			"<startRow>0</startRow>" +
			"<endRow>" + actualMessages + "</endRow>" +
			"<totalRows>" + actualMessages + "</totalRows>" +
			"<data>\n";
		
		return (header + xmlOutput.toString());
	}
	
	private static String getLogFromSessionId(long id, SQLConnection c) throws SQLException {
		Statement s = c.getStatement();
		ResultSet rs = c.executeQuery("SELECT logfile FROM session WHERE idsession=" + id, s);
		String res = "";
		if (rs.next())
			res = rs.getString(1);
		SQLConnectionFactory.closeConnection(s);
		return truncateURL(res);
	}
	
	private static String getLogFromTaskId(long id, SQLConnection c) throws SQLException {
		Statement s = c.getStatement();
		ResultSet rs = c.executeQuery("SELECT logfile FROM session WHERE idsession=(" +
				"SELECT ref_idsession FROM session_has_sessionTask WHERE ref_idsessionTask=" + id + ")", s);
		String res = "";
		if (rs.next())
			res = rs.getString(1);
		SQLConnectionFactory.closeConnection(s);
		return truncateURL(res);
	}
	
	private static String getLogFromMetaId(String id, SQLConnection c) throws SQLException {
		Statement s = c.getStatement();
		ResultSet rs = c.executeQuery("SELECT logfile FROM metaprocess WHERE idmetaprocess='" + id + "'", s);
		String res = "";
		if (rs.next())
			res = rs.getString(1);
		SQLConnectionFactory.closeConnection(s);
		return truncateURL(res);
	}
	
	private static String getLogFromProcessId(long id, SQLConnection c) throws SQLException {
		Statement s = c.getStatement();
		ResultSet rs = c.executeQuery("SELECT logfile FROM metaprocess WHERE idmetaprocess=(" +
				"SELECT ref_idmetaprocess FROM process WHERE idprocess=" + id + ")", s);
		String res = "";
		if (rs.next())
			res = rs.getString(1);
		SQLConnectionFactory.closeConnection(s);
		return truncateURL(res);
	}
	
	/**
	 * Returns the url in the right format to be browsable by tomcat.
	 * 
	 * @return
	 */
	private static String truncateURL(String _url) {
		if (!_url.trim().isEmpty()) {
			String url = _url;
			// Get the 3 last /
			url = url.substring(0, url.lastIndexOf('/'));
			url = url.substring(0, url.lastIndexOf('/'));
			int index = url.lastIndexOf('/') + 1;
			
			return "logs/" + _url.substring(index);
		}
		return "";
	}
}
