package org.inria.bmajwatcher.server.dto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.inria.biomaj.exe.bank.BankFactory;
import org.inria.biomaj.exe.bank.BiomajBank;
import org.inria.biomaj.session.bank.Bank;
import org.inria.biomaj.session.bank.BiomajSQLQuerier;
import org.inria.biomaj.session.bank.Configuration;
import org.inria.biomaj.session.bank.ProductionDirectory;
import org.inria.biomaj.session.bank.Session;
import org.inria.biomaj.session.process.BiomajProcess;
import org.inria.biomaj.session.process.MetaProcess;
import org.inria.biomaj.singleton.BiomajInformation;
import org.inria.biomaj.utils.BiomajConst;
import org.inria.biomaj.utils.BiomajException;
import org.inria.biomaj.utils.BiomajUtils;
import org.inria.bmajwatcher.server.JobSerializer;


public class BankRetriever {
	
	public static final String RELEASE = "_release";
	public static final String SESSION_COUNT = "_sessionCount";
	public static final String LAST_SESSION = "_lastSession";
	public static final String DURATION = "_duration";
	public static final String PROD_DIR = "_prodDir";
	public static final String PROD_DIRS = "_prodDirs";
	public static final String FILE_DOWNLOAD_COUNT = "_downloadCount";
	public static final String BANDWIDTH = "_bandwidth";
	public static final String DOWNLOAD_SIZE = "_downloadSize";
	public static final String BANK_SIZE = "_bankSize";
	public static final String LAST_LOG = "_logFile";
	public static final String PREPROCESSES = "_preProcesses";
	public static final String POSTPROCESSES = "_postProcesses";
	public static final String URL = "_url";
	
	public static final String BANK_NAME = BiomajSQLQuerier.BANK_NAME;
	public static final String DB_FULLNAME = BiomajSQLQuerier.DB_FULLNAME;
	public static final String DATE = BiomajSQLQuerier.DATE;
	public static final String SERVER = BiomajSQLQuerier.SERVER;
	public static final String REMOTE_FILES = BiomajSQLQuerier.REMOTE_FILES;
	public static final String REMOTE_EXCLUDED_FILES = BiomajSQLQuerier.REMOTE_EXCLUDED_FILES;
	public static final String LOCAL_FILES = BiomajSQLQuerier.LOCAL_FILES;
	public static final String VERSION_DIRECTORY = BiomajSQLQuerier.VERSION_DIRECTORY;
	public static final String OFFLINE_DIRECTORY = BiomajSQLQuerier.OFFLINE_DIRECTORY;
	public static final String HAS_LOG_FILE = BiomajSQLQuerier.HAS_LOG_FILE;
	
	
	private static BankRetriever bankRetriever = new BankRetriever();
	
//	private static Logger log = Logger.getLogger(BankRetriever.class);
	
	private int error = 0;
	private int total = 0;
	private int updating = 0;
	private Map<Integer, List<String>> records;
	
	private final Lock lock = new ReentrantLock();
	
	public static BankRetriever getInstance() {
		return bankRetriever;
	}
	
	public String getBankInfo(String bankName, String parentId) {
		int id = 1;
		StringBuilder sb = new StringBuilder(1000);
		sb.append("<response><status>0</status><data>");
		String toRetrieve = "0";
		
		if (parentId.equals("null")) { // Generate the whole structure
			
			records = new HashMap<Integer, List<String>>();
			int bankId = BiomajSQLQuerier.getBankId(bankName);
			if (bankId >= 0) {
				/*
				 * Browse configurations
				 */
				List<Map<String, String>> configs = BiomajSQLQuerier.getConfigurations(bankId);
				List<String> confRecords = new ArrayList<String>();
				records.put(0, confRecords);
				for (Map<String, String> config : configs) {
					List<String> confDetails = new ArrayList<String>();
					
					String tmp = "";
					tmp += "<record id=\"" + id++ + "\" ";
					tmp += "parent=\"" + 0 + "\" ";
					tmp += "value=\"Configuration [" + config.get(BiomajSQLQuerier.DATE) + "]\" />";
					
					confRecords.add(tmp);
					int currentConfig = id - 1;
					
//					tmp = "";
//					tmp += "<record id=\"" + id++ + "\" ";
//					tmp += "parent=\"" + currentConfig + "\" ";
//					tmp += "value=\"Date : " + config.get(BiomajSQLQuerier.DATE) + "\" />";
//					confDetails.add(tmp);
					
					tmp = "";
					tmp += "<record id=\"" + id++ + "\" ";
					tmp += "parent=\"" + currentConfig + "\" ";
					tmp += "value=\"File : " + config.get(BiomajSQLQuerier.FILE) + "\" />";
					confDetails.add(tmp);
					
					records.put(currentConfig, confDetails);
					
					/*
					 * Browse updates
					 */
					List<Map<String, String>> updates = BiomajSQLQuerier.getConfigUpdates(Long.valueOf(config.get(BiomajSQLQuerier.CONFIGURATION_ID)));
					for (Map<String, String> update : updates) {
						tmp = "";
						tmp += "<record id=\"" + id++ + "\" ";
						tmp += "parent=\"" + currentConfig + "\" ";
						tmp += "value=\"Update [Release = " + update.get(BiomajSQLQuerier.UPDATE_RELEASE) + "]\" />";
						confDetails.add(tmp);
						
						int currentUpdate = id - 1;
						List<String> updateRecords = new ArrayList<String>();
						records.put(currentUpdate, updateRecords);
						
						tmp = "";
						tmp += "<record id=\"" + id++ + "\" ";
						tmp += "parent=\"" + currentUpdate + "\" ";
						tmp += "value=\"Updated ? " + update.get(BiomajSQLQuerier.UPDATED) + "\" />";
						updateRecords.add(tmp);
						
						tmp = "";
						tmp += "<record id=\"" + id++ + "\" ";
						tmp += "parent=\"" + currentUpdate + "\" ";
						tmp += "value=\"Start : " + update.get(BiomajSQLQuerier.UPDATE_START) + "\" />";
						updateRecords.add(tmp);
						
						tmp = "";
						tmp += "<record id=\"" + id++ + "\" ";
						tmp += "parent=\"" + currentUpdate + "\" ";
						tmp += "value=\"End : " + update.get(BiomajSQLQuerier.UPDATE_END) + "\" />";
						updateRecords.add(tmp);
						
						tmp += "<record id=\"" + id++ + "\" ";
						tmp += "parent=\"" + currentUpdate + "\" ";
						tmp += "value=\"Production directory : " + update.get(BiomajSQLQuerier.PRODUCTION_DIR_PATH) + " (" + update.get(BiomajSQLQuerier.SIZE_RELEASE) + ")\" />";
						updateRecords.add(tmp);
						
						/*
						 * Browse sessions
						 */
						List<Map<String, String>> sessions = BiomajSQLQuerier.getUpdateSessions(Integer.valueOf(update.get(BiomajSQLQuerier.UPDATE_ID)));
						for (Map<String, String> session : sessions) {
							tmp = "";
							tmp += "<record id=\"" + id++ + "\" ";
							tmp += "parent=\"" + currentUpdate + "\" ";
							tmp += "value=\"Session [Status = " + session.get(BiomajSQLQuerier.SESSION_STATUS) + "]\" />";
							updateRecords.add(tmp);
							
							int currentSession = id - 1;
							List<String> sessionRecords = new ArrayList<String>();
							records.put(currentSession, sessionRecords);
							
							tmp = "";
							tmp += "<record id=\"" + id++ + "\" ";
							tmp += "parent=\"" + currentSession + "\" ";
							tmp += "value=\"Start : " + session.get(BiomajSQLQuerier.SESSION_START) + "\" />";
							sessionRecords.add(tmp);
							
							tmp = "";
							tmp += "<record id=\"" + id++ + "\" ";
							tmp += "parent=\"" + currentSession + "\" ";
							tmp += "value=\"End : " + session.get(BiomajSQLQuerier.SESSION_END) + "\" />";
							sessionRecords.add(tmp);
							
							tmp = "";
							tmp += "<record id=\"" + id++ + "\" ";
							tmp += "parent=\"" + currentSession + "\" ";
							tmp += "value=\"Log : " + session.get(BiomajSQLQuerier.LOG_FILE) + "\" />";
							sessionRecords.add(tmp);
							
							/*
							 * Browse sessionTasks
							 */
							List<Map<String, String>> tasks = BiomajSQLQuerier.getSessionTasks(Long.valueOf(session.get(BiomajSQLQuerier.SESSION_ID)));
							for (Map<String, String> task : tasks) {
								String type = task.get(BiomajSQLQuerier.TASK_TYPE);
								tmp = "";
								tmp += "<record id=\"" + id++ + "\" ";
								tmp += "parent=\"" + currentSession + "\" ";
								tmp += "value=\"Task : " + type + " [Status = " + task.get(BiomajSQLQuerier.TASK_STATUS) + "]\" />";
								sessionRecords.add(tmp);
								
								int currentTask = id - 1;
								List<String> taskRecords = new ArrayList<String>();
								records.put(currentTask, taskRecords);
								
								tmp = "";
								tmp += "<record id=\"" + id++ + "\" ";
								tmp += "parent=\"" + currentTask + "\" ";
								tmp += "value=\"Start : " + task.get(BiomajSQLQuerier.TASK_START) + "\" />";
								taskRecords.add(tmp);
								
								tmp = "";
								tmp += "<record id=\"" + id++ + "\" ";
								tmp += "parent=\"" + currentTask + "\" ";
								tmp += "value=\"End : " + task.get(BiomajSQLQuerier.TASK_END) + "\" />";
								taskRecords.add(tmp);
								
								
								if (type.equalsIgnoreCase("release")) {
									tmp = "";
									tmp += "<record id=\"" + id++ + "\" ";
									tmp += "parent=\"" + currentTask + "\" ";
									tmp += "value=\"Value : " + task.get(BiomajSQLQuerier.VALUE) + "\" />";
									taskRecords.add(tmp);
									
								} else if (type.equalsIgnoreCase("check")) {
									tmp = "";
									tmp += "<record id=\"" + id++ + "\" ";
									tmp += "parent=\"" + currentTask + "\" ";
									tmp += "value=\"Files to extract : " + task.get(BiomajSQLQuerier.NB_EXTRACT) + "\" />";
									taskRecords.add(tmp);
									
									tmp = "";
									tmp += "<record id=\"" + id++ + "\" ";
									tmp += "parent=\"" + currentTask + "\" ";
									tmp += "value=\"Local online files : " + task.get(BiomajSQLQuerier.NB_LOCAL_ONLINE_FILES) + "\" />";
									taskRecords.add(tmp);
									
									tmp = "";
									tmp += "<record id=\"" + id++ + "\" ";
									tmp += "parent=\"" + currentTask + "\" ";
									tmp += "value=\"Local offline files : " + task.get(BiomajSQLQuerier.NB_LOCAL_OFFLINE_FILES) + "\" />";
									taskRecords.add(tmp);
									
									tmp = "";
									tmp += "<record id=\"" + id++ + "\" ";
									tmp += "parent=\"" + currentTask + "\" ";
									tmp += "value=\"Files to download : " + task.get(BiomajSQLQuerier.NB_DOWNLOADED_FILES) + "\" />";
									taskRecords.add(tmp);
									
								} else if (type.equalsIgnoreCase("download")) {
									tmp = "";
									tmp += "<record id=\"" + id++ + "\" ";
									tmp += "parent=\"" + currentTask + "\" ";
									tmp += "value=\"Download speed : " + task.get(BiomajSQLQuerier.BANDWIDTH) + " MB/s\" />";
									taskRecords.add(tmp);
									
								} else if (type.equalsIgnoreCase("addLocalFiles")) {
									
								} else if (type.equalsIgnoreCase("makeRelease")) {
									tmp = "";
									tmp += "<record id=\"" + id++ + "\" ";
									tmp += "parent=\"" + currentTask + "\" ";
									tmp += "value=\"Moved files : " + task.get(BiomajSQLQuerier.NB_FILES_MOVED) + "\" />";
									taskRecords.add(tmp);
									
									tmp = "";
									tmp += "<record id=\"" + id++ + "\" ";
									tmp += "parent=\"" + currentTask + "\" ";
									tmp += "value=\"Copied files : " + task.get(BiomajSQLQuerier.NB_FILES_COPIED) + "\" />";
									taskRecords.add(tmp);
									
								} else if (type.equalsIgnoreCase("deployment")) {
									
								} else if (type.equalsIgnoreCase("preprocess") || type.equalsIgnoreCase("postprocess")) {
									
									/*
									 * Browse metaprocesses
									 */
									
									List<Map<String, String>> metas = BiomajSQLQuerier.getTaskMetaprocesses(Integer.valueOf(task.get(BiomajSQLQuerier.TASK_ID)));
									for (Map<String, String> meta : metas) {
										tmp = "";
										tmp += "<record id=\"" + id++ + "\" ";
										tmp += "parent=\"" + currentTask + "\" ";
										tmp += "value=\"Metaprocess [" + meta.get(BiomajSQLQuerier.META_NAME) + "]" +
												" [" + meta.get(BiomajSQLQuerier.META_STATUS) + "]\" />";
										taskRecords.add(tmp);
										
										int currentMeta = id - 1;
										List<String> metaRecords = new ArrayList<String>();
										records.put(currentMeta, metaRecords);
										
										tmp = "";
										tmp += "<record id=\"" + id++ + "\" ";
										tmp += "parent=\"" + currentMeta + "\" ";
										tmp += "value=\"Start : " + meta.get(BiomajSQLQuerier.META_START) + "\" />";
										metaRecords.add(tmp);
										
										tmp = "";
										tmp += "<record id=\"" + id++ + "\" ";
										tmp += "parent=\"" + currentMeta + "\" ";
										tmp += "value=\"End : " + meta.get(BiomajSQLQuerier.META_END) + "\" />";
										metaRecords.add(tmp);
										
										List<Map<String, String>> processes = BiomajSQLQuerier.getMetaprocessProcesses(meta.get(BiomajSQLQuerier.META_ID));
										for (Map<String, String> process : processes) {
											tmp = "";
											tmp += "<record id=\"" + id++ + "\" ";
											tmp += "parent=\"" + currentMeta + "\" ";
											tmp += "value=\"Process [" + process.get(BiomajSQLQuerier.PROC_NAME) + "]\" />";
											metaRecords.add(tmp);
											
											int currentPs = id - 1;
											List<String> psRecords = new ArrayList<String>();
											records.put(currentPs, psRecords);
											
											tmp = "";
											tmp += "<record id=\"" + id++ + "\" ";
											tmp += "parent=\"" + currentPs + "\" ";
											tmp += "value=\"Exe : " + process.get(BiomajSQLQuerier.PROC_EXE) + "\" />";
											psRecords.add(tmp);
											
											tmp = "";
											tmp += "<record id=\"" + id++ + "\" ";
											tmp += "parent=\"" + currentPs + "\" ";
											tmp += "value=\"Args : " + process.get(BiomajSQLQuerier.PROC_ARGS) + "\" />";
											psRecords.add(tmp);
											
											tmp = "";
											tmp += "<record id=\"" + id++ + "\" ";
											tmp += "parent=\"" + currentPs + "\" ";
											tmp += "value=\"Start : " + process.get(BiomajSQLQuerier.PROC_START) + "\" />";
											psRecords.add(tmp);
											
											tmp = "";
											tmp += "<record id=\"" + id++ + "\" ";
											tmp += "parent=\"" + currentPs + "\" ";
											tmp += "value=\"End : " + process.get(BiomajSQLQuerier.PROC_END) + "\" />";
											psRecords.add(tmp);
										}
									}
								}
							}
						}
					}
				}
				
			}
		} else
			toRetrieve = parentId;
		
		if (records.containsKey(Integer.valueOf(toRetrieve))) {
			for (String s : records.get(Integer.valueOf(toRetrieve))) {
				sb.append(s);
			}
		}
		sb.append("</data></response>");
		
		return sb.toString();
	}
	
	
	/**
	 * Returns a string that contains the bank list in XML format.
	 */
	public String getBankList() {
		lock.lock();
		
		int _error = 0;
		int _total = 0;
		int _updating = 0;
		
		List<String> banks = BiomajSQLQuerier.getBanks();
		List<Map<String, String>> data = new ArrayList<Map<String,String>>();
		int size = 0;
		Map<String, String> tmpUpdate = null;
		for (String bank : banks) {
			if ((tmpUpdate = BiomajSQLQuerier.getLatestUpdateWithProductionDirectory(bank)) == null)
				continue;
			
			
			Map<String, String> tmp = BiomajSQLQuerier.getBankInfo(bank);
			tmp.put(BiomajSQLQuerier.UPDATE_RELEASE, tmpUpdate.get(BiomajSQLQuerier.UPDATE_RELEASE));
			
			Map<String, String> updateForSession = BiomajSQLQuerier.getLatestUpdate(bank, false);
			Map<String, String> lastSession = BiomajSQLQuerier.getUpdateSessions(
					Integer.valueOf(updateForSession.get(BiomajSQLQuerier.UPDATE_ID))).get(0);
			tmp.put(BiomajSQLQuerier.SESSION_STATUS, lastSession.get(BiomajSQLQuerier.SESSION_STATUS));
			tmp.put(BiomajSQLQuerier.SESSION_START, lastSession.get(BiomajSQLQuerier.SESSION_START));
			
			size++;
			data.add(tmp);
		}
		
		StringBuilder xmlOutput = new StringBuilder();
		xmlOutput.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
				+ "<response>" +
						"<status>0</status>" +
						"<startRow>0</startRow>" +
						"<endRow>" + size + "</endRow>" +
						"<totalRows>" + size + "</totalRows>" +
						"<data>\n");
		
		for (Map<String, String> bank : data) {
			_total++;
			String formats = "";
			try {
				BiomajBank b = new BankFactory().createBank(bank.get(BiomajSQLQuerier.BANK_NAME), false);
				if (b.getPropertiesFromBankFile().containsKey(BiomajConst.dbFormatsProperty))
					formats = b.getPropertiesFromBankFile().getProperty(BiomajConst.dbFormatsProperty);
			} catch (BiomajException e1) {
				e1.printStackTrace();
			}
			xmlOutput.append("<record id=\"" + bank.get(BiomajSQLQuerier.BANK_ID) + "\" " +
					"name=\"" + bank.get(BiomajSQLQuerier.BANK_NAME) + "\" " +
					"formats=\"" + formats + "\" " +
					"type=\"" + bank.get(BiomajSQLQuerier.DB_TYPE) + "\" status=\"");
			
			String tmpDir = "";
			try {
				tmpDir = BiomajInformation.getInstance().getProperty(BiomajInformation.TMPDIR);
				if (!tmpDir.startsWith("/"))
					tmpDir = System.getProperty("BIOMAJ_ROOT") + "/" + tmpDir.substring(1);
			} catch (BiomajException e) {
				tmpDir = System.getProperty("BIOMAJ_ROOT") + "/tmp";
				e.printStackTrace();
			}
			if (new File(tmpDir + "/" + bank.get(BiomajSQLQuerier.BANK_NAME) + ".lock").exists()) {
				xmlOutput.append("Updating\" ");
				_updating++;
			}
			else {
				if (bank.get(BiomajSQLQuerier.SESSION_STATUS).equalsIgnoreCase("true")) {
					xmlOutput.append("OK\" ");
				} else {
					xmlOutput.append("KO\" ");
					_error++;
				}
			}
			
			String image = "sched.png";
			if (isScheduled(bank.get(BiomajSQLQuerier.BANK_NAME)))
				xmlOutput.append("isSched=\"" + image + "\" ");
			else
				xmlOutput.append("isSched=\"\" ");
			
			xmlOutput.append("release=\"" + bank.get(BiomajSQLQuerier.UPDATE_RELEASE) + "\" session=\"" + bank.get(BiomajSQLQuerier.SESSION_START) + "\" />");
		}
		xmlOutput.append("</data></response>");
		
		error = _error;
		total = _total;
		updating = _updating;
		
		lock.unlock();
		return xmlOutput.toString();
	}
	
	public Map<String, String> getBankDetail(String bankName) throws BiomajException {
		
		Map<String, String> info = BiomajSQLQuerier.getBankInfo(bankName);
		
		
		Configuration config = new Configuration(info);
		info.put(URL, config.getProtocol() + "://" + config.getUrl() + "/"+config.getRemoteDirectory());
		
		List<ProductionDirectory> lPd = BiomajSQLQuerier.getAvailableProductionDirectories(bankName);

		if (lPd.size() == 0)
			return info;

		long goodSession = 0 ;
		Date t = null;
		for (ProductionDirectory pd : lPd) {
			if (t == null)
				goodSession = pd.getSession();
			else if (t.getTime()<pd.getCreationDate().getTime())
				goodSession = pd.getSession();
		}

		
		Bank b = new Bank();
		
		Map<String, String> update = BiomajSQLQuerier.getUpdateFromId(goodSession);
		if (update != null) {
			b.setLoadMessages(false);
			b.fill(update, true);
			b.setConfig(config);
			fillBank(b, info);
		}
		
		/*
		// Future release 
		b = new Bank();
		update = BiomajSQLQuerier.getLatestUpdate(bankName, true);
		if (update != null) {
			b.fillSql(update, true);
			if (b.getEnd() == null) {
				b.setConfig(config);
				printBank(b, info);
			}
		}*/
		
		if (lPd.size() > 0) {
			StringBuilder strb = new StringBuilder();
			Collections.sort(lPd);
			strb.append("<ul>");
			for (ProductionDirectory pd : lPd) {
				strb.append("<li>" + BiomajUtils.dateToString(pd.getCreationDate(), Locale.getDefault())+ " " + pd.getPath() + "</li>");
			}
			strb.append("</ul>");
			info.put(PROD_DIRS, strb.toString());
		}
		
		return info;
	}
	
	
	private void fillBank(Bank b, Map<String, String> info) throws BiomajException {
		
		info.put(RELEASE, b.getWorkflowInfoRelease());
		info.put(SESSION_COUNT, Integer.toString(b.getListOldSession().size()));
		if (b.getEnd()!=null) {
			info.put(LAST_SESSION, BiomajUtils.dateToString(b.getEnd(), Locale.getDefault()));
			info.put(DURATION, BiomajUtils.timeToString(b.getEnd().getTime()-b.getStart().getTime()));
		}
		if (b.getWorkflowInfoProductionDir() != null)
			info.put(PROD_DIR, b.getWorkflowInfoProductionDir());

		info.put(FILE_DOWNLOAD_COUNT, String.valueOf(b.getNbFilesDownloaded()));
		info.put(BANDWIDTH, Float.toString(b.getBandWidth()));
		info.put(DOWNLOAD_SIZE, BiomajUtils.sizeToString(b.getWorkflowInfoSizeDownload()));
		info.put(BANK_SIZE, BiomajUtils.sizeToString(b.getWorkflowInfoSizeRelease()));
		
		if (b.getListOldSession().size() > 0)
			info.put(LAST_LOG, b.getListOldSession().get(b.getListOldSession().size()-1).getLogfile());

		Collection<MetaProcess> lMpPre = b.getAvailableMetaProcessSql(Session.PREPROCESS);
		StringBuilder strb = new StringBuilder();
		for (MetaProcess mpPre : lMpPre) {
			strb.append("BLOCK="+ mpPre.getBlock() + ";META=" + mpPre.getName() +";");
			for (BiomajProcess bp : mpPre.getListProcess())
				strb.append("PS=" + bp.getKeyName() + "_:_" + bp.getExe() + ";");
		}
		info.put(PREPROCESSES, strb.toString());
		
		Collection<MetaProcess> lMp = b.getAvailableMetaProcessSql(Session.POSTPROCESS);
		strb = new StringBuilder();
		for (MetaProcess mp : lMp) {
			strb.append("BLOCK="+ mp.getBlock() + ";META=" + mp.getName() +";");
			for (BiomajProcess bp : mp.getListProcess())
				strb.append("PS=" + bp.getKeyName() + "_:_" + bp.getExe() + ";");
		}
		info.put(POSTPROCESSES, strb.toString());
	}
	
	/**
	 * Checks in the jobs.xml file if the specified bank is scheduled.
	 * 
	 * @param bankName
	 * @return
	 */
	private boolean isScheduled(String bankName) {
		// We should use some kind of xml parser to properly search for the bank
		// but it is so much easier (and propably faster) to do it the basic way...
		
		try {
			BufferedReader br = new BufferedReader(new FileReader(JobSerializer.getJobsFileName()));
			String line = null;
			try {
				while ((line = br.readLine()) != null) {
					if (line.contains("name=\"" + bankName + "\""))
						return true;
				}

				br.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		return false;
	}
	
	public int getError() {
		lock.lock(); // wait for error count to be processed
		int err = error;
		lock.unlock();
		return err;
		
	}
	
	public int getUpdating() {
		lock.lock(); // wait for updating count to be processed
		int upd = updating;
		lock.unlock();
		return upd;
	}
	
	public int getTotal() {
		lock.lock(); // wait for total count to be processed
		int tot = total;
		lock.unlock();
		return tot;
	}
	
}
